/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.AbstractDateTextFieldConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class LocalDateTextFieldConfig
extends AbstractDateTextFieldConfig<LocalDateTextFieldConfig, LocalDateTime> {
    @Override
    public LocalDateTextFieldConfig withStartDate(LocalDateTime value) {
        this.put(StartDate, this.getDateAsString(value));
        return this;
    }

    @Override
    public LocalDateTextFieldConfig withEndDate(LocalDateTime value) {
        this.put(EndDate, this.getDateAsString((LocalDateTime)Args.notNull((Object)value, (String)"value")));
        return this;
    }

    private String getDateAsString(LocalDateTime value) {
        String format = this.getFormat();
        if (Strings.isEmpty((CharSequence)format)) {
            return value.toString();
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return dateTimeFormatter.format(value);
    }
}

