/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class SAML2FileSystemMetadataGenerator
extends BaseSAML2MetadataGenerator {
    @Override
    protected AbstractBatchMetadataResolver createMetadataResolver(Resource metadataResource) throws Exception {
        return new FilesystemMetadataResolver(metadataResource.getFile());
    }

    @Override
    public boolean storeMetadata(String metadata, Resource metadataResource, boolean force) throws Exception {
        if (metadataResource == null || CommonHelper.isBlank((String)metadata)) {
            logger.info("No metadata or resource is provided");
            return false;
        }
        if (!(metadataResource instanceof WritableResource)) {
            logger.warn("Unable to store metadata, as resource is not writable");
            return false;
        }
        if (metadataResource.exists() && !force) {
            logger.info("Metadata file already exists at {}.", (Object)metadataResource.getFile());
        } else {
            logger.info("Writing metadata to {}", (Object)metadataResource.getFilename());
            File parent = metadataResource.getFile().getParentFile();
            if (parent != null) {
                logger.debug("Attempting to create directory structure for: {}", (Object)parent.getCanonicalPath());
                if (!parent.exists() && !parent.mkdirs()) {
                    logger.warn("Could not construct the directory structure for metadata: {}", (Object)parent.getCanonicalPath());
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult result = new StreamResult(new StringWriter());
            StreamSource source = new StreamSource(new StringReader(metadata));
            transformer.transform(source, result);
            WritableResource destination = (WritableResource)WritableResource.class.cast(metadataResource);
            try (OutputStream spMetadataOutputStream = destination.getOutputStream();){
                spMetadataOutputStream.write(result.getWriter().toString().getBytes(StandardCharsets.UTF_8));
            }
            if (destination.exists()) {
                if (this.isSignMetadata()) {
                    this.getMetadataSigner().sign(metadataResource.getFile());
                }
                return true;
            }
        }
        return false;
    }
}

