/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFAddChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 4722916031463878423L;
    @NotNull
    private final Attribute[] attributes;

    public LDIFAddChangeRecord(@NotNull String dn, Attribute ... attributes) {
        this(dn, attributes, (List<Control>)null);
    }

    public LDIFAddChangeRecord(@NotNull String dn, @NotNull Attribute[] attributes, @Nullable List<Control> controls) {
        super(dn, controls);
        Validator.ensureNotNull(attributes);
        Validator.ensureTrue(attributes.length > 0, "LDIFAddChangeRecord.attributes must not be empty.");
        this.attributes = attributes;
    }

    public LDIFAddChangeRecord(@NotNull String dn, @NotNull List<Attribute> attributes) {
        this(dn, attributes, null);
    }

    public LDIFAddChangeRecord(@NotNull String dn, @NotNull List<Attribute> attributes, @Nullable List<Control> controls) {
        super(dn, controls);
        Validator.ensureNotNull(attributes);
        Validator.ensureFalse(attributes.isEmpty(), "LDIFAddChangeRecord.attributes must not be empty.");
        this.attributes = new Attribute[attributes.size()];
        attributes.toArray(this.attributes);
    }

    public LDIFAddChangeRecord(@NotNull Entry entry) {
        this(entry, Collections.emptyList());
    }

    public LDIFAddChangeRecord(@NotNull Entry entry, @Nullable List<Control> controls) {
        super(entry.getDN(), controls);
        Collection<Attribute> attrs = entry.getAttributes();
        this.attributes = new Attribute[attrs.size()];
        Iterator<Attribute> iterator = attrs.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = iterator.next();
        }
    }

    public LDIFAddChangeRecord(@NotNull AddRequest addRequest) {
        super(addRequest.getDN(), addRequest.getControlList());
        List<Attribute> attrs = addRequest.getAttributes();
        this.attributes = new Attribute[attrs.size()];
        Iterator<Attribute> iterator = attrs.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = iterator.next();
        }
    }

    @NotNull
    public Attribute[] getAttributes() {
        return this.attributes;
    }

    @NotNull
    public Entry getEntryToAdd() {
        return new Entry(this.getDN(), this.attributes);
    }

    @NotNull
    public AddRequest toAddRequest() {
        return this.toAddRequest(true);
    }

    @NotNull
    public AddRequest toAddRequest(boolean includeControls) {
        AddRequest addRequest = new AddRequest(this.getDN(), this.attributes);
        if (includeControls) {
            addRequest.setControls(this.getControls());
        }
        return addRequest;
    }

    @Override
    @NotNull
    public ChangeType getChangeType() {
        return ChangeType.ADD;
    }

    @Override
    @NotNull
    public LDIFAddChangeRecord duplicate(Control ... controls) {
        return new LDIFAddChangeRecord(this.getDN(), this.attributes, StaticUtils.toList(controls));
    }

    @Override
    @NotNull
    public LDAPResult processChange(@NotNull LDAPInterface connection, boolean includeControls) throws LDAPException {
        return connection.add(this.toAddRequest(includeControls));
    }

    @Override
    @NotNull
    public String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = new ArrayList<String>(2 * this.attributes.length);
        LDIFAddChangeRecord.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), ldifLines);
        for (Control c : this.getControls()) {
            LDIFAddChangeRecord.encodeNameAndValue("control", LDIFAddChangeRecord.encodeControlString(c), ldifLines);
        }
        ldifLines.add("changetype: add");
        for (Attribute a : this.attributes) {
            String name = a.getName();
            for (ASN1OctetString value : a.getRawValues()) {
                LDIFAddChangeRecord.encodeNameAndValue(name, value, ldifLines);
            }
        }
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] ldifArray = new String[ldifLines.size()];
        ldifLines.toArray(ldifArray);
        return ldifArray;
    }

    @Override
    public void toLDIF(@NotNull ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        for (Control c : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFAddChangeRecord.encodeControlString(c), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("add"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        for (Attribute a : this.attributes) {
            String name = a.getName();
            for (ASN1OctetString value : a.getRawValues()) {
                LDIFWriter.encodeNameAndValue(name, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL_BYTES);
            }
        }
    }

    @Override
    public void toLDIFString(@NotNull StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        for (Control c : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFAddChangeRecord.encodeControlString(c), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("add"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        for (Attribute a : this.attributes) {
            String name = a.getName();
            for (ASN1OctetString value : a.getRawValues()) {
                LDIFWriter.encodeNameAndValue(name, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL);
            }
        }
    }

    @Override
    public int hashCode() {
        try {
            int hashCode = this.getParsedDN().hashCode();
            for (Attribute a : this.attributes) {
                hashCode += a.hashCode();
            }
            return hashCode;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new Entry(this.getDN(), this.attributes).hashCode();
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        HashSet<Control> c2;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDIFAddChangeRecord)) {
            return false;
        }
        LDIFAddChangeRecord r = (LDIFAddChangeRecord)o;
        HashSet<Control> c1 = new HashSet<Control>(this.getControls());
        if (!c1.equals(c2 = new HashSet<Control>(r.getControls()))) {
            return false;
        }
        Entry e1 = new Entry(this.getDN(), this.attributes);
        Entry e2 = new Entry(r.getDN(), r.attributes);
        return e1.equals(e2);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LDIFAddChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append("', attrs={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.attributes[i].toString(buffer);
        }
        buffer.append('}');
        List<Control> controls = this.getControls();
        if (!controls.isEmpty()) {
            buffer.append(", controls={");
            Iterator<Control> iterator = controls.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

