/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.List;
import java.util.regex.Pattern;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class NextValExpression
extends ASTNodeAccessImpl
implements Expression {
    public static final Pattern NEXT_VALUE_PATTERN = Pattern.compile("NEXT\\s+VALUE\\s+FOR", 2);
    private final List<String> nameList;
    private boolean usingNextValueFor = false;

    public NextValExpression(List<String> list, String string) {
        this.nameList = list;
        if (NEXT_VALUE_PATTERN.matcher(string).matches()) {
            this.usingNextValueFor = true;
        }
    }

    public boolean isUsingNextValueFor() {
        return this.usingNextValueFor;
    }

    public void setUsingNextValueFor(boolean bl2) {
        this.usingNextValueFor = bl2;
    }

    public NextValExpression withNextValueFor(boolean bl2) {
        this.setUsingNextValueFor(bl2);
        return this;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.nameList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return (this.usingNextValueFor ? "NEXT VALUE FOR " : "NEXTVAL FOR ") + this.getName();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }
}

