/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;

public class ConnObjectPanel
extends Panel {
    private static final long serialVersionUID = -6469290753080058487L;

    public ConnObjectPanel(String id, Pair<IModel<?>, IModel<?>> titles, final Pair<ConnObject, ConnObject> connObjectTOs, final boolean hideLeft) {
        super(id);
        LoadableDetachableModel<List<String>> formProps = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                ArrayList right = new ArrayList(connObjectTOs == null || connObjectTOs.getRight() == null ? List.of() : ((ConnObject)connObjectTOs.getRight()).getAttrs());
                ArrayList left = new ArrayList(connObjectTOs == null || connObjectTOs.getLeft() == null ? List.of() : ((ConnObject)connObjectTOs.getLeft()).getAttrs());
                List schemas = ListUtils.sum(right.stream().map(Attr::getSchema).collect(Collectors.toList()), left.stream().map(Attr::getSchema).collect(Collectors.toList()));
                Collections.sort(schemas);
                return schemas;
            }
        };
        this.add(new Component[]{new Label("leftTitle", (IModel)titles.getLeft()).setOutputMarkupPlaceholderTag(true).setVisible(!hideLeft)});
        this.add(new Component[]{new Label("rightTitle", (IModel)titles.getRight())});
        final Map leftProfile = connObjectTOs == null || connObjectTOs.getLeft() == null ? null : EntityTOUtils.buildAttrMap((Collection)((ConnObject)connObjectTOs.getLeft()).getAttrs());
        final Map rightProfile = connObjectTOs == null || connObjectTOs.getRight() == null ? null : EntityTOUtils.buildAttrMap((Collection)((ConnObject)connObjectTOs.getRight()).getAttrs());
        ListView<String> propView = new ListView<String>("propView", (IModel)formProps){
            private static final long serialVersionUID = 3109256773218160485L;

            protected void populateItem(ListItem<String> item) {
                String prop = (String)item.getModelObject();
                Attr left = Optional.ofNullable(leftProfile).map(stringAttrMap -> (Attr)stringAttrMap.get(prop)).orElse(null);
                Attr right = Optional.ofNullable(rightProfile).map(profile -> (Attr)profile.get(prop)).orElse(null);
                Fragment valueFragment = new Fragment("value", "doubleValue", (MarkupContainer)ConnObjectPanel.this);
                valueFragment.add(new Component[]{ConnObjectPanel.getValuePanel("leftAttribute", prop, left).setOutputMarkupPlaceholderTag(true).setVisible(!hideLeft)});
                valueFragment.add(new Component[]{ConnObjectPanel.getValuePanel("rightAttribute", prop, right)});
                if (left == null || right == null || CollectionUtils.isNotEmpty((Collection)right.getValues()) && CollectionUtils.isEmpty((Collection)left.getValues()) || CollectionUtils.isEmpty((Collection)right.getValues()) && CollectionUtils.isNotEmpty((Collection)left.getValues()) || CollectionUtils.isNotEmpty((Collection)right.getValues()) && CollectionUtils.isNotEmpty((Collection)left.getValues()) && right.getValues().size() != left.getValues().size() || CollectionUtils.isNotEmpty((Collection)right.getValues()) && CollectionUtils.isNotEmpty((Collection)left.getValues()) && !right.getValues().equals(left.getValues())) {
                    valueFragment.add(new Behavior[]{new Behavior(){
                        private static final long serialVersionUID = 3109256773218160485L;

                        public void onComponentTag(Component component, ComponentTag tag) {
                            tag.put("class", (CharSequence)"highlight");
                        }
                    }});
                }
                item.add(new Component[]{valueFragment});
            }
        };
        this.add(new Component[]{propView});
    }

    private static Panel getValuePanel(String id, String schemaName, Attr attrTO) {
        Object field = attrTO == null ? new AjaxTextFieldPanel(id, schemaName, (IModel)new Model()) : (CollectionUtils.isEmpty((Collection)attrTO.getValues()) ? new AjaxTextFieldPanel(id, schemaName, (IModel)new Model()) : ("__PASSWORD__".equals(schemaName) ? new AjaxTextFieldPanel(id, schemaName, (IModel)new Model((Serializable)((Object)"********"))) : (attrTO.getValues().size() == 1 ? new AjaxTextFieldPanel(id, schemaName, (IModel)new Model((Serializable)((Object)((String)attrTO.getValues().get(0))))) : new MultiFieldPanel.Builder(new ListModel(attrTO.getValues())).build(id, schemaName, new AjaxTextFieldPanel("panel", schemaName, (IModel)new Model())))));
        field.setEnabled(false);
        return field;
    }
}

