/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class IntermediateThrowEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List throwEvents = process.findFlowElementsOfType(ThrowEvent.class);
        for (ThrowEvent throwEvent : throwEvents) {
            EventDefinition eventDefinition = null;
            if (!throwEvent.getEventDefinitions().isEmpty()) {
                eventDefinition = (EventDefinition)throwEvent.getEventDefinitions().get(0);
            }
            if (eventDefinition == null || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof EscalationEventDefinition || eventDefinition instanceof CompensateEventDefinition) continue;
            this.addError(errors, "flowable-throw-event-invalid-eventdefinition", process, (FlowElement)throwEvent, (BaseElement)eventDefinition, "Unsupported intermediate throw event type");
        }
    }
}

