/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OidcPushedAuthorizationRequestUriResponseBuilder
extends BaseOAuth20AuthorizationResponseBuilder<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcPushedAuthorizationRequestUriResponseBuilder.class);

    public OidcPushedAuthorizationRequestUriResponseBuilder(OidcConfigurationContext configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super((OAuth20ConfigurationContext)configurationContext, authorizationModelAndViewBuilder);
    }

    public ModelAndView build(AccessTokenRequestContext holder) throws Exception {
        OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)((OidcConfigurationContext)this.configurationContext).getTicketFactory().get(OidcPushedAuthorizationRequest.class);
        OidcPushedAuthorizationRequest uri = factory.create(holder);
        LOGGER.debug("Generated pushed authorization URI code: [{}]", (Object)uri);
        ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().addTicket((Ticket)uri);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("expires_in", String.valueOf(uri.getExpirationPolicy().getTimeToLive()));
        parameters.put("request_uri", uri.getId());
        LOGGER.debug("Pushed authorization request verification successful for client [{}] with redirect uri [{}]", (Object)holder.getClientId(), (Object)holder.getRedirectUri());
        return this.authorizationModelAndViewBuilder.build(holder.getRegisteredService(), holder.getResponseMode(), holder.getRedirectUri(), parameters);
    }

    public Optional<OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder> toAuthorizationRequest(WebContext context, Authentication authentication, Service service, OAuthRegisteredService registeredService) {
        Optional requestUri = context.getRequestParameter("request_uri");
        if (context.getRequestURL().endsWith("oidcAuthorize") && requestUri.isEmpty()) {
            return Optional.empty();
        }
        OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder builder = (OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder)super.toAuthorizationRequest(context, authentication, service, registeredService).get();
        return requestUri.map(Unchecked.function(uri -> {
            OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)((OidcConfigurationContext)this.configurationContext).getTicketFactory().get(OidcPushedAuthorizationRequest.class);
            OidcPushedAuthorizationRequest request = (OidcPushedAuthorizationRequest)((OidcConfigurationContext)this.configurationContext).getTicketRegistry().getTicket(uri, OidcPushedAuthorizationRequest.class);
            AccessTokenRequestContext tokenRequest = factory.toAccessTokenRequest(request);
            request.update();
            FunctionUtils.doIf((boolean)request.isExpired(), (Consumer)Unchecked.consumer(r -> ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().deleteTicket((Ticket)request)), (Consumer)Unchecked.consumer(r -> ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().updateTicket((Ticket)request))).accept(request);
            TicketGrantingTicket tgt = ((OidcConfigurationContext)this.configurationContext).fetchTicketGrantingTicketFrom((JEEContext)context);
            tokenRequest.setTicketGrantingTicket(tgt);
            return Optional.of(builder.accessTokenRequest(tokenRequest).responseType(tokenRequest.getResponseType().getType()).clientId(tokenRequest.getClientId()).grantType(tokenRequest.getGrantType().getType()));
        })).orElseGet(() -> Optional.of(builder.singleSignOnSessionRequired(!context.getRequestURL().endsWith("oidcPushAuthorize"))));
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return context.getUrl().endsWith("oidcPushAuthorize") && StringUtils.isNotBlank((CharSequence)context.getClientId());
    }

    public int getOrder() {
        return 0;
    }
}

