/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateCatchEventParseHandler
extends AbstractFlowNodeBpmnParseHandler<IntermediateCatchEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateCatchEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return IntermediateCatchEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, IntermediateCatchEvent intermediateCatchEvent) {
        EventDefinition eventDefinition = null;
        if (!intermediateCatchEvent.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)intermediateCatchEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition == null) {
            String eventTypeValue;
            List eventTypeExtensionElements;
            Map extensionElements = intermediateCatchEvent.getExtensionElements();
            if (!extensionElements.isEmpty() && (eventTypeExtensionElements = (List)intermediateCatchEvent.getExtensionElements().get("eventType")) != null && !eventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventTypeValue = ((ExtensionElement)eventTypeExtensionElements.get(0)).getElementText()))) {
                intermediateCatchEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateCatchEventRegistryEventActivityBehavior(intermediateCatchEvent, eventTypeValue));
                return;
            }
            intermediateCatchEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateCatchEventActivityBehavior(intermediateCatchEvent));
        } else if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof ConditionalEventDefinition || eventDefinition instanceof VariableListenerEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else {
            LOGGER.warn("Unsupported intermediate catch event type for event {}", (Object)intermediateCatchEvent.getId());
        }
    }
}

