/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationTrustBean;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationPrepareTrustDeviceViewAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationPrepareTrustDeviceViewAction.class);
    private final MultifactorAuthenticationTrustStorage storage;
    private final DeviceFingerprintStrategy deviceFingerprintStrategy;
    private final TrustedDevicesMultifactorProperties trustedProperties;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final ServicesManager servicesManager;
    private final MultifactorAuthenticationTrustedDeviceBypassEvaluator bypassEvaluator;
    private final MultifactorAuthenticationTrustedDeviceNamingStrategy namingStrategy;

    public Event doExecute(RequestContext requestContext) {
        Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        if (this.bypassEvaluator.shouldBypassTrustedDevice(registeredService, (Service)service, authn)) {
            LOGGER.debug("Trusted device registration is disabled for [{}]", (Object)registeredService);
            return this.result("skip");
        }
        if (this.trustedProperties.getCore().isAutoAssignDeviceName()) {
            WebUtils.getMultifactorAuthenticationTrustRecord((RequestContext)requestContext, MultifactorAuthenticationTrustBean.class).ifPresent(device -> {
                String deviceName = this.namingStrategy.determineDeviceName(registeredService, (Service)service, request, authn);
                LOGGER.debug("Auto-generated device name is [{}]", (Object)deviceName);
                device.setDeviceName(deviceName);
            });
            return this.result("store");
        }
        return this.result("register");
    }

    @Generated
    public MultifactorAuthenticationPrepareTrustDeviceViewAction(MultifactorAuthenticationTrustStorage storage, DeviceFingerprintStrategy deviceFingerprintStrategy, TrustedDevicesMultifactorProperties trustedProperties, AuditableExecution registeredServiceAccessStrategyEnforcer, ServicesManager servicesManager, MultifactorAuthenticationTrustedDeviceBypassEvaluator bypassEvaluator, MultifactorAuthenticationTrustedDeviceNamingStrategy namingStrategy) {
        this.storage = storage;
        this.deviceFingerprintStrategy = deviceFingerprintStrategy;
        this.trustedProperties = trustedProperties;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.servicesManager = servicesManager;
        this.bypassEvaluator = bypassEvaluator;
        this.namingStrategy = namingStrategy;
    }

    @Generated
    public MultifactorAuthenticationTrustStorage getStorage() {
        return this.storage;
    }

    @Generated
    public DeviceFingerprintStrategy getDeviceFingerprintStrategy() {
        return this.deviceFingerprintStrategy;
    }

    @Generated
    public TrustedDevicesMultifactorProperties getTrustedProperties() {
        return this.trustedProperties;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public MultifactorAuthenticationTrustedDeviceBypassEvaluator getBypassEvaluator() {
        return this.bypassEvaluator;
    }

    @Generated
    public MultifactorAuthenticationTrustedDeviceNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }
}

