/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDataBinderImpl
implements SchemaDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(SchemaDataBinder.class);
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ImplementationDAO implementationDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;

    public SchemaDataBinderImpl(AnyTypeClassDAO anyTypeClassDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, ExternalResourceDAO resourceDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory) {
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.resourceDAO = resourceDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.implementationDAO = implementationDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    protected PlainSchema fill(PlainSchema schema, PlainSchemaTO schemaTO) {
        if (!JexlUtils.isExpressionValid((String)schemaTO.getMandatoryCondition())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            sce.getElements().add(schemaTO.getMandatoryCondition());
            throw sce;
        }
        schema.setKey(schemaTO.getKey());
        schema.setType(schemaTO.getType());
        schema.setCipherAlgorithm(schemaTO.getCipherAlgorithm());
        schema.setConversionPattern(schemaTO.getConversionPattern());
        schema.setEnumerationKeys(schemaTO.getEnumerationKeys());
        schema.setEnumerationValues(schemaTO.getEnumerationValues());
        schema.setMandatoryCondition(schemaTO.getMandatoryCondition());
        schema.setMimeType(schemaTO.getMimeType());
        schema.setMultivalue(schemaTO.isMultivalue());
        schema.setReadonly(schemaTO.isReadonly());
        schema.setSecretKey(schemaTO.getSecretKey());
        schema.setUniqueConstraint(schemaTO.isUniqueConstraint());
        schema.getLabels().clear();
        schema.getLabels().putAll(schemaTO.getLabels());
        if (schemaTO.getValidator() == null) {
            schema.setValidator(null);
        } else {
            Implementation validator = this.implementationDAO.find(schemaTO.getValidator());
            if (validator == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", (Object)schemaTO.getValidator());
            } else {
                schema.setValidator(validator);
            }
        }
        PlainSchema merged = (PlainSchema)this.plainSchemaDAO.save((Schema)schema);
        if (!(schemaTO.getAnyTypeClass() == null || merged.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(merged.getAnyTypeClass().getKey()))) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(schemaTO.getAnyTypeClass());
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)schemaTO.getAnyTypeClass());
            } else {
                anyTypeClass.add(merged);
                merged.setAnyTypeClass(anyTypeClass);
            }
        } else if (schemaTO.getAnyTypeClass() == null && merged.getAnyTypeClass() != null) {
            merged.getAnyTypeClass().getPlainSchemas().remove(merged);
            merged.setAnyTypeClass(null);
        }
        return merged;
    }

    public PlainSchema create(PlainSchemaTO schemaTO) {
        return this.fill((PlainSchema)this.entityFactory.newEntity(PlainSchema.class), schemaTO);
    }

    public PlainSchema update(PlainSchemaTO schemaTO, PlainSchema schema) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        boolean hasAttrs = false;
        for (AnyTypeKind anyTypeKind : AnyTypeKind.values()) {
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyTypeKind);
            hasAttrs |= this.plainSchemaDAO.hasAttrs(schema, anyUtils.plainAttrClass());
        }
        if (hasAttrs) {
            SyncopeClientException e;
            if (schema.getType() != schemaTO.getType()) {
                e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPlainSchema);
                e.getElements().add("Cannot change type since " + schema.getKey() + " has attributes");
                scce.addException(e);
            }
            if (schema.isUniqueConstraint() != schemaTO.isUniqueConstraint()) {
                e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPlainSchema);
                e.getElements().add("Cannot alter unique contraint since " + schema.getKey() + " has attributes");
                scce.addException(e);
            }
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return this.fill(schema, schemaTO);
    }

    public PlainSchemaTO getPlainSchemaTO(String key) {
        PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(key);
        if (schema == null) {
            throw new NotFoundException("Schema '" + key + "'");
        }
        PlainSchemaTO schemaTO = new PlainSchemaTO();
        schemaTO.setKey(schema.getKey());
        schemaTO.setType(schema.getType());
        schemaTO.setCipherAlgorithm(schema.getCipherAlgorithm());
        schemaTO.setConversionPattern(schema.getConversionPattern());
        schemaTO.setEnumerationKeys(schema.getEnumerationKeys());
        schemaTO.setEnumerationValues(schema.getEnumerationValues());
        schemaTO.setMandatoryCondition(schema.getMandatoryCondition());
        schemaTO.setMimeType(schema.getMimeType());
        schemaTO.setMultivalue(schema.isMultivalue());
        schemaTO.setReadonly(schema.isReadonly());
        schemaTO.setSecretKey(schema.getSecretKey());
        schemaTO.setUniqueConstraint(schema.isUniqueConstraint());
        schemaTO.getLabels().putAll(schema.getLabels());
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : schema.getAnyTypeClass().getKey());
        if (schema.getValidator() != null) {
            schemaTO.setValidator(schema.getValidator().getKey());
        }
        return schemaTO;
    }

    protected DerSchema fill(DerSchema schema, DerSchemaTO schemaTO) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        if (StringUtils.isBlank((CharSequence)schemaTO.getExpression())) {
            SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            requiredValuesMissing.getElements().add("expression");
            scce.addException(requiredValuesMissing);
        } else if (!JexlUtils.isExpressionValid((String)schemaTO.getExpression())) {
            SyncopeClientException e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            e.getElements().add(schemaTO.getExpression());
            scce.addException(e);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        schema.setKey(schemaTO.getKey());
        schema.setExpression(schemaTO.getExpression());
        schema.getLabels().clear();
        schema.getLabels().putAll(schemaTO.getLabels());
        DerSchema merged = (DerSchema)this.derSchemaDAO.save((Schema)schema);
        if (!(schemaTO.getAnyTypeClass() == null || merged.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(merged.getAnyTypeClass().getKey()))) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(schemaTO.getAnyTypeClass());
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)schemaTO.getAnyTypeClass());
            } else {
                anyTypeClass.add(merged);
                merged.setAnyTypeClass(anyTypeClass);
            }
        } else if (schemaTO.getAnyTypeClass() == null && merged.getAnyTypeClass() != null) {
            merged.getAnyTypeClass().getDerSchemas().remove(merged);
            merged.setAnyTypeClass(null);
        }
        return merged;
    }

    public DerSchema create(DerSchemaTO schemaTO) {
        return this.fill((DerSchema)this.entityFactory.newEntity(DerSchema.class), schemaTO);
    }

    public DerSchema update(DerSchemaTO schemaTO, DerSchema schema) {
        return this.fill(schema, schemaTO);
    }

    public DerSchemaTO getDerSchemaTO(String key) {
        DerSchema schema = (DerSchema)this.derSchemaDAO.find(key);
        if (schema == null) {
            throw new NotFoundException("Derived schema '" + key + "'");
        }
        DerSchemaTO schemaTO = new DerSchemaTO();
        schemaTO.setKey(schema.getKey());
        schemaTO.setExpression(schema.getExpression());
        schemaTO.getLabels().putAll(schema.getLabels());
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : schema.getAnyTypeClass().getKey());
        return schemaTO;
    }

    protected VirSchema fill(VirSchema schema, VirSchemaTO schemaTO) {
        schema.setKey(schemaTO.getKey());
        schema.setExtAttrName(schemaTO.getExtAttrName());
        schema.setReadonly(schemaTO.isReadonly());
        schema.getLabels().clear();
        schema.getLabels().putAll(schemaTO.getLabels());
        if (!(schemaTO.getAnyTypeClass() == null || schema.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(schema.getAnyTypeClass().getKey()))) {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(schemaTO.getAnyTypeClass());
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + "{}, ignoring...", (Object)schemaTO.getAnyTypeClass());
            } else {
                anyTypeClass.add(schema);
                schema.setAnyTypeClass(anyTypeClass);
            }
        } else if (schemaTO.getAnyTypeClass() == null && schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().getVirSchemas().remove(schema);
            schema.setAnyTypeClass(null);
        }
        ExternalResource resource = this.resourceDAO.find(schemaTO.getResource());
        if (resource == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSchemaDefinition);
            sce.getElements().add("Resource " + schemaTO.getResource() + " not found");
            throw sce;
        }
        AnyType anyType = this.anyTypeDAO.find(schemaTO.getAnyType());
        if (anyType == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSchemaDefinition);
            sce.getElements().add("AnyType " + schemaTO.getAnyType() + " not found");
            throw sce;
        }
        Provision provision = resource.getProvisionByAnyType(anyType.getKey()).orElse(null);
        if (provision == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSchemaDefinition);
            sce.getElements().add("Provision for AnyType" + schemaTO.getAnyType() + " not found in " + schemaTO.getResource());
            throw sce;
        }
        schema.setResource(resource);
        schema.setAnyType(anyType);
        return (VirSchema)this.virSchemaDAO.save((Schema)schema);
    }

    public VirSchema create(VirSchemaTO schemaTO) {
        return this.fill((VirSchema)this.entityFactory.newEntity(VirSchema.class), schemaTO);
    }

    public VirSchema update(VirSchemaTO schemaTO, VirSchema schema) {
        return this.fill(schema, schemaTO);
    }

    public VirSchemaTO getVirSchemaTO(String key) {
        VirSchema schema = (VirSchema)this.virSchemaDAO.find(key);
        if (schema == null) {
            throw new NotFoundException("Virtual Schema '" + key + "'");
        }
        VirSchemaTO schemaTO = new VirSchemaTO();
        schemaTO.setKey(schema.getKey());
        schemaTO.setExtAttrName(schema.getExtAttrName());
        schemaTO.setReadonly(schema.isReadonly());
        schemaTO.getLabels().putAll(schema.getLabels());
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : schema.getAnyTypeClass().getKey());
        schemaTO.setResource(schema.getResource().getKey());
        schemaTO.setAnyType(schema.getAnyType().getKey());
        return schemaTO;
    }
}

