/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordQualityRequirement;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordQualityRequirementValidationResult
implements Serializable {
    private static final byte TYPE_ADDITIONAL_INFO = -128;
    private static final long serialVersionUID = -8048878239770726375L;
    private final boolean requirementSatisfied;
    @NotNull
    private final PasswordQualityRequirement passwordRequirement;
    @Nullable
    private final String additionalInfo;

    public PasswordQualityRequirementValidationResult(@NotNull PasswordQualityRequirement passwordRequirement, boolean requirementSatisfied, @Nullable String additionalInfo) {
        Validator.ensureNotNull(passwordRequirement);
        this.passwordRequirement = passwordRequirement;
        this.requirementSatisfied = requirementSatisfied;
        this.additionalInfo = additionalInfo;
    }

    @NotNull
    public PasswordQualityRequirement getPasswordRequirement() {
        return this.passwordRequirement;
    }

    public boolean requirementSatisfied() {
        return this.requirementSatisfied;
    }

    @Nullable
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @NotNull
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(this.passwordRequirement.encode());
        elements.add(new ASN1Boolean(this.requirementSatisfied));
        if (this.additionalInfo != null) {
            elements.add(new ASN1OctetString(-128, this.additionalInfo));
        }
        return new ASN1Sequence(elements);
    }

    @NotNull
    public static PasswordQualityRequirementValidationResult decode(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            PasswordQualityRequirement passwordRequirement = PasswordQualityRequirement.decode(elements[0]);
            boolean requirementSatisfied = ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue();
            String additionalInfo = null;
            block6: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        additionalInfo = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block6;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_REQ_VALIDATION_RESULT_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            return new PasswordQualityRequirementValidationResult(passwordRequirement, requirementSatisfied, additionalInfo);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_REQ_VALIDATION_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordQualityRequirementValidationResult(requirement=");
        this.passwordRequirement.toString(buffer);
        buffer.append(", requirementSatisfied=");
        buffer.append(this.requirementSatisfied);
        if (this.additionalInfo != null) {
            buffer.append(", additionalInfo='");
            buffer.append(this.additionalInfo);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

