/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.syncope.common.lib.policy.AccessPolicyConf;
import org.apache.syncope.common.lib.policy.AccessPolicyTO;
import org.apache.syncope.common.lib.policy.TimeBasedAccessPolicyConf;
import org.apache.syncope.wa.starter.mapping.AccessMapper;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.TimeBasedRegisteredServiceAccessStrategy;

public class TimeBasedAccessMapper
implements AccessMapper {
    @Override
    public boolean supports(AccessPolicyConf conf) {
        return TimeBasedAccessPolicyConf.class.equals(conf.getClass());
    }

    @Override
    public RegisteredServiceAccessStrategy build(AccessPolicyTO policy) {
        TimeBasedAccessPolicyConf conf = (TimeBasedAccessPolicyConf)policy.getConf();
        TimeBasedRegisteredServiceAccessStrategy accessStrategy = new TimeBasedRegisteredServiceAccessStrategy();
        Optional.ofNullable(conf.getStart()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).ifPresent(arg_0 -> ((TimeBasedRegisteredServiceAccessStrategy)accessStrategy).setStartingDateTime(arg_0));
        Optional.ofNullable(conf.getEnd()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).ifPresent(arg_0 -> ((TimeBasedRegisteredServiceAccessStrategy)accessStrategy).setEndingDateTime(arg_0));
        Optional.ofNullable(conf.getZoneId()).ifPresent(arg_0 -> ((TimeBasedRegisteredServiceAccessStrategy)accessStrategy).setZoneId(arg_0));
        return accessStrategy;
    }
}

