/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.openjpa.jdbc.kernel.JDBCStoreQuery;
import org.apache.openjpa.jdbc.kernel.exps.Count;
import org.apache.openjpa.jdbc.kernel.exps.Exp;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.HasContainsExpressionVisitor;
import org.apache.openjpa.jdbc.kernel.exps.Lit;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.QueryExpressionsState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.exps.AbstractExpressionVisitor;
import org.apache.openjpa.kernel.exps.Constant;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UnsupportedException;

public class SelectConstructor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _extent = false;
    private Select _subselect = null;
    private static final Localizer _loc = Localizer.forPackage(SelectConstructor.class);

    public boolean isExtent() {
        return this._extent;
    }

    public void setSubselect(Select subselect) {
        this._subselect = subselect;
    }

    public Select evaluate(ExpContext ctx, Select parent, String alias, QueryExpressions exps, QueryExpressionsState state) {
        Val val;
        if (this._extent) {
            Select sel = ctx.store.getSQLFactory().newSelect();
            sel.setAutoDistinct((exps.distinct & 2) != 0);
            return sel;
        }
        Select sel = this.newSelect(ctx, parent, alias, exps, state);
        sel.setTablePerClassMeta(ctx.tpcMeta);
        Select inner = sel.getFromSelect();
        SQLBuffer where = this.buildWhere(inner != null ? inner : sel, ctx, state.filter, exps.filter);
        if (where == null && exps.projections.length == 0 && exps.ordering.length == 0 && (sel.getJoins() == null || sel.getJoins().isEmpty())) {
            this._extent = true;
            sel.setAutoDistinct((exps.distinct & 2) != 0);
            return sel;
        }
        if (inner != null) {
            inner.where(where);
        } else {
            sel.where(where);
        }
        if (exps.having != null) {
            Exp havingExp = (Exp)exps.having;
            SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
            havingExp.appendTo(sel, ctx, state.having, buf);
            sel.having(buf);
        }
        for (int i = 0; i < exps.grouping.length; ++i) {
            ((Val)exps.grouping[i]).groupBy(sel, ctx, state.grouping[i]);
        }
        if (exps.projections.length == 1 && (val = (Val)exps.projections[0]) instanceof Count && ((Count)val).isCountDistinctMultiCols()) {
            Select newSel = ctx.store.getSQLFactory().newSelect();
            newSel.select("COUNT(*)", (Object)val);
            newSel.setExpectedResultCount(1, true);
            newSel.setFromSelect(sel);
            sel.setExpectedResultCount(0, true);
            sel = newSel;
        }
        return sel;
    }

    private Select newSelect(ExpContext ctx, Select parent, String alias, QueryExpressions exps, QueryExpressionsState state) {
        Select subselect = JDBCStoreQuery.getThreadLocalSelect(this._subselect);
        Select sel = parent != null ? subselect : ctx.store.getSQLFactory().newSelect();
        sel.setAutoDistinct((exps.distinct & 2) != 0);
        sel.setJoinSyntax(ctx.fetch.getJoinSyntax());
        sel.setParent(parent, alias);
        Context[] qryCtx = JDBCStoreQuery.getThreadLocalContext();
        Context lctx = null;
        for (Context context : qryCtx) {
            if (context.cloneFrom != exps.ctx()) continue;
            lctx = context;
            break;
        }
        if (sel.ctx() == null) {
            sel.setContext(lctx);
        }
        if (parent == null && lctx.getSubselContexts() != null) {
            List subselCtxs = lctx.getSubselContexts();
            for (Context subselCtx : subselCtxs) {
                Select subsel = (Select)subselCtx.getSelect();
                Subquery subquery = subselCtx.getSubquery();
                subsel.setParent(sel, subquery.getCandidateAlias());
            }
        }
        if (HasContainsExpressionVisitor.hasContains(exps.filter)) {
            sel.setHasSubselect(true);
        }
        this.initialize(sel, ctx, exps, state);
        if (!sel.getAutoDistinct()) {
            if ((exps.distinct & 4) != 0) {
                sel.setDistinct(true);
            } else if ((exps.distinct & 8) != 0) {
                sel.setDistinct(false);
            }
        } else if (exps.projections.length > 0) {
            if (!sel.isDistinct() && (exps.distinct & 4) != 0) {
                sel.setDistinct(true);
            } else if (sel.isDistinct()) {
                boolean agg = exps.isAggregate();
                boolean candidate = ProjectionExpressionVisitor.hasCandidateProjections(exps.projections);
                if (agg || candidate && (exps.distinct & 4) == 0) {
                    DBDictionary dict = ctx.store.getDBDictionary();
                    dict.assertSupport(dict.supportsSubselect, "SupportsSubselect");
                    Select inner = sel;
                    sel = ctx.store.getSQLFactory().newSelect();
                    sel.setParent(parent, alias);
                    sel.setDistinct(agg && (exps.distinct & 4) != 0);
                    sel.setFromSelect(inner);
                } else if (!candidate && (exps.distinct & 4) == 0) {
                    sel.setDistinct(false);
                }
            }
        }
        return sel;
    }

    private void initialize(Select sel, ExpContext ctx, QueryExpressions exps, QueryExpressionsState state) {
        int i;
        HashMap contains = null;
        if (HasContainsExpressionVisitor.hasContains(exps.filter) || HasContainsExpressionVisitor.hasContains(exps.having)) {
            contains = new HashMap(7);
        }
        Exp filterExp = (Exp)exps.filter;
        state.filter = filterExp.initialize(sel, ctx, contains);
        Exp havingExp = (Exp)exps.having;
        if (havingExp != null) {
            state.having = havingExp.initialize(sel, ctx, contains);
        }
        Joins filterJoins = state.filter.joins;
        Joins havingJoins = state.having == null ? null : state.having.joins;
        Joins joins = sel.and(filterJoins, havingJoins);
        if (exps.projections.length > 0) {
            state.projections = new ExpState[exps.projections.length];
            for (i = 0; i < exps.projections.length; ++i) {
                Val resultVal = (Val)exps.projections[i];
                if (!ctx.store.getDBDictionary().supportsParameterInSelect && resultVal instanceof Lit) {
                    ((Lit)resultVal).setRaw(true);
                }
                state.projections[i] = resultVal.initialize(sel, ctx, 12);
                if (exps.projections.length > 1 && resultVal instanceof Count && ((Count)resultVal).isCountDistinctMultiCols()) {
                    throw new UnsupportedException(_loc.get("count-distinct-multi-col-only"));
                }
                joins = sel.and(joins, state.projections[i].joins);
            }
        }
        if (exps.grouping.length > 0) {
            state.grouping = new ExpState[exps.grouping.length];
            for (i = 0; i < exps.grouping.length; ++i) {
                Val groupVal = (Val)exps.grouping[i];
                state.grouping[i] = groupVal.initialize(sel, ctx, 4);
                joins = sel.and(joins, state.grouping[i].joins);
            }
        }
        if (exps.ordering.length > 0) {
            state.ordering = new ExpState[exps.ordering.length];
            for (i = 0; i < exps.ordering.length; ++i) {
                Val orderVal = (Val)exps.ordering[i];
                state.ordering[i] = this.contains(orderVal, exps.grouping) ? orderVal.initialize(sel, ctx, 4) : orderVal.initialize(sel, ctx, 0);
                joins = sel.and(joins, state.ordering[i].joins);
            }
        }
        sel.where(joins);
    }

    private boolean contains(Val orderVal, Value[] grouping) {
        for (Value value : grouping) {
            Val groupVal = (Val)value;
            if (!orderVal.equals(groupVal)) continue;
            return true;
        }
        return false;
    }

    private SQLBuffer buildWhere(Select sel, ExpContext ctx, ExpState state, Expression filter) {
        SQLBuffer where = new SQLBuffer(ctx.store.getDBDictionary());
        where.append("(");
        Exp filterExp = (Exp)filter;
        filterExp.appendTo(sel, ctx, state, where);
        if (where.sqlEquals("(") || where.sqlEquals("(1 = 1")) {
            return null;
        }
        return where.append(")");
    }

    public void select(Select sel, ExpContext ctx, ClassMapping mapping, boolean subclasses, QueryExpressions exps, QueryExpressionsState state, int eager) {
        Val val;
        int i;
        Select inner = sel.getFromSelect();
        Joins joins = null;
        boolean isCountDistinctMultiCols = false;
        if (sel.getSubselectPath() != null) {
            joins = sel.newJoins().setSubselect(sel.getSubselectPath());
        }
        for (i = 0; i < exps.ordering.length; ++i) {
            ((Val)exps.ordering[i]).orderBy(sel, ctx, state.ordering[i], exps.ascending[i]);
        }
        if (exps.projections.length == 0 && sel.getParent() == null) {
            int subs = subclasses ? 1 : 2;
            sel.selectIdentifier(mapping, subs, ctx.store, ctx.fetch, eager);
        } else if (exps.projections.length == 0) {
            sel.select(mapping.getPrimaryKeyColumns(), joins);
        } else {
            if (exps.projections.length == 1 && (val = (Val)exps.projections[0]) instanceof Count && ((Count)val).isCountDistinctMultiCols()) {
                isCountDistinctMultiCols = true;
                if (sel.getParent() != null) {
                    throw new UnsupportedException(_loc.get("count-distinct-multi-col-subselect-unsupported"));
                }
            }
            if (inner != null && !isCountDistinctMultiCols) {
                inner.select(mapping.getPrimaryKeyColumns(), joins);
            }
            boolean pks = sel.getParent() != null;
            for (int i2 = 0; i2 < exps.projections.length; ++i2) {
                val = (Val)exps.projections[i2];
                if (inner != null) {
                    if (!isCountDistinctMultiCols) {
                        val.selectColumns(inner, ctx, state.projections[i2], pks);
                        continue;
                    }
                    val.select(inner, ctx, state.projections[i2], pks);
                    continue;
                }
                val.select(sel, ctx, state.projections[i2], pks);
            }
            if (exps.having != null && inner != null) {
                ((Exp)exps.having).selectColumns(inner, ctx, state.having, true);
            }
        }
        for (i = 0; i < exps.ordering.length; ++i) {
            val = (Val)exps.ordering[i];
            if (inner != null) {
                val.selectColumns(inner, ctx, state.ordering[i], true);
            }
            val.select(sel, ctx, state.ordering[i], true);
        }
        if (exps.projections.length > 0 || sel.getParent() != null) {
            ctx.store.loadSubclasses(mapping);
            mapping.getDiscriminator().addClassConditions(inner != null ? inner : sel, subclasses, joins);
        }
    }

    private static class ProjectionExpressionVisitor
    extends AbstractExpressionVisitor {
        private boolean _candidate = false;
        private int _level = 0;

        private ProjectionExpressionVisitor() {
        }

        public static boolean hasCandidateProjections(Value[] projs) {
            ProjectionExpressionVisitor v = new ProjectionExpressionVisitor();
            for (Value proj : projs) {
                proj.acceptVisit((ExpressionVisitor)v);
                if (!v._candidate) continue;
                return true;
            }
            return false;
        }

        public void enter(Value val) {
            if (!this._candidate) {
                this._candidate = this._level == 0 && val instanceof Constant || val instanceof PCPath && !((PCPath)val).isVariablePath();
            }
            ++this._level;
        }

        public void exit(Value val) {
            --this._level;
        }
    }
}

