/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class BaseSamlRegisteredServiceAttributeReleasePolicy
extends ReturnAllowedAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlRegisteredServiceAttributeReleasePolicy.class);
    private static final long serialVersionUID = -3301632236702329694L;

    protected static String getEntityIdFromRequest(Service selectedService) {
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        if (request == null || selectedService == null) {
            LOGGER.debug("No http request could be identified to locate the entity id");
            return null;
        }
        LOGGER.debug("Attempting to determine entity id for service [{}]", (Object)selectedService);
        List entityIdAttribute = (List)selectedService.getAttributes().get("entityId");
        if (entityIdAttribute != null && !entityIdAttribute.isEmpty()) {
            LOGGER.debug("Found entity id [{}] as a service attribute", (Object)entityIdAttribute);
            return CollectionUtils.firstElement((Object)entityIdAttribute).map(Object::toString).orElseThrow();
        }
        List providerIdAttribute = (List)selectedService.getAttributes().get("providerId");
        if (providerIdAttribute != null && !providerIdAttribute.isEmpty()) {
            LOGGER.debug("Found provider entity id [{}] as a service attribute", (Object)providerIdAttribute);
            return CollectionUtils.firstElement((Object)providerIdAttribute).map(Object::toString).orElseThrow();
        }
        List samlRequest = (List)selectedService.getAttributes().get("SAMLRequest");
        if (samlRequest != null && !samlRequest.isEmpty()) {
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            SamlRegisteredServiceCachingMetadataResolver resolver = (SamlRegisteredServiceCachingMetadataResolver)applicationContext.getBean("defaultSamlRegisteredServiceCachingMetadataResolver", SamlRegisteredServiceCachingMetadataResolver.class);
            String attributeValue = CollectionUtils.firstElement((Object)samlRequest).map(Object::toString).orElseThrow();
            OpenSamlConfigBean openSamlConfigBean = resolver.getOpenSamlConfigBean();
            RequestAbstractType authnRequest = SamlIdPUtils.retrieveSamlRequest(openSamlConfigBean, RequestAbstractType.class, attributeValue);
            openSamlConfigBean.logObject((XMLObject)authnRequest);
            String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
            LOGGER.debug("Found entity id [{}] from SAML request issuer", (Object)issuer);
            return issuer;
        }
        String entityId = request.getParameter("entityId");
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            LOGGER.debug("Found entity id [{}] as a request parameter", (Object)entityId);
            return entityId;
        }
        String svcParam = request.getParameter("service");
        return (String)FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)svcParam), () -> (String)FunctionUtils.doAndHandle(o -> {
            URIBuilder builder = new URIBuilder(svcParam);
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("entityId")).map(NameValuePair::getValue).findFirst().orElse("");
        }, throwable -> {
            LoggingUtils.error((Logger)LOGGER, (Throwable)throwable);
            return null;
        }).apply(svcParam), () -> null).get();
    }

    protected static Optional<AuthnRequest> getSamlAuthnRequest(ApplicationContext applicationContext) {
        OpenSamlConfigBean openSamlConfigBean = (OpenSamlConfigBean)applicationContext.getBean("shibboleth.OpenSAMLConfig", OpenSamlConfigBean.class);
        SessionStore sessionStore = (SessionStore)applicationContext.getBean("samlIdPDistributedSessionStore", SessionStore.class);
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
        JEEContext context = new JEEContext(request, response);
        Optional<Pair<? extends RequestAbstractType, MessageContext>> result = SamlIdPUtils.retrieveSamlRequest((WebContext)context, sessionStore, openSamlConfigBean, AuthnRequest.class);
        AuthnRequest authnRequest = (AuthnRequest)result.orElseThrow(() -> new IllegalArgumentException("SAML request could not be determined from session store")).getLeft();
        return Optional.of(authnRequest);
    }

    @JsonIgnore
    protected static Optional<SamlRegisteredServiceServiceProviderMetadataFacade> determineServiceProviderMetadataFacade(SamlRegisteredService registeredService, String entityId) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        SamlRegisteredServiceCachingMetadataResolver resolver = (SamlRegisteredServiceCachingMetadataResolver)applicationContext.getBean("defaultSamlRegisteredServiceCachingMetadataResolver", SamlRegisteredServiceCachingMetadataResolver.class);
        return SamlRegisteredServiceServiceProviderMetadataFacade.get(resolver, registeredService, entityId);
    }

    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        if (context.getRegisteredService() instanceof SamlRegisteredService) {
            Optional facade;
            SamlRegisteredService samlRegisteredService = (SamlRegisteredService)context.getRegisteredService();
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            SamlRegisteredServiceCachingMetadataResolver resolver = (SamlRegisteredServiceCachingMetadataResolver)applicationContext.getBean("defaultSamlRegisteredServiceCachingMetadataResolver", SamlRegisteredServiceCachingMetadataResolver.class);
            String entityId = BaseSamlRegisteredServiceAttributeReleasePolicy.getEntityIdFromRequest(context.getService());
            Optional<Object> optional = facade = StringUtils.isBlank((CharSequence)entityId) ? Optional.empty() : BaseSamlRegisteredServiceAttributeReleasePolicy.determineServiceProviderMetadataFacade(samlRegisteredService, entityId);
            if (facade.isEmpty()) {
                LOGGER.warn("Could not locate metadata for [{}] to process attributes", (Object)entityId);
                return new HashMap<String, List<Object>>(0);
            }
            EntityDescriptor entityDescriptor = ((SamlRegisteredServiceServiceProviderMetadataFacade)facade.get()).getEntityDescriptor();
            return this.getAttributesForSamlRegisteredService(attributes, applicationContext, resolver, (SamlRegisteredServiceServiceProviderMetadataFacade)facade.get(), entityDescriptor, context);
        }
        return this.authorizeReleaseOfAllowedAttributes(context, attributes);
    }

    protected abstract Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> var1, ApplicationContext var2, SamlRegisteredServiceCachingMetadataResolver var3, SamlRegisteredServiceServiceProviderMetadataFacade var4, EntityDescriptor var5, RegisteredServiceAttributeReleasePolicyContext var6);
}

