/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.JQueryUtils;
import com.googlecode.wicket.jquery.ui.JQueryDestroyListener;
import com.googlecode.wicket.jquery.ui.settings.JQueryUILibrarySettings;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JQueryUIBehavior
extends JQueryBehavior
implements JQueryDestroyListener.IDestroyable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JQueryUIBehavior.class);

    public JQueryUIBehavior(String selector, String method) {
        this(selector, method, new Options());
    }

    public JQueryUIBehavior(String selector, String method, Options options) {
        super(selector, method, options);
        this.initReferences();
    }

    private void initReferences() {
        JQueryUILibrarySettings settings = JQueryUILibrarySettings.get();
        if (settings.getJavaScriptReference() != null) {
            this.add(settings.getJavaScriptReference());
        }
        if (settings.getStyleSheetReference() != null) {
            this.add(settings.getStyleSheetReference());
        }
    }

    public String widget() {
        return JQueryUIBehavior.widget(this.selector, this.method);
    }

    protected String widget(String method) {
        return JQueryUIBehavior.widget(this.selector, method);
    }

    public static String widget(String selector, String method) {
        return String.format("jQuery('%s').%s('instance')", selector, method);
    }

    public static String widget(Component component, String method) {
        return JQueryUIBehavior.widget(IJQueryWidget.JQueryWidget.getSelector((Component)component), method);
    }

    @Override
    public void destroy(IPartialPageRequestHandler handler) {
        String statement = String.format("var $w = %s; if($w) { $w.destroy(); }", this.widget());
        handler.prependJavaScript((CharSequence)JQueryUtils.trycatch((String)statement));
        this.onDestroy(handler);
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (!Application.get().getMarkupSettings().getStripWicketTags()) {
            LOG.warn("Application > MarkupSettings > StripWicketTags: setting is currently set to false. It is highly recommended to set it to true to prevent widget misbehaviors.");
        }
    }

    protected void onDestroy(IPartialPageRequestHandler handler) {
    }
}

