/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.FixedTuple;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;

public class TupleCaptureBolt
implements IRichBolt {
    private static final transient Map<String, Map<String, List<FixedTuple>>> emitted_tuples = new ConcurrentHashMap<String, Map<String, List<FixedTuple>>>();
    private final String name = UUID.randomUUID().toString();
    private OutputCollector collector;

    public TupleCaptureBolt() {
        emitted_tuples.put(this.name, new ConcurrentHashMap());
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
    }

    @Override
    public void execute(Tuple input) {
        String component = input.getSourceComponent();
        emitted_tuples.get(this.name).compute(component, (key, tuples) -> {
            if (tuples == null) {
                tuples = new ArrayList<FixedTuple>();
            }
            tuples.add(new FixedTuple(input.getSourceStreamId(), input.getValues()));
            return tuples;
        });
        this.collector.ack(input);
    }

    public Map<String, List<FixedTuple>> getResults() {
        return emitted_tuples.get(this.name);
    }

    @Override
    public void cleanup() {
    }

    public Map<String, List<FixedTuple>> getAndRemoveResults() {
        return emitted_tuples.remove(this.name);
    }

    public Map<String, List<FixedTuple>> getAndClearResults() {
        Map<String, List<FixedTuple>> results = emitted_tuples.get(this.name);
        HashMap<String, List<FixedTuple>> ret = new HashMap<String, List<FixedTuple>>(results);
        results.clear();
        return ret;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

