/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.metrics2.RateCounter;
import org.apache.storm.metrics2.RollingAverageGauge;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.ConfigUtils;

public class TaskMetrics {
    private static final String METRIC_NAME_ACKED = "__ack-count";
    private static final String METRIC_NAME_FAILED = "__fail-count";
    private static final String METRIC_NAME_EMITTED = "__emit-count";
    private static final String METRIC_NAME_TRANSFERRED = "__transfer-count";
    private static final String METRIC_NAME_EXECUTED = "__execute-count";
    private static final String METRIC_NAME_PROCESS_LATENCY = "__process-latency";
    private static final String METRIC_NAME_COMPLETE_LATENCY = "__complete-latency";
    private static final String METRIC_NAME_EXECUTE_LATENCY = "__execute-latency";
    private static final String METRIC_NAME_CAPACITY = "__capacity";
    private final ConcurrentMap<String, RateCounter> rateCounters = new ConcurrentHashMap<String, RateCounter>();
    private final ConcurrentMap<String, RollingAverageGauge> gauges = new ConcurrentHashMap<String, RollingAverageGauge>();
    private final String topologyId;
    private final String componentId;
    private final Integer taskId;
    private final Integer workerPort;
    private final StormMetricRegistry metricRegistry;
    private final int samplingRate;

    public TaskMetrics(WorkerTopologyContext context, String componentId, Integer taskid, StormMetricRegistry metricRegistry, Map<String, Object> topoConf) {
        this.metricRegistry = metricRegistry;
        this.topologyId = context.getStormId();
        this.componentId = componentId;
        this.taskId = taskid;
        this.workerPort = context.getThisWorkerPort();
        this.samplingRate = ConfigUtils.samplingRate(topoConf);
    }

    public void setCapacity(double capacity) {
        String metricName = METRIC_NAME_CAPACITY;
        RollingAverageGauge gauge = this.getRollingAverageGauge(metricName, "default");
        gauge.addValue(capacity);
    }

    public void spoutAckedTuple(String streamId, long latencyMs) {
        String metricName = "__ack-count-" + streamId;
        RateCounter rc = this.getRateCounter(metricName, streamId);
        rc.inc(this.samplingRate);
        metricName = "__complete-latency-" + streamId;
        RollingAverageGauge gauge = this.getRollingAverageGauge(metricName, streamId);
        gauge.addValue(latencyMs);
    }

    public void boltAckedTuple(String sourceComponentId, String sourceStreamId, long latencyMs) {
        String key = sourceComponentId + ":" + sourceStreamId;
        String metricName = "__ack-count-" + key;
        RateCounter rc = this.getRateCounter(metricName, sourceStreamId);
        rc.inc(this.samplingRate);
        metricName = "__process-latency-" + key;
        RollingAverageGauge gauge = this.getRollingAverageGauge(metricName, sourceStreamId);
        gauge.addValue(latencyMs);
    }

    public void spoutFailedTuple(String streamId) {
        String key = streamId;
        String metricName = "__fail-count-" + key;
        RateCounter rc = this.getRateCounter(metricName, streamId);
        rc.inc(this.samplingRate);
    }

    public void boltFailedTuple(String sourceComponentId, String sourceStreamId) {
        String key = sourceComponentId + ":" + sourceStreamId;
        String metricName = "__fail-count-" + key;
        RateCounter rc = this.getRateCounter(metricName, sourceStreamId);
        rc.inc(this.samplingRate);
    }

    public void emittedTuple(String streamId) {
        String key = streamId;
        String metricName = "__emit-count-" + key;
        RateCounter rc = this.getRateCounter(metricName, streamId);
        rc.inc(this.samplingRate);
    }

    public void transferredTuples(String streamId, int amount) {
        String key = streamId;
        String metricName = "__transfer-count-" + key;
        RateCounter rc = this.getRateCounter(metricName, streamId);
        rc.inc(amount * this.samplingRate);
    }

    public void boltExecuteTuple(String sourceComponentId, String sourceStreamId, long latencyMs) {
        String key = sourceComponentId + ":" + sourceStreamId;
        String metricName = "__execute-count-" + key;
        RateCounter rc = this.getRateCounter(metricName, sourceStreamId);
        rc.inc(this.samplingRate);
        metricName = "__execute-latency-" + key;
        RollingAverageGauge gauge = this.getRollingAverageGauge(metricName, sourceStreamId);
        gauge.addValue(latencyMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RateCounter getRateCounter(String metricName, String streamId) {
        RateCounter rc = (RateCounter)this.rateCounters.get(metricName);
        if (rc == null) {
            TaskMetrics taskMetrics = this;
            synchronized (taskMetrics) {
                rc = (RateCounter)this.rateCounters.get(metricName);
                if (rc == null) {
                    rc = this.metricRegistry.rateCounter(metricName, this.topologyId, this.componentId, this.taskId, this.workerPort, streamId);
                    this.rateCounters.put(metricName, rc);
                }
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RollingAverageGauge getRollingAverageGauge(String metricName, String streamId) {
        RollingAverageGauge gauge = (RollingAverageGauge)this.gauges.get(metricName);
        if (gauge == null) {
            TaskMetrics taskMetrics = this;
            synchronized (taskMetrics) {
                gauge = (RollingAverageGauge)this.gauges.get(metricName);
                if (gauge == null) {
                    gauge = new RollingAverageGauge();
                    this.metricRegistry.gauge(metricName, gauge, this.topologyId, this.componentId, streamId, this.taskId, this.workerPort);
                    this.gauges.put(metricName, gauge);
                }
            }
        }
        return gauge;
    }
}

