/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.nimbus;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopoCache {
    public static final Logger LOG = LoggerFactory.getLogger(TopoCache.class);
    private final BlobStore store;
    private final BlobStoreAclHandler aclHandler;
    private final ConcurrentHashMap<String, WithAcl<StormTopology>> topos = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, WithAcl<Map<String, Object>>> confs = new ConcurrentHashMap();

    public TopoCache(BlobStore store, Map<String, Object> conf) {
        this.store = store;
        this.aclHandler = new BlobStoreAclHandler(conf);
    }

    public StormTopology readTopology(String topoId, Subject who) throws KeyNotFoundException, AuthorizationException, IOException {
        String key = ConfigUtils.masterStormCodeKey((String)topoId);
        WithAcl<StormTopology> cached = this.topos.get(topoId);
        if (cached == null) {
            StormTopology topo = (StormTopology)Utils.deserialize((byte[])this.store.readBlob(key, who), StormTopology.class);
            ReadableBlobMeta meta = this.store.getBlobMeta(key, who);
            cached = new WithAcl<StormTopology>(meta.get_settable().get_acl(), topo);
            WithAcl<StormTopology> previous = this.topos.putIfAbsent(topoId, cached);
            if (previous != null) {
                cached = previous;
            }
        } else {
            this.aclHandler.hasPermissions(cached.acl, 1, who, key);
        }
        return (StormTopology)cached.data;
    }

    public void deleteTopology(String topoId, Subject who) throws AuthorizationException, KeyNotFoundException {
        String key = ConfigUtils.masterStormCodeKey((String)topoId);
        this.store.deleteBlob(key, who);
        this.topos.remove(topoId);
    }

    public void addTopology(String topoId, Subject who, StormTopology topo) throws AuthorizationException, KeyAlreadyExistsException, IOException {
        String key = ConfigUtils.masterStormCodeKey((String)topoId);
        List acl = BlobStoreAclHandler.DEFAULT;
        SettableBlobMeta meta = new SettableBlobMeta(acl);
        this.store.createBlob(key, Utils.serialize((Object)topo), meta, who);
        this.topos.put(topoId, new WithAcl<StormTopology>(meta.get_acl(), topo));
    }

    public void updateTopology(String topoId, Subject who, StormTopology topo) throws AuthorizationException, KeyNotFoundException, IOException {
        String key = ConfigUtils.masterStormCodeKey((String)topoId);
        this.store.updateBlob(key, Utils.serialize((Object)topo), who);
        List acl = BlobStoreAclHandler.DEFAULT;
        WithAcl<StormTopology> old = this.topos.get(topoId);
        acl = old != null ? old.acl : this.store.getBlobMeta(key, who).get_settable().get_acl();
        this.topos.put(topoId, new WithAcl<StormTopology>(acl, topo));
    }

    public Map<String, Object> readTopoConf(String topoId, Subject who) throws KeyNotFoundException, AuthorizationException, IOException {
        String key = ConfigUtils.masterStormConfKey((String)topoId);
        WithAcl<Map<String, Object>> cached = this.confs.get(topoId);
        if (cached == null) {
            Map topoConf = Utils.fromCompressedJsonConf((byte[])this.store.readBlob(key, who));
            ReadableBlobMeta meta = this.store.getBlobMeta(key, who);
            cached = new WithAcl<Map>(meta.get_settable().get_acl(), topoConf);
            WithAcl<Map<String, Object>> previous = this.confs.putIfAbsent(topoId, cached);
            if (previous != null) {
                cached = previous;
            }
        } else {
            this.aclHandler.hasPermissions(cached.acl, 1, who, key);
        }
        return (Map)cached.data;
    }

    public void deleteTopoConf(String topoId, Subject who) throws AuthorizationException, KeyNotFoundException {
        String key = ConfigUtils.masterStormConfKey((String)topoId);
        this.store.deleteBlob(key, who);
        this.confs.remove(topoId);
    }

    public void addTopoConf(String topoId, Subject who, Map<String, Object> topoConf) throws AuthorizationException, KeyAlreadyExistsException, IOException {
        String key = ConfigUtils.masterStormConfKey((String)topoId);
        List acl = BlobStoreAclHandler.DEFAULT;
        SettableBlobMeta meta = new SettableBlobMeta(acl);
        this.store.createBlob(key, Utils.toCompressedJsonConf(topoConf), meta, who);
        this.confs.put(topoId, new WithAcl<Map<String, Object>>(meta.get_acl(), topoConf));
    }

    public void updateTopoConf(String topoId, Subject who, Map<String, Object> topoConf) throws AuthorizationException, KeyNotFoundException, IOException {
        String key = ConfigUtils.masterStormConfKey((String)topoId);
        this.store.updateBlob(key, Utils.toCompressedJsonConf(topoConf), who);
        List acl = BlobStoreAclHandler.DEFAULT;
        WithAcl<Map<String, Object>> old = this.confs.get(topoId);
        acl = old != null ? old.acl : this.store.getBlobMeta(key, who).get_settable().get_acl();
        this.confs.put(topoId, new WithAcl<Map<String, Object>>(acl, topoConf));
    }

    public void clear() {
        this.confs.clear();
        this.topos.clear();
    }

    private static final class WithAcl<T> {
        public final List<AccessControl> acl;
        public final T data;

        WithAcl(List<AccessControl> acl, T data) {
            this.acl = acl;
            this.data = data;
        }
    }
}

