/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

@Singleton
@Named(value="slingosgifeature")
public class FeatureLifecycleMappingProvider
implements Provider<LifecycleMapping> {
    private static final String DEFAULT_LIFECYCLE_KEY = "default";
    private static final Map<String, LifecyclePhase> BINDINGS = new HashMap<String, LifecyclePhase>();
    private final Lifecycle defaultLifecycle = new Lifecycle();
    private final LifecycleMapping lifecycleMapping;

    public FeatureLifecycleMappingProvider() {
        this.defaultLifecycle.setId(DEFAULT_LIFECYCLE_KEY);
        this.defaultLifecycle.setLifecyclePhases(BINDINGS);
        this.lifecycleMapping = new LifecycleMapping(){

            public Map<String, Lifecycle> getLifecycles() {
                return Collections.singletonMap(FeatureLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY, FeatureLifecycleMappingProvider.this.defaultLifecycle);
            }

            public List<String> getOptionalMojos(String lifecycle) {
                return null;
            }

            public Map<String, String> getPhases(String lifecycle) {
                if (FeatureLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY.equals(lifecycle)) {
                    return FeatureLifecycleMappingProvider.this.defaultLifecycle.getPhases();
                }
                return null;
            }
        };
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }

    static {
        BINDINGS.put("install", new LifecyclePhase("org.apache.sling:slingfeature-maven-plugin:attach-features,org.apache.maven.plugins:maven-install-plugin:install"));
        BINDINGS.put("deploy", new LifecyclePhase("org.apache.maven.plugins:maven-deploy-plugin:deploy"));
    }
}

