/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.impl.WidthUtils;
import io.wcm.wcm.commons.component.ComponentPropertyResolution;
import io.wcm.wcm.commons.component.ComponentPropertyResolver;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
@SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
public final class MediaComponentPropertyResolver
implements AutoCloseable {
    static final String RESPONSIVE_TYPE_IMAGE_SIZES = "imageSizes";
    static final String RESPONSIVE_TYPE_PICTURE_SOURCES = "pictureSources";
    static final String PN_IMAGES_SIZES_SIZES = "sizes";
    static final String PN_IMAGES_SIZES_WIDTHS = "widths";
    static final String PN_PICTURE_SOURCES_MEDIAFORMAT = "mediaFormat";
    static final String PN_PICTURE_SOURCES_MEDIA = "media";
    static final String PN_PICTURE_SOURCES_SIZES = "sizes";
    static final String PN_PICTURE_SOURCES_WIDTHS = "widths";
    private final ComponentPropertyResolver resolver;

    public MediaComponentPropertyResolver(@NotNull Resource resource, @NotNull ComponentPropertyResolverFactory componentPropertyResolverFactory) {
        this.resolver = componentPropertyResolverFactory.get(resource, true).contentPolicyResolution(ComponentPropertyResolution.RESOLVE).componentPropertiesResolution(ComponentPropertyResolution.RESOLVE_INHERIT);
    }

    @Deprecated
    public MediaComponentPropertyResolver(@NotNull Resource resource) {
        this.resolver = new ComponentPropertyResolver(resource, true).contentPolicyResolution(ComponentPropertyResolution.RESOLVE).componentPropertiesResolution(ComponentPropertyResolution.RESOLVE_INHERIT);
    }

    public boolean isAutoCrop() {
        return (Boolean)this.resolver.get("wcmio:mediaCropAuto", (Object)false);
    }

    public @NotNull MediaArgs.MediaFormatOption @Nullable [] getMediaFormatOptions() {
        String[] mediaFormatsMandatoryNames;
        LinkedHashMap<String, MediaArgs.MediaFormatOption> mediaFormatOptions = new LinkedHashMap<String, MediaArgs.MediaFormatOption>();
        String[] mediaFormatNames = (String[])this.resolver.get("wcmio:mediaFormats", String[].class);
        Boolean[] mediaFormatsMandatory = (Boolean[])this.resolver.get("wcmio:mediaFormatsMandatory", Boolean[].class);
        if (mediaFormatNames != null) {
            for (int i = 0; i < mediaFormatNames.length; ++i) {
                boolean mandatory = false;
                if (mediaFormatsMandatory != null) {
                    if (mediaFormatsMandatory.length == 1) {
                        mandatory = mediaFormatsMandatory[0];
                    } else if (mediaFormatsMandatory.length > i) {
                        mandatory = mediaFormatsMandatory[i];
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)mediaFormatNames[i])) continue;
                mediaFormatOptions.put(mediaFormatNames[i], new MediaArgs.MediaFormatOption(mediaFormatNames[i], mandatory));
            }
        }
        if ((mediaFormatsMandatoryNames = (String[])this.resolver.get("wcmio:mediaFormatsMandatoryNames", String[].class)) != null) {
            for (String mediaFormatName : mediaFormatsMandatoryNames) {
                if (!StringUtils.isNotBlank((CharSequence)mediaFormatName)) continue;
                mediaFormatOptions.put(mediaFormatName, new MediaArgs.MediaFormatOption(mediaFormatName, true));
            }
        }
        if (mediaFormatOptions.isEmpty()) {
            return null;
        }
        return (MediaArgs.MediaFormatOption[])mediaFormatOptions.values().stream().toArray(MediaArgs.MediaFormatOption[]::new);
    }

    public @NotNull String @Nullable [] getMediaFormatNames() {
        String[] result;
        MediaArgs.MediaFormatOption[] mediaFormatOptions = this.getMediaFormatOptions();
        if (mediaFormatOptions != null && (result = (String[])Arrays.stream(mediaFormatOptions).map(option -> option.getMediaFormatName()).filter(Objects::nonNull).toArray(String[]::new)).length > 0) {
            return result;
        }
        return null;
    }

    public @NotNull String @Nullable [] getMandatoryMediaFormatNames() {
        String[] result;
        MediaArgs.MediaFormatOption[] mediaFormatOptions = this.getMediaFormatOptions();
        if (mediaFormatOptions != null && (result = (String[])Arrays.stream(mediaFormatOptions).filter(MediaArgs.MediaFormatOption::isMandatory).map(option -> option.getMediaFormatName()).filter(Objects::nonNull).toArray(String[]::new)).length > 0) {
            return result;
        }
        return null;
    }

    @Nullable
    public MediaArgs.ImageSizes getImageSizes() {
        String responsiveType = this.getResponsiveType();
        if (responsiveType != null && !StringUtils.equals((CharSequence)responsiveType, (CharSequence)RESPONSIVE_TYPE_IMAGE_SIZES)) {
            return null;
        }
        String sizes = StringUtils.trimToNull((String)((String)this.resolver.get("wcmio:mediaResponsiveImageSizes/sizes", String.class)));
        MediaArgs.WidthOption[] widths = WidthUtils.parseWidths((String)this.resolver.get("wcmio:mediaResponsiveImageSizes/widths", String.class));
        if (sizes != null && widths != null) {
            return new MediaArgs.ImageSizes(sizes, widths);
        }
        sizes = StringUtils.trimToNull((String)((String)this.resolver.get("wcmio:mediaRepsonsiveImageSizes/sizes", String.class)));
        widths = WidthUtils.parseWidths((String)this.resolver.get("wcmio:mediaRepsonsiveImageSizes/widths", String.class));
        if (sizes != null && widths != null) {
            return new MediaArgs.ImageSizes(sizes, widths);
        }
        return null;
    }

    public @NotNull MediaArgs.PictureSource @Nullable [] getPictureSources() {
        String responsiveType = this.getResponsiveType();
        if (responsiveType != null && !StringUtils.equals((CharSequence)responsiveType, (CharSequence)RESPONSIVE_TYPE_PICTURE_SOURCES)) {
            return null;
        }
        Collection sourceResources = this.resolver.getResources("wcmio:mediaResponsivePictureSources");
        if (sourceResources == null && (sourceResources = this.resolver.getResources("wcmio:mediaRepsonsivePictureSources")) == null) {
            return null;
        }
        ArrayList<MediaArgs.PictureSource> sources = new ArrayList<MediaArgs.PictureSource>();
        for (Resource sourceResource : sourceResources) {
            ValueMap props = sourceResource.getValueMap();
            String mediaFormatName = StringUtils.trimToNull((String)((String)props.get(PN_PICTURE_SOURCES_MEDIAFORMAT, String.class)));
            String media = StringUtils.trimToNull((String)((String)props.get(PN_PICTURE_SOURCES_MEDIA, String.class)));
            String sizes = StringUtils.trimToNull((String)((String)props.get("sizes", String.class)));
            MediaArgs.WidthOption[] widths = WidthUtils.parseWidths((String)props.get("widths", String.class));
            if (mediaFormatName == null || widths == null) continue;
            sources.add(new MediaArgs.PictureSource(mediaFormatName).media(media).sizes(sizes).widthOptions(widths));
        }
        if (sources.isEmpty()) {
            return null;
        }
        return (MediaArgs.PictureSource[])sources.stream().toArray(MediaArgs.PictureSource[]::new);
    }

    private String getResponsiveType() {
        return (String)this.resolver.get("wcmio:mediaResponsiveType", String.class);
    }

    @Override
    public void close() throws Exception {
        this.resolver.close();
    }
}

