/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.markup.DragDropSupport;
import io.wcm.handler.media.markup.IPERatioCustomize;
import io.wcm.handler.url.UrlMode;
import io.wcm.wcm.commons.util.ToStringStyle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MediaArgs
implements Cloneable {
    private MediaFormatOption[] mediaFormatOptions;
    private boolean autoCrop;
    private String[] fileExtensions;
    private UrlMode urlMode;
    private long fixedWidth;
    private long fixedHeight;
    private boolean download;
    private boolean contentDispositionAttachment;
    private String altText;
    private boolean dummyImage = true;
    private String dummyImageUrl;
    private boolean includeAssetThumbnails;
    private Boolean includeAssetWebRenditions;
    private ImageSizes imageSizes;
    private PictureSource[] pictureSourceSets;
    private DragDropSupport dragDropSupport = DragDropSupport.AUTO;
    private IPERatioCustomize ipeRatioCustomize = IPERatioCustomize.AUTO;
    private boolean dynamicMediaDisabled;
    private ValueMap properties;

    public MediaArgs() {
    }

    public MediaArgs(MediaFormat ... mediaFormats) {
        this.mediaFormats(mediaFormats);
    }

    public MediaArgs(String ... mediaFormatNames) {
        this.mediaFormatNames(mediaFormatNames);
    }

    public MediaFormat[] getMediaFormats() {
        MediaFormat[] result;
        if (this.mediaFormatOptions != null && (result = (MediaFormat[])Arrays.stream(this.mediaFormatOptions).filter(option -> option.getMediaFormatName() == null).map(option -> option.getMediaFormat()).toArray(MediaFormat[]::new)).length > 0) {
            return result;
        }
        return null;
    }

    @NotNull
    public MediaArgs mediaFormats(MediaFormat ... values) {
        this.mediaFormatOptions = values == null || values.length == 0 ? null : (MediaFormatOption[])Arrays.stream(values).map(mediaFormat -> new MediaFormatOption((MediaFormat)mediaFormat, false)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mandatoryMediaFormats(MediaFormat ... values) {
        this.mediaFormatOptions = values == null || values.length == 0 ? null : (MediaFormatOption[])Arrays.stream(values).map(mediaFormat -> new MediaFormatOption((MediaFormat)mediaFormat, true)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mediaFormat(MediaFormat value) {
        this.mediaFormatOptions = value == null ? null : new MediaFormatOption[]{new MediaFormatOption(value, false)};
        return this;
    }

    @Deprecated
    public boolean isMediaFormatsMandatory() {
        if (this.mediaFormatOptions == null) {
            return false;
        }
        return !Arrays.stream(this.mediaFormatOptions).filter(option -> !option.isMandatory()).findFirst().isPresent();
    }

    @NotNull
    public MediaArgs mediaFormatsMandatory(boolean value) {
        if (this.mediaFormatOptions != null) {
            this.mediaFormatOptions = (MediaFormatOption[])Arrays.stream(this.mediaFormatOptions).map(option -> option.withMandatory(value)).toArray(MediaFormatOption[]::new);
        }
        return this;
    }

    public String[] getMediaFormatNames() {
        String[] result;
        if (this.mediaFormatOptions != null && (result = (String[])Arrays.stream(this.mediaFormatOptions).filter(option -> option.getMediaFormatName() != null).map(option -> option.getMediaFormatName()).toArray(String[]::new)).length > 0) {
            return result;
        }
        return null;
    }

    @NotNull
    public MediaArgs mediaFormatNames(String ... names) {
        this.mediaFormatOptions = names == null || names.length == 0 ? null : (MediaFormatOption[])Arrays.stream(names).map(name -> new MediaFormatOption((String)name, false)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mandatoryMediaFormatNames(String ... names) {
        this.mediaFormatOptions = names == null || names.length == 0 ? null : (MediaFormatOption[])Arrays.stream(names).map(name -> new MediaFormatOption((String)name, true)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mediaFormatName(String name) {
        this.mediaFormatOptions = name == null ? null : new MediaFormatOption[]{new MediaFormatOption(name, false)};
        return this;
    }

    public MediaFormatOption[] getMediaFormatOptions() {
        return this.mediaFormatOptions;
    }

    @NotNull
    public MediaArgs mediaFormatOptions(MediaFormatOption ... values) {
        this.mediaFormatOptions = values == null || values.length == 0 ? null : values;
        return this;
    }

    public boolean isAutoCrop() {
        return this.autoCrop;
    }

    @NotNull
    public MediaArgs autoCrop(boolean value) {
        this.autoCrop = value;
        return this;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    @NotNull
    public MediaArgs fileExtensions(String ... values) {
        this.fileExtensions = values == null || values.length == 0 ? null : values;
        return this;
    }

    @NotNull
    public MediaArgs fileExtension(String value) {
        this.fileExtensions = value == null ? null : new String[]{value};
        return this;
    }

    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    @NotNull
    public MediaArgs urlMode(UrlMode value) {
        this.urlMode = value;
        return this;
    }

    public long getFixedWidth() {
        return this.fixedWidth;
    }

    @NotNull
    public MediaArgs fixedWidth(long value) {
        this.fixedWidth = value;
        return this;
    }

    public long getFixedHeight() {
        return this.fixedHeight;
    }

    @NotNull
    public MediaArgs fixedHeight(long value) {
        this.fixedHeight = value;
        return this;
    }

    @NotNull
    public MediaArgs fixedDimension(long widthValue, long heightValue) {
        this.fixedWidth = widthValue;
        this.fixedHeight = heightValue;
        return this;
    }

    public boolean isDownload() {
        return this.download;
    }

    @NotNull
    public MediaArgs download(boolean value) {
        this.download = value;
        return this;
    }

    public boolean isContentDispositionAttachment() {
        return this.contentDispositionAttachment;
    }

    @NotNull
    public MediaArgs contentDispositionAttachment(boolean value) {
        this.contentDispositionAttachment = value;
        return this;
    }

    public String getAltText() {
        return this.altText;
    }

    @NotNull
    public MediaArgs altText(String value) {
        this.altText = value;
        return this;
    }

    public boolean isDummyImage() {
        return this.dummyImage;
    }

    @NotNull
    public MediaArgs dummyImage(boolean value) {
        this.dummyImage = value;
        return this;
    }

    public String getDummyImageUrl() {
        return this.dummyImageUrl;
    }

    @NotNull
    public MediaArgs dummyImageUrl(String value) {
        this.dummyImageUrl = value;
        return this;
    }

    public boolean isIncludeAssetThumbnails() {
        return this.includeAssetThumbnails;
    }

    @NotNull
    public MediaArgs includeAssetThumbnails(boolean value) {
        this.includeAssetThumbnails = value;
        return this;
    }

    public Boolean isIncludeAssetWebRenditions() {
        return this.includeAssetWebRenditions;
    }

    @NotNull
    public MediaArgs includeAssetWebRenditions(boolean value) {
        this.includeAssetWebRenditions = value;
        return this;
    }

    public ImageSizes getImageSizes() {
        return this.imageSizes;
    }

    @NotNull
    public MediaArgs imageSizes(ImageSizes value) {
        this.imageSizes = value;
        return this;
    }

    public PictureSource[] getPictureSources() {
        return this.pictureSourceSets;
    }

    @NotNull
    public MediaArgs pictureSources(PictureSource ... value) {
        this.pictureSourceSets = value;
        return this;
    }

    public boolean isDynamicMediaDisabled() {
        return this.dynamicMediaDisabled;
    }

    @NotNull
    public MediaArgs dynamicMediaDisabled(boolean value) {
        this.dynamicMediaDisabled = value;
        return this;
    }

    public DragDropSupport getDragDropSupport() {
        return this.dragDropSupport;
    }

    @NotNull
    public MediaArgs dragDropSupport(DragDropSupport value) {
        if (value == null) {
            throw new IllegalArgumentException("No null value allowed for drag&drop support.");
        }
        this.dragDropSupport = value;
        return this;
    }

    public IPERatioCustomize getIPERatioCustomize() {
        return this.ipeRatioCustomize;
    }

    @NotNull
    public MediaArgs ipeRatioCustomize(IPERatioCustomize value) {
        this.ipeRatioCustomize = value;
        return this;
    }

    @NotNull
    public MediaArgs properties(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map argument must not be null.");
        }
        this.getProperties().putAll(map);
        return this;
    }

    @NotNull
    public MediaArgs property(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key argument must not be null.");
        }
        this.getProperties().put((Object)key, value);
        return this;
    }

    @NotNull
    public ValueMap getProperties() {
        if (this.properties == null) {
            this.properties = new ValueMapDecorator(new HashMap());
        }
        return this.properties;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
    }

    public MediaArgs clone() {
        MediaArgs clone = new MediaArgs();
        clone.mediaFormatOptions = (MediaFormatOption[])ArrayUtils.clone((Object[])this.mediaFormatOptions);
        clone.autoCrop = this.autoCrop;
        clone.fileExtensions = (String[])ArrayUtils.clone((Object[])this.fileExtensions);
        clone.urlMode = this.urlMode;
        clone.fixedWidth = this.fixedWidth;
        clone.fixedHeight = this.fixedHeight;
        clone.download = this.download;
        clone.contentDispositionAttachment = this.contentDispositionAttachment;
        clone.altText = this.altText;
        clone.dummyImage = this.dummyImage;
        clone.dummyImageUrl = this.dummyImageUrl;
        clone.includeAssetThumbnails = this.includeAssetThumbnails;
        clone.includeAssetWebRenditions = this.includeAssetWebRenditions;
        clone.imageSizes = this.imageSizes;
        clone.pictureSourceSets = (PictureSource[])ArrayUtils.clone((Object[])this.pictureSourceSets);
        clone.dragDropSupport = this.dragDropSupport;
        clone.ipeRatioCustomize = this.ipeRatioCustomize;
        clone.dynamicMediaDisabled = this.dynamicMediaDisabled;
        if (this.properties != null) {
            clone.properties = new ValueMapDecorator(new HashMap(this.properties));
        }
        return clone;
    }

    @ProviderType
    public static final class WidthOption {
        private final long width;
        private final boolean mandatory;

        public WidthOption(long width, boolean mandatory) {
            this.width = width;
            this.mandatory = mandatory;
        }

        public long getWidth() {
            return this.width;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        }
    }

    @ProviderType
    public static final class PictureSource {
        private MediaFormat mediaFormat;
        private String mediaFormatName;
        private String media;
        private String sizes;
        private WidthOption[] widthOptions;

        public PictureSource(@NotNull MediaFormat mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public PictureSource(@Nullable String mediaFormatName) {
            this.mediaFormatName = mediaFormatName;
        }

        @Deprecated
        public PictureSource(@NotNull MediaFormat mediaFormat, @Nullable String media, long ... widths) {
            this.mediaFormat = mediaFormat;
            this.media = media;
            this.widthOptions = PictureSource.toWidthOptions(widths);
        }

        @Deprecated
        public PictureSource(@Nullable MediaFormat mediaFormat, @Nullable String media, WidthOption ... widthOptions) {
            this.mediaFormat = mediaFormat;
            this.media = media;
            this.widthOptions = widthOptions;
        }

        @NotNull
        private static @NotNull WidthOption @NotNull [] toWidthOptions(long ... widths) {
            return (WidthOption[])Arrays.stream(widths).mapToObj(width -> new WidthOption(width, true)).toArray(WidthOption[]::new);
        }

        @Nullable
        public MediaFormat getMediaFormat() {
            return this.mediaFormat;
        }

        @Nullable
        public String getMediaFormatName() {
            return this.mediaFormatName;
        }

        public PictureSource widthOptions(WidthOption ... value) {
            this.widthOptions = value;
            return this;
        }

        public @NotNull WidthOption @Nullable [] getWidthOptions() {
            return this.widthOptions;
        }

        public PictureSource widths(long ... value) {
            this.widthOptions = PictureSource.toWidthOptions(value);
            return this;
        }

        @Deprecated
        public long @Nullable [] getWidths() {
            return Arrays.stream(this.widthOptions).mapToLong(WidthOption::getWidth).toArray();
        }

        public PictureSource sizes(@Nullable String value) {
            this.sizes = value;
            return this;
        }

        @Nullable
        public String getSizes() {
            return this.sizes;
        }

        public PictureSource media(@Nullable String value) {
            this.media = value;
            return this;
        }

        @Nullable
        public String getMedia() {
            return this.media;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        }
    }

    @ProviderType
    public static final class ImageSizes {
        @NotNull
        private final String sizes;
        @NotNull
        private final @NotNull WidthOption @NotNull [] widthOptions;

        public ImageSizes(@NotNull String sizes, long ... widths) {
            this.sizes = sizes;
            this.widthOptions = (WidthOption[])Arrays.stream(widths).mapToObj(width -> new WidthOption(width, true)).toArray(WidthOption[]::new);
        }

        public ImageSizes(@NotNull String sizes, WidthOption ... widthOptions) {
            this.sizes = sizes;
            this.widthOptions = widthOptions;
        }

        @NotNull
        public String getSizes() {
            return this.sizes;
        }

        @Deprecated
        public long @Nullable [] getWidths() {
            return Arrays.stream(this.widthOptions).mapToLong(WidthOption::getWidth).toArray();
        }

        public @NotNull WidthOption @Nullable [] getWidthOptions() {
            return this.widthOptions;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        }
    }

    @ProviderType
    public static final class MediaFormatOption {
        private final MediaFormat mediaFormat;
        private final String mediaFormatName;
        private final boolean mandatory;

        public MediaFormatOption(@Nullable MediaFormat mediaFormat, boolean mandatory) {
            this.mediaFormat = mediaFormat;
            this.mediaFormatName = null;
            this.mandatory = mandatory;
        }

        public MediaFormatOption(@NotNull String mediaFormatName, boolean mandatory) {
            this.mediaFormat = null;
            this.mediaFormatName = mediaFormatName;
            this.mandatory = mandatory;
        }

        @Nullable
        public MediaFormat getMediaFormat() {
            return this.mediaFormat;
        }

        @Nullable
        public String getMediaFormatName() {
            return this.mediaFormatName;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        }

        @NotNull
        MediaFormatOption withMandatory(boolean newMandatory) {
            if (this.mediaFormat != null) {
                return new MediaFormatOption(this.mediaFormat, newMandatory);
            }
            return new MediaFormatOption(this.mediaFormatName, newMandatory);
        }
    }
}

