/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl.contentpackage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ZipArchive;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.ValidationExecutorFactory;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.context.AbstractDependencyResolver;
import org.apache.jackrabbit.vault.validation.context.ArchiveValidationContext;
import org.apache.jackrabbit.vault.validation.context.DependencyResolver;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageValidator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final ValidationExecutorFactory validationExecutorFactory;
    private final URI artifactURI;
    private final Collection<ValidationViolation> messages;
    private ArchiveValidationContext context;
    private ValidationExecutor executor;
    private Map<String, ? extends ValidatorSettings> validatorSettings;

    public PackageValidator(URI artifactURI, Map<String, ? extends ValidatorSettings> validatorSettings) {
        this.artifactURI = artifactURI;
        this.validatorSettings = validatorSettings;
        this.validationExecutorFactory = new ValidationExecutorFactory(this.getClass().getClassLoader());
        this.messages = new LinkedList<ValidationViolation>();
    }

    public Collection<ValidationViolation> validate() throws IOException {
        Path artifactPath = Paths.get(this.artifactURI);
        try (ZipArchive archive = new ZipArchive(new File(this.artifactURI));){
            archive.open(true);
            this.context = new ArchiveValidationContext((Archive)archive, artifactPath, (DependencyResolver)new NoopDependencyResolver());
            this.executor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)this.context, false, false, this.validatorSettings);
            if (this.executor != null) {
                this.printUsedValidators(true);
                this.validateArchive((Archive)archive, artifactPath);
            } else {
                this.log.warn("No registered validators found. Skipping validation.");
            }
        }
        catch (IOException e) {
            throw new IOException("Error while checking archive " + this.artifactURI, e);
        }
        return this.messages;
    }

    private void validateArchive(Archive archive, Path path) throws IOException {
        this.validateEntry(archive, archive.getRoot(), Paths.get("", new String[0]), path);
        this.messages.addAll(this.executor.done());
    }

    private void validateEntry(Archive archive, Archive.Entry entry, Path entryPath, Path packagePath) throws IOException {
        ArrayList<Archive.Entry> sortedEntryList = new ArrayList<Archive.Entry>(entry.getChildren());
        sortedEntryList.sort(Comparator.comparing(Archive.Entry::getName, new DotContentXmlFirstComparator()));
        for (Archive.Entry childEntry : sortedEntryList) {
            if (childEntry.isDirectory()) {
                this.validateInputStream(null, entryPath.resolve(childEntry.getName()), packagePath);
                this.validateEntry(archive, childEntry, entryPath.resolve(childEntry.getName()), packagePath);
                continue;
            }
            InputStream input = archive.openInputStream(childEntry);
            try {
                this.validateInputStream(input, entryPath.resolve(childEntry.getName()), packagePath);
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
    }

    private void validateInputStream(InputStream inputStream, Path entryPath, Path packagePath) throws IOException {
        if (entryPath.startsWith("META-INF")) {
            this.messages.addAll(this.executor.validateMetaInf(inputStream, Paths.get("META-INF", new String[0]).relativize(entryPath), packagePath.resolve("META-INF")));
        } else if (entryPath.startsWith("jcr_root")) {
            Path relativeJcrPath = Paths.get("jcr_root", new String[0]).relativize(entryPath);
            this.messages.addAll(this.executor.validateJcrRoot(inputStream, relativeJcrPath, packagePath.resolve("jcr_root")));
        } else {
            this.messages.add(new ValidationViolation(ValidationMessageSeverity.WARN, "Found unexpected file outside of jcr_root and META-INF", entryPath, packagePath, null, 0, 0, null));
        }
    }

    private void printUsedValidators(boolean printUnusedValidators) {
        Map unusedValidatorsById;
        String packageType = this.context.getProperties().getPackageType() != null ? this.context.getProperties().getPackageType().toString() : "unknown";
        int numValidators = this.executor.getAllValidatorsById().entrySet().size();
        this.log.info("Using {} validators for package of type {}: {}", new Object[]{numValidators, packageType, this.getValidatorNames()});
        if (printUnusedValidators && !(unusedValidatorsById = this.executor.getUnusedValidatorsById()).isEmpty()) {
            String validatorNames = StringUtils.join(unusedValidatorsById.keySet(), (String)".");
            this.log.warn("There are unused validators among those which are not executed: {}", (Object)validatorNames);
        }
    }

    private String getValidatorNames() {
        return this.executor.getAllValidatorsById().entrySet().stream().map(this::describeValidator).collect(Collectors.joining(", "));
    }

    private String describeValidator(Map.Entry<String, Validator> validatorById) {
        String validatorClassName = validatorById.getValue().getClass().getName();
        return validatorById.getKey() + " (" + validatorClassName + ")";
    }

    static final class NoopDependencyResolver
    extends AbstractDependencyResolver {
        NoopDependencyResolver() {
        }

        @Nullable
        public PackageInfo resolvePackageInfo(@NotNull AbstractDependencyResolver.MavenCoordinates mavenCoordinates) throws IOException {
            return null;
        }
    }

    static final class DotContentXmlFirstComparator
    implements Comparator<String> {
        DotContentXmlFirstComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (".content.xml".equals(s1) && ".content.xml".equals(s2)) {
                return 0;
            }
            if (".content.xml".equals(s1)) {
                return -1;
            }
            if (".content.xml".equals(s2)) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

