/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.panama;

import java.io.File;
import java.lang.foreign.Arena;
import java.lang.foreign.SymbolLookup;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.panama.LibraryStatus;
import org.apache.sis.storage.panama.NativeFunctions;
import org.apache.sis.storage.panama.Resources;
import org.apache.sis.system.Shutdown;

public final class LibraryLoader<F extends NativeFunctions> {
    String filename;
    Arena arena;
    SymbolLookup symbols;
    private Function<LibraryLoader<F>, F> creator;
    private LibraryStatus status;
    private RuntimeException error;

    public LibraryLoader(Function<LibraryLoader<F>, F> creator) {
        this.creator = creator;
    }

    public F load(Path library) {
        NativeFunctions instance;
        Function<LibraryLoader<F>, F> c = this.creator;
        this.creator = null;
        this.filename = library.getFileName().toString();
        this.status = LibraryStatus.LIBRARY_NOT_FOUND;
        this.arena = Arena.ofShared();
        try {
            this.symbols = SymbolLookup.libraryLookup(library, this.arena);
            this.status = LibraryStatus.FUNCTION_NOT_FOUND;
            instance = (NativeFunctions)c.apply(this);
            this.status = LibraryStatus.LOADED;
        }
        catch (Throwable e) {
            this.arena.close();
            throw e;
        }
        return (F)instance;
    }

    public F global(String library) {
        NativeFunctions instance;
        block9: {
            Function<LibraryLoader<F>, F> c = this.creator;
            this.creator = null;
            this.filename = File.separatorChar == '\\' ? library + ".dll" : "lib" + library + ".so";
            this.status = LibraryStatus.LIBRARY_NOT_FOUND;
            instance = null;
            try {
                try {
                    this.symbols = SymbolLookup.libraryLookup(this.filename, Arena.global());
                }
                catch (IllegalArgumentException e) {
                    this.error = e;
                    this.filename = "system";
                    this.symbols = SymbolLookup.loaderLookup();
                }
                try {
                    instance = (NativeFunctions)c.apply(this);
                    this.status = LibraryStatus.LOADED;
                }
                catch (RuntimeException e) {
                    if (this.error != null) {
                        this.error.addSuppressed(e);
                    } else {
                        this.error = e;
                    }
                    break block9;
                }
                Shutdown.register((Callable)instance);
            }
            catch (IllegalCallerException e) {
                this.error = e;
                this.status = LibraryStatus.UNAUTHORIZED;
            }
            catch (NoSuchElementException e) {
                this.error = e;
                this.status = LibraryStatus.FUNCTION_NOT_FOUND;
            }
        }
        return (F)instance;
    }

    public final LibraryStatus status() {
        return this.status;
    }

    public void validate(String library) throws DataStoreException {
        this.status.report(library, this.error);
    }

    public Optional<LogRecord> getError(String name) {
        if (this.error == null) {
            return Optional.empty();
        }
        LogRecord record = Resources.forLocale(null).createLogRecord(Level.CONFIG, (short)2, name);
        record.setThrown(this.error);
        return Optional.of(record);
    }
}

