/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.Swagger;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.ConsumerMicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.SubscriberOrder;
import org.apache.servicecomb.registry.api.event.CreateMicroserviceEvent;
import org.apache.servicecomb.registry.api.event.CreateMicroserviceVersionEvent;
import org.apache.servicecomb.registry.api.event.DestroyMicroserviceEvent;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.consumer.MicroserviceVersion;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryListener.class);
    private static final String SHOULD_WOKR_WITH_THIRD_PARTY = "servicecomb.service.registry.workWithThirdParty";
    private static final int SCHEMA_RETRY = 3;
    private final SCBEngine scbEngine;

    public ServiceRegistryListener(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
        scbEngine.getEventBus().register((Object)this);
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onCreateMicroservice(CreateMicroserviceEvent event) {
        MicroserviceVersions microserviceVersions = event.getMicroserviceVersions();
        microserviceVersions.getVendorExtensions().put((Object)"scb_microservice_versions_meta", (Object)new ConsumerMicroserviceVersionsMeta(this.scbEngine, microserviceVersions));
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onDestroyMicroservice(DestroyMicroserviceEvent event) {
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onCreateMicroserviceVersion(CreateMicroserviceVersionEvent event) {
        boolean isServiceCenter;
        MicroserviceVersion microserviceVersion = event.getMicroserviceVersion();
        Microservice microservice = microserviceVersion.getMicroservice();
        String microserviceName = microserviceVersion.getMicroserviceName();
        MicroserviceMeta microserviceMeta = new MicroserviceMeta(this.scbEngine, microserviceName, true);
        microserviceMeta.setHandlerChain((List)this.scbEngine.getConsumerHandlerManager().getOrCreate(microserviceName));
        microserviceMeta.setFilterChain(this.scbEngine.getFilterChainsManager().findConsumerChain(microserviceName));
        MicroserviceVersions microserviceVersions = microserviceVersion.getMicroserviceVersions();
        microserviceMeta.setMicroserviceVersionsMeta((MicroserviceVersionsMeta)CoreMetaUtils.getMicroserviceVersionsMeta(microserviceVersions));
        boolean bl = isServiceCenter = "default".equals(microservice.getAppId()) && "SERVICECENTER".equals(microservice.getServiceName());
        if (!isServiceCenter) {
            block0: for (String schemaId : microservice.getSchemas()) {
                for (int i = 0; i <= 3; ++i) {
                    Swagger swagger = this.scbEngine.getSwaggerLoader().loadSwagger(microservice, microserviceVersion.getInstances(), schemaId);
                    if (swagger != null) {
                        microserviceMeta.registerSchemaMeta(schemaId, swagger);
                        continue block0;
                    }
                    if (!DynamicPropertyFactory.getInstance().getBooleanProperty(SHOULD_WOKR_WITH_THIRD_PARTY, true).get()) {
                        throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "swagger can not be empty or load swagger failed");
                    }
                    LOGGER.warn("load schema id {} failed, and retry times is {}", (Object)schemaId, (Object)i);
                }
            }
        }
        microserviceMeta.putExtData("scb_microservice_version", microserviceVersion);
        microserviceVersion.getVendorExtensions().put((Object)"scb_microservice_meta", (Object)microserviceMeta);
    }

    public void destroy() {
        this.scbEngine.getEventBus().unregister((Object)this);
    }
}

