/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics.metric;

import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;

public class DefaultRequestMetric {
    private long requestBeginTime;
    private long requestEndTime;
    private long responseBeginTime;
    private long responseEndTime;
    private final DefaultEndpointMetric endpointMetric;

    public DefaultRequestMetric(DefaultEndpointMetric endpointMetric) {
        this.endpointMetric = endpointMetric;
    }

    public long getRequestBeginTime() {
        return this.requestBeginTime != 0L ? this.requestBeginTime : System.nanoTime();
    }

    public long getRequestEndTime() {
        return this.requestEndTime != 0L ? this.requestEndTime : System.nanoTime();
    }

    public long getResponseBeginTime() {
        return this.responseBeginTime != 0L ? this.responseBeginTime : System.nanoTime();
    }

    public long getResponseEndTime() {
        return this.responseEndTime != 0L ? this.responseEndTime : System.nanoTime();
    }

    public void requestBegin() {
        this.requestBeginTime = System.nanoTime();
    }

    public void requestEnd() {
        this.requestEndTime = System.nanoTime();
    }

    public void responseBegin() {
        this.responseBeginTime = System.nanoTime();
    }

    public void responseEnd() {
        this.responseEndTime = System.nanoTime();
        this.endpointMetric.incrementRequests();
        this.endpointMetric.addLatency(System.nanoTime() - this.requestBeginTime);
    }
}

