/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectStatistic;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

public class QpidCollector
extends Collector {
    private static final Collector.MetricFamilySamples IGNORED = new Collector.MetricFamilySamples(null, null, null, null);
    static final String COUNT_SUFFIX = "count";
    static final String TOTAL_SUFFIX = "total";
    private final Predicate<ConfiguredObjectStatistic<?, ?>> _includeStatisticFilter;
    private final Predicate<String> _includeMetricFilter;
    private final ConfiguredObject<?> _root;
    private final Model _model;

    QpidCollector(ConfiguredObject<?> root, Predicate<ConfiguredObjectStatistic<?, ?>> includeStatisticFilter, Predicate<String> includeMetricFilter) {
        this._root = root;
        this._model = this._root.getModel();
        this._includeStatisticFilter = includeStatisticFilter;
        this._includeMetricFilter = includeMetricFilter;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> metricFamilySamples = new ArrayList<Collector.MetricFamilySamples>();
        this.addObjectMetrics(this._root, List.of(), new HashMap<String, Collector.MetricFamilySamples>(), metricFamilySamples);
        this.addChildrenMetrics(metricFamilySamples, this._root, List.of("name"));
        return metricFamilySamples;
    }

    private void addObjectMetrics(ConfiguredObject<?> object, List<String> labelNames, Map<String, Collector.MetricFamilySamples> metricFamilyMap, List<Collector.MetricFamilySamples> metricFamilySamples) {
        Map statsMap = object.getStatistics();
        for (Map.Entry entry : statsMap.entrySet()) {
            Collector.MetricFamilySamples family = metricFamilyMap.get(entry.getKey());
            if (family == null) {
                family = this.createMetricFamilySamples((String)entry.getKey(), object, labelNames);
                metricFamilyMap.put((String)entry.getKey(), family);
                if (family != IGNORED) {
                    metricFamilySamples.add(family);
                }
            }
            if (family == IGNORED) continue;
            List<String> labelsValues = this.buildLabelValues(object);
            double doubleValue = this.toDoubleValue(entry.getValue());
            family.samples.add(new Collector.MetricFamilySamples.Sample(family.name, labelNames, labelsValues, doubleValue));
        }
    }

    private Collector.MetricFamilySamples createMetricFamilySamples(String statisticName, ConfiguredObject<?> object, List<String> labelNames) {
        ConfiguredObjectStatistic<?, ?> configuredObjectStatistic = this.findConfiguredObjectStatistic(statisticName, object.getTypeClass());
        if (configuredObjectStatistic == null || !this._includeStatisticFilter.test(configuredObjectStatistic)) {
            return IGNORED;
        }
        StatisticType type = configuredObjectStatistic.getStatisticType();
        String familyName = QpidCollector.getFamilyName(object.getCategoryClass(), configuredObjectStatistic);
        if (!this._includeMetricFilter.test(familyName)) {
            return IGNORED;
        }
        if (type == StatisticType.CUMULATIVE) {
            return new CounterMetricFamily(familyName, configuredObjectStatistic.getDescription(), labelNames);
        }
        return new GaugeMetricFamily(familyName, configuredObjectStatistic.getDescription(), labelNames);
    }

    private ConfiguredObjectStatistic<?, ?> findConfiguredObjectStatistic(String statisticName, Class<? extends ConfiguredObject> typeClass) {
        Collection statisticsDefinitions = this._model.getTypeRegistry().getStatistics(typeClass);
        return statisticsDefinitions.stream().filter(s -> statisticName.equals(s.getName())).findFirst().orElse(null);
    }

    private List<String> buildLabelValues(ConfiguredObject<?> object) {
        ArrayList<String> labelsValues = new ArrayList<String>();
        for (ConfiguredObject o = object; o != null && o != this._root; o = o.getParent()) {
            labelsValues.add(o.getName());
        }
        return labelsValues;
    }

    private void addChildrenMetrics(List<Collector.MetricFamilySamples> metricFamilySamples, ConfiguredObject<?> object, List<String> childLabelNames) {
        Class category = object.getCategoryClass();
        for (Class childClass : this._model.getChildTypes(category)) {
            Collection children = object.getChildren(childClass);
            if (children == null || children.isEmpty()) continue;
            HashMap<String, Collector.MetricFamilySamples> childrenMetricFamilyMap = new HashMap<String, Collector.MetricFamilySamples>();
            for (ConfiguredObject child : children) {
                this.addObjectMetrics(child, childLabelNames, childrenMetricFamilyMap, metricFamilySamples);
                ArrayList<String> labelNames = new ArrayList<String>(childLabelNames);
                String label = String.format("%s_name", QpidCollector.toSnakeCase(childClass.getSimpleName()));
                labelNames.add(label);
                this.addChildrenMetrics(metricFamilySamples, child, labelNames);
            }
        }
    }

    static String toSnakeCase(String simpleName) {
        StringBuilder sb = new StringBuilder();
        char[] chars = simpleName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private double toDoubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    static String getFamilyName(Class<? extends ConfiguredObject> categoryClass, ConfiguredObjectStatistic<?, ?> statistics) {
        String metricName = statistics.getMetricName();
        if (metricName == null || metricName.isEmpty()) {
            metricName = QpidCollector.generateMetricName(statistics);
        }
        return String.format("qpid_%s_%s", QpidCollector.toSnakeCase(categoryClass.getSimpleName()), metricName);
    }

    private static String generateMetricName(ConfiguredObjectStatistic<?, ?> statistics) {
        String metricName = QpidCollector.toSnakeCase(statistics.getName());
        return metricName + (switch (statistics.getStatisticType()) {
            case StatisticType.CUMULATIVE -> QpidCollector.generateMetricSuffix(statistics, COUNT_SUFFIX, metricName);
            case StatisticType.POINT_IN_TIME -> QpidCollector.generateMetricSuffix(statistics, TOTAL_SUFFIX, metricName);
            default -> "";
        });
    }

    private static String generateMetricSuffix(ConfiguredObjectStatistic<?, ?> statistics, String typeSuffix, String metricName) {
        Object suffix = "";
        if (!statistics.getName().toLowerCase().contains(typeSuffix) && statistics.getUnits() != StatisticUnit.ABSOLUTE_TIME && statistics.getUnits() != StatisticUnit.TIME_DURATION) {
            String units;
            if (!(statistics.getUnits() != StatisticUnit.MESSAGES && statistics.getUnits() != StatisticUnit.BYTES || metricName.contains(units = statistics.getUnits().toString() + "s"))) {
                suffix = "_" + units;
            }
            suffix = (String)suffix + "_" + typeSuffix;
        }
        return suffix;
    }
}

