/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.preferences;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.store.AbstractJsonFileStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;

public class JsonFilePreferenceStore
extends AbstractJsonFileStore
implements PreferenceStore {
    private static final String DEFAULT_FILE_NAME = "userPreferences";
    private final String _storePath;
    private final String _posixFilePermissions;
    private final ObjectMapper _objectMapper;
    private final Map<UUID, StoredPreferenceRecord> _recordMap;
    private StoreState _storeState = StoreState.CLOSED;

    public JsonFilePreferenceStore(String path, String posixFilePermissions) {
        this._storePath = path;
        this._posixFilePermissions = posixFilePermissions;
        this._objectMapper = ConfiguredObjectJacksonModule.newObjectMapper(true).enable(SerializationFeature.INDENT_OUTPUT);
        this._recordMap = new LinkedHashMap<UUID, StoredPreferenceRecord>();
    }

    @Override
    public synchronized Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
        if (this._storeState != StoreState.CLOSED) {
            throw new IllegalStateException(String.format("PreferenceStore cannot be opened when in state '%s'", new Object[]{this._storeState}));
        }
        try {
            StoreContent storeContent;
            this.setup(DEFAULT_FILE_NAME, this._storePath, this._posixFilePermissions, Collections.singletonMap("version", "9.1"));
            try {
                storeContent = (StoreContent)this._objectMapper.readValue(this.getConfigFile(), StoreContent.class);
            }
            catch (IOException e) {
                throw new StoreException("Failed to read preferences from store", e);
            }
            ModelVersion storedVersion = ModelVersion.fromString(storeContent.getVersion());
            ModelVersion currentVersion = new ModelVersion(9, 1);
            if (currentVersion.lessThan(storedVersion)) {
                throw new IllegalStateException(String.format("Cannot downgrade preference store storedVersion from '%s' to '%s'", currentVersion.toString(), "9.1"));
            }
            Collection<PreferenceRecord> records = Arrays.asList(storeContent.getPreferences());
            if (storedVersion.lessThan(currentVersion)) {
                records = updater.updatePreferences(storedVersion.toString(), records);
                storeContent.setVersion("9.1");
                storeContent.setPreferences(records.toArray(new StoredPreferenceRecord[records.size()]));
                this.save(storeContent);
            }
            for (StoredPreferenceRecord preferenceRecord : storeContent.getPreferences()) {
                this._recordMap.put(preferenceRecord.getId(), preferenceRecord);
            }
            this._storeState = StoreState.OPENED;
            return records;
        }
        catch (Exception e) {
            this._storeState = StoreState.ERRORED;
            this.close();
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this._storeState != StoreState.CLOSED) {
            this.cleanup();
            this._recordMap.clear();
            this._storeState = StoreState.CLOSED;
        }
    }

    @Override
    public synchronized void updateOrCreate(Collection<PreferenceRecord> preferenceRecords) {
        if (this._storeState != StoreState.OPENED) {
            throw new IllegalStateException("PreferenceStore is not opened");
        }
        if (preferenceRecords.isEmpty()) {
            return;
        }
        this.updateOrCreateInternal(preferenceRecords);
    }

    @Override
    public synchronized void replace(Collection<UUID> preferenceRecordsToRemove, Collection<PreferenceRecord> preferenceRecordsToAdd) {
        if (this._storeState != StoreState.OPENED) {
            throw new IllegalStateException("PreferenceStore is not opened");
        }
        if (preferenceRecordsToRemove.isEmpty() && preferenceRecordsToAdd.isEmpty()) {
            return;
        }
        this._recordMap.keySet().removeAll(preferenceRecordsToRemove);
        this.updateOrCreateInternal(preferenceRecordsToAdd);
    }

    @Override
    public synchronized void onDelete() {
        this.close();
        this.delete(this._storePath);
    }

    @Override
    protected ObjectMapper getSerialisationObjectMapper() {
        return this._objectMapper;
    }

    private void updateOrCreateInternal(Collection<PreferenceRecord> preferenceRecords) {
        for (PreferenceRecord preferenceRecord : preferenceRecords) {
            this._recordMap.put(preferenceRecord.getId(), new StoredPreferenceRecord(preferenceRecord));
        }
        Collection<StoredPreferenceRecord> values = this._recordMap.values();
        StoreContent newContent = new StoreContent("9.1", values.toArray(new StoredPreferenceRecord[values.size()]));
        this.save(newContent);
    }

    private static enum StoreState {
        CLOSED,
        OPENED,
        ERRORED;

    }

    private static class StoreContent {
        private String _version;
        private StoredPreferenceRecord[] _preferences = new StoredPreferenceRecord[0];

        public StoreContent() {
        }

        public StoreContent(String modelVersion, StoredPreferenceRecord[] storedPreferenceRecords) {
            this._version = modelVersion;
            this._preferences = storedPreferenceRecords;
        }

        public String getVersion() {
            return this._version;
        }

        public void setVersion(String version) {
            this._version = version;
        }

        public StoredPreferenceRecord[] getPreferences() {
            return this._preferences;
        }

        public void setPreferences(StoredPreferenceRecord[] preferences) {
            this._preferences = preferences == null ? new StoredPreferenceRecord[]{} : preferences;
        }
    }

    private static class StoredPreferenceRecord
    implements PreferenceRecord {
        private UUID _id;
        private Map<String, Object> _attributes;

        public StoredPreferenceRecord() {
        }

        public StoredPreferenceRecord(PreferenceRecord preferenceRecord) {
            this._id = preferenceRecord.getId();
            this._attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(preferenceRecord.getAttributes()));
        }

        @Override
        public UUID getId() {
            return this._id;
        }

        public void setId(UUID id) {
            this._id = id;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this._attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this._attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
        }
    }
}

