/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import java.io.Closeable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class StoredIterator<E>
extends BaseIterator<E>
implements ListIterator<E>,
Cloneable,
Closeable {
    private static final int MOVE_NEXT = 1;
    private static final int MOVE_PREV = 2;
    private static final int MOVE_FIRST = 3;
    private boolean lockForWrite;
    private StoredCollection<E> coll;
    private DataCursor cursor;
    private int toNext;
    private int toPrevious;
    private int toCurrent;
    private boolean writeAllowed;
    private boolean setAndRemoveAllowed;
    private E currentData;

    public static void close(Iterator<?> i) {
        if (i instanceof StoredIterator) {
            ((StoredIterator)i).close();
        }
    }

    StoredIterator(StoredCollection<E> coll, boolean writeAllowed, DataCursor joinCursor) {
        try {
            this.coll = coll;
            this.writeAllowed = writeAllowed;
            this.cursor = joinCursor == null ? new DataCursor(coll.view, writeAllowed) : joinCursor;
            this.reset();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw StoredContainer.convertException(e);
        }
    }

    public final boolean isReadModifyWrite() {
        return this.lockForWrite;
    }

    public void setReadModifyWrite(boolean lockForWrite) {
        this.lockForWrite = lockForWrite;
    }

    @Override
    public boolean hasNext() {
        if (this.cursor == null) {
            return false;
        }
        try {
            OperationStatus status;
            if (this.toNext != 0 && (status = this.move(this.toNext)) == OperationStatus.SUCCESS) {
                this.toNext = 0;
                this.toPrevious = 2;
                this.toCurrent = 2;
            }
            return this.toNext == 0;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.cursor == null) {
            return false;
        }
        try {
            OperationStatus status;
            if (this.toPrevious != 0 && (status = this.move(this.toPrevious)) == OperationStatus.SUCCESS) {
                this.toPrevious = 0;
                this.toNext = 1;
                this.toCurrent = 1;
            }
            return this.toPrevious == 0;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public E next() {
        try {
            OperationStatus status;
            if (this.toNext != 0 && (status = this.move(this.toNext)) == OperationStatus.SUCCESS) {
                this.toNext = 0;
            }
            if (this.toNext == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toNext = 1;
                this.toPrevious = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
        throw new NoSuchElementException();
    }

    @Override
    public E previous() {
        try {
            OperationStatus status;
            if (this.toPrevious != 0 && (status = this.move(this.toPrevious)) == OperationStatus.SUCCESS) {
                this.toPrevious = 0;
            }
            if (this.toPrevious == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toPrevious = 2;
                this.toNext = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasNext() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : Integer.MAX_VALUE;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public int previousIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasPrevious() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : -1;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public void set(E value) {
        if (!this.coll.hasValues()) {
            throw new UnsupportedOperationException();
        }
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.putCurrent(value);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public void remove() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.delete();
            this.setAndRemoveAllowed = false;
            this.toNext = 1;
            this.toPrevious = 2;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(E value) {
        this.coll.checkIterAddAllowed();
        try {
            OperationStatus status = OperationStatus.SUCCESS;
            if (this.toNext != 0 && this.toPrevious != 0) {
                if (!this.coll.view.keysRenumbered) throw new IllegalStateException("Collection is empty, cannot add() duplicate");
                this.close();
                status = this.coll.view.append(value, null, null);
                this.cursor = new DataCursor(this.coll.view, this.writeAllowed);
                this.reset();
                this.next();
            } else {
                boolean putBefore = false;
                if (this.coll.view.keysRenumbered) {
                    this.moveToCurrent();
                    if (this.hasNext()) {
                        status = this.cursor.putBefore(value);
                        putBefore = true;
                    } else {
                        status = this.cursor.putAfter(value);
                    }
                } else if (this.coll.areDuplicatesOrdered()) {
                    status = this.cursor.putNoDupData(null, value, null, true);
                } else if (this.toNext == 0) {
                    status = this.cursor.putBefore(value);
                    putBefore = true;
                } else {
                    status = this.cursor.putAfter(value);
                }
                if (putBefore) {
                    this.toPrevious = 0;
                    this.toNext = 1;
                }
            }
            if (status == OperationStatus.KEYEXIST) {
                throw new IllegalArgumentException("Duplicate value");
            }
            if (status != OperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("Could not insert: " + (Object)((Object)status));
            }
            this.setAndRemoveAllowed = false;
            return;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    private void reset() {
        this.toNext = 3;
        this.toPrevious = 2;
        this.toCurrent = 0;
        this.currentData = null;
        this.hasNext();
    }

    public int count() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            return this.cursor.count();
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.coll.closeCursor(this.cursor);
            this.cursor = null;
        }
    }

    public final StoredCollection<E> getCollection() {
        return this.coll;
    }

    @Override
    final ListIterator<E> dup() {
        try {
            StoredIterator o = (StoredIterator)super.clone();
            o.cursor = this.cursor.cloneCursor();
            return o;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    final boolean isCurrentData(Object currentData) {
        return this.currentData == currentData;
    }

    @Override
    final boolean moveToIndex(int index) {
        try {
            OperationStatus status = this.cursor.getSearchKey(index, null, this.lockForWrite);
            this.setAndRemoveAllowed = status == OperationStatus.SUCCESS;
            return this.setAndRemoveAllowed;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    private void moveToCurrent() throws DatabaseException {
        if (this.toCurrent != 0) {
            this.move(this.toCurrent);
            this.toCurrent = 0;
        }
    }

    private OperationStatus move(int direction) throws DatabaseException {
        switch (direction) {
            case 1: {
                if (this.coll.iterateDuplicates()) {
                    return this.cursor.getNext(this.lockForWrite);
                }
                return this.cursor.getNextNoDup(this.lockForWrite);
            }
            case 2: {
                if (this.coll.iterateDuplicates()) {
                    return this.cursor.getPrev(this.lockForWrite);
                }
                return this.cursor.getPrevNoDup(this.lockForWrite);
            }
            case 3: {
                return this.cursor.getFirst(this.lockForWrite);
            }
        }
        throw DbCompat.unexpectedState(String.valueOf(direction));
    }
}

