/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import com.github.benmanes.caffeine.cache.Cache;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.virtualhost.CacheFactory;
import org.apache.qpid.server.virtualhost.NullCache;

public class StringTypeConstructor
extends VariableWidthTypeConstructor<String> {
    private static final NullCache<ByteBuffer, String> NULL_CACHE = new NullCache();
    private static final ThreadLocal<Cache<ByteBuffer, String>> CACHE = ThreadLocal.withInitial(() -> CacheFactory.getCache((String)"stringCache", NULL_CACHE));

    public static StringTypeConstructor getInstance(int i) {
        return new StringTypeConstructor(i);
    }

    private StringTypeConstructor(int size) {
        super(size);
    }

    @Override
    public String construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (!in.hasRemaining(this.getSize())) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct string: insufficient input data", new Object[0]);
        }
        int size = this.getSize() == 1 ? in.getUnsignedByte() : in.getInt();
        if (!in.hasRemaining(size)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct string: insufficient input data", new Object[0]);
        }
        byte[] data = new byte[size];
        in.get(data);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        String cached = (String)StringTypeConstructor.getCache().getIfPresent((Object)buffer);
        if (cached == null) {
            cached = new String(data, StandardCharsets.UTF_8);
            StringTypeConstructor.getCache().put((Object)buffer, (Object)cached);
        }
        return cached;
    }

    static Cache<ByteBuffer, String> getCache() {
        return CACHE.get();
    }

    static void setCache(Cache<ByteBuffer, String> cache) {
        CACHE.set(cache);
    }
}

