/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.AsNamed;
import org.apache.jena.ontapi.model.HasCardinality;
import org.apache.jena.ontapi.model.HasDisjoint;
import org.apache.jena.ontapi.model.HasProperties;
import org.apache.jena.ontapi.model.HasProperty;
import org.apache.jena.ontapi.model.HasRDFNodeList;
import org.apache.jena.ontapi.model.HasValue;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntList;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.model.RDFNodeList;
import org.apache.jena.ontapi.model.SetCardinality;
import org.apache.jena.ontapi.model.SetComponents;
import org.apache.jena.ontapi.model.SetProperties;
import org.apache.jena.ontapi.model.SetProperty;
import org.apache.jena.ontapi.model.SetValue;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public interface OntClass
extends OntObject,
AsNamed<Named>,
HasDisjoint<OntClass> {
    public Stream<OntClass> subClasses(boolean var1);

    public Stream<OntClass> superClasses(boolean var1);

    public Stream<OntIndividual> individuals(boolean var1);

    public boolean hasDeclaredProperty(OntProperty var1, boolean var2);

    public Stream<OntProperty> declaredProperties(boolean var1);

    public boolean isHierarchyRoot();

    public Stream<OntList<OntRelationalProperty>> hasKeys();

    public OntIndividual.Anonymous createIndividual();

    public OntIndividual.Named createIndividual(String var1);

    public OntList<OntRelationalProperty> createHasKey(Collection<OntObjectProperty> var1, Collection<OntDataProperty> var2);

    public OntStatement addHasKeyStatement(OntRelationalProperty ... var1);

    public OntClass removeHasKey(Resource var1);

    public boolean isDisjoint(Resource var1);

    public Stream<OntClass> disjointClasses();

    public Stream<OntClass> equivalentClasses();

    @Override
    default public Named asNamed() {
        return (Named)this.as(Named.class);
    }

    default public Stream<OntIndividual> individuals() {
        return this.individuals(false);
    }

    default public Stream<OntProperty> properties() {
        return this.getModel().statements(null, RDFS.domain, (RDFNode)this).map(s -> s.getSubject().getAs(OntProperty.class)).filter(Objects::nonNull);
    }

    default public Stream<OntProperty> declaredProperties() {
        return this.declaredProperties(false);
    }

    default public Stream<OntClass> subClasses() {
        return this.subClasses(false);
    }

    default public Optional<OntClass> subClass() {
        if (!this.canAsSuperClass()) {
            return Optional.empty();
        }
        try (Stream<OntClass> classes = this.getModel().statements(null, RDFS.subClassOf, (RDFNode)this).map(OntStatement::getSubject).filter(it -> it.canAs(OntClass.class)).map(it -> (OntClass)it.as(OntClass.class)).filter(OntClass::canAsSubClass).map(OntClass::asSubClass);){
            Optional<OntClass> optional = classes.findFirst();
            return optional;
        }
    }

    default public Stream<OntClass> superClasses() {
        return this.superClasses(false);
    }

    default public Optional<OntClass> superClass() {
        if (!this.canAsSubClass()) {
            return Optional.empty();
        }
        try (Stream<OntClass> classes = this.statements(RDFS.subClassOf).map(OntStatement::getSubject).filter(it -> it.canAs(OntClass.class)).map(it -> (OntClass)it.as(OntClass.class)).filter(OntClass::canAsSuperClass).map(OntClass::asSuperClass);){
            Optional<OntClass> optional = classes.findFirst();
            return optional;
        }
    }

    default public boolean hasSubClass(OntClass clazz, boolean direct) {
        return clazz.hasSuperClass(this, direct);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean hasSuperClass(OntClass clazz, boolean direct) {
        if (this.equals(clazz)) return true;
        if (!this.canAsSubClass()) return false;
        if (!clazz.canAsSuperClass()) return false;
        if (!this.superClasses(direct).anyMatch(arg_0 -> ((OntClass)clazz).equals(arg_0))) return false;
        return true;
    }

    @Override
    default public Stream<OntDisjoint.Classes> disjoints() {
        return this.getModel().ontObjects(OntDisjoint.Classes.class).filter(d -> d.members().anyMatch(arg_0 -> ((OntClass)this).equals(arg_0)));
    }

    default public OntStatement addSubClassOfStatement(OntClass other) {
        return this.addStatement(RDFS.subClassOf, (RDFNode)other);
    }

    default public OntStatement addDisjointWithStatement(OntClass other) {
        return this.addStatement(OWL2.disjointWith, (RDFNode)other);
    }

    default public OntStatement addEquivalentClassStatement(OntClass other) {
        return this.addStatement(OWL2.equivalentClass, (RDFNode)other);
    }

    default public OntStatement addHasKeyStatement(Collection<OntObjectProperty> objectProperties, Collection<OntDataProperty> dataProperties) {
        return this.createHasKey(objectProperties, dataProperties).getMainStatement();
    }

    default public OntClass addSuperClass(OntClass other) {
        OntJenaException.checkSupported(this.canAsSubClass() && other.canAsSuperClass());
        this.addSubClassOfStatement(other);
        return this;
    }

    default public OntClass addSubClass(OntClass other) {
        OntJenaException.checkSupported(other.canAsSubClass() && this.canAsSuperClass());
        other.addSuperClass(this);
        return this;
    }

    default public OntClass addDisjointClass(OntClass other) {
        OntJenaException.checkSupported(this.canAsDisjointClass() && other.canAsDisjointClass());
        this.addDisjointWithStatement(other);
        return this;
    }

    default public OntClass addEquivalentClass(OntClass other) {
        OntJenaException.checkSupported(this.canAsEquivalentClass() && other.canAsEquivalentClass());
        this.addEquivalentClassStatement(other);
        return this;
    }

    default public OntClass addHasKey(Collection<OntObjectProperty> objectProperties, Collection<OntDataProperty> dataProperties) {
        this.addHasKeyStatement(objectProperties, dataProperties);
        return this;
    }

    default public OntClass addHasKey(OntRelationalProperty ... properties) {
        this.addHasKeyStatement(properties);
        return this;
    }

    default public OntClass removeIndividual(Resource individual) {
        this.getModel().remove(individual, RDF.type, (RDFNode)this);
        return this;
    }

    default public OntClass removeSuperClass(Resource other) {
        this.remove(RDFS.subClassOf, (RDFNode)other);
        return this;
    }

    default public OntClass removeSubClass(Resource other) {
        this.getModel().statements(other, RDFS.subClassOf, (RDFNode)this).toList().forEach(s -> this.getModel().remove(s.clearAnnotations()));
        return this;
    }

    default public OntClass removeDisjointClass(Resource other) {
        this.remove(OWL2.disjointWith, (RDFNode)other);
        return this;
    }

    default public OntClass removeEquivalentClass(Resource other) {
        this.remove(OWL2.equivalentClass, (RDFNode)other);
        return this;
    }

    default public OntClass clearHasKeys() {
        this.hasKeys().toList().forEach(this::removeHasKey);
        return this;
    }

    default public Optional<OntList<OntRelationalProperty>> findHasKey(RDFNode list) {
        try (Stream<OntList> res = this.hasKeys().filter(r -> Objects.equals(r, list));){
            Optional<OntList<OntRelationalProperty>> optional = res.findFirst();
            return optional;
        }
    }

    default public Stream<OntRelationalProperty> fromHasKey() {
        return this.hasKeys().flatMap(RDFNodeList::members).distinct();
    }

    default public OntClass asSubClass() {
        return this;
    }

    default public boolean canAsSubClass() {
        return true;
    }

    default public OntClass asSuperClass() {
        return this;
    }

    default public boolean canAsSuperClass() {
        return true;
    }

    default public OntClass asAssertionClass() {
        return this;
    }

    default public boolean canAsAssertionClass() {
        return true;
    }

    default public OntClass asEquivalentClass() {
        return this;
    }

    default public boolean canAsEquivalentClass() {
        return true;
    }

    default public OntClass asDisjointClass() {
        return this;
    }

    default public boolean canAsDisjointClass() {
        return true;
    }

    public static interface Named
    extends OntEntity,
    OntClass {
        public Stream<OntList<OntClass>> disjointUnions();

        public OntList<OntClass> createDisjointUnion(Collection<OntClass> var1);

        public Named removeDisjointUnion(Resource var1);

        default public Optional<OntList<OntClass>> findDisjointUnion(RDFNode list) {
            try (Stream<OntList> res = this.disjointUnions().filter(r -> Objects.equals(r, list));){
                Optional<OntList<OntClass>> optional = res.findFirst();
                return optional;
            }
        }

        default public OntStatement addDisjointUnionOfStatement(OntClass ... classes) {
            return this.addDisjointUnionOfStatement(Arrays.stream(classes).collect(Collectors.toCollection(LinkedHashSet::new)));
        }

        default public OntStatement addDisjointUnionOfStatement(Collection<OntClass> classes) {
            return this.createDisjointUnion(classes).getMainStatement();
        }

        @Override
        default public Named addSuperClass(OntClass other) {
            OntClass.super.addSuperClass(other);
            return this;
        }

        @Override
        default public Named addSubClass(OntClass other) {
            OntClass.super.addSubClass(other);
            return this;
        }

        @Override
        default public Named addEquivalentClass(OntClass other) {
            OntClass.super.addEquivalentClass(other);
            return this;
        }

        @Override
        default public Named addHasKey(Collection<OntObjectProperty> objectProperties, Collection<OntDataProperty> dataProperties) {
            this.addHasKeyStatement(objectProperties, dataProperties);
            return this;
        }

        @Override
        default public Named addHasKey(OntRelationalProperty ... properties) {
            this.addHasKeyStatement(properties);
            return this;
        }

        default public Named addDisjointUnion(Collection<OntClass> classes) {
            this.addDisjointUnionOfStatement(classes);
            return this;
        }

        default public Named addDisjointUnion(OntClass ... classes) {
            this.addDisjointUnionOfStatement(classes);
            return this;
        }

        @Override
        default public Named addDisjointClass(OntClass other) {
            OntClass.super.addDisjointClass(other);
            return this;
        }

        @Override
        default public Named removeSuperClass(Resource other) {
            OntClass.super.removeSuperClass(other);
            return this;
        }

        @Override
        default public Named removeDisjointClass(Resource other) {
            OntClass.super.removeDisjointClass(other);
            return this;
        }

        @Override
        default public Named removeEquivalentClass(Resource other) {
            OntClass.super.removeEquivalentClass(other);
            return this;
        }

        @Override
        default public Named clearHasKeys() {
            OntClass.super.clearHasKeys();
            return this;
        }

        default public Named clearDisjointUnions() {
            this.disjointUnions().collect(Collectors.toSet()).forEach(this::removeDisjointUnion);
            return this;
        }

        default public Stream<OntClass> fromDisjointUnionOf() {
            return this.disjointUnions().flatMap(RDFNodeList::members).distinct();
        }

        @Override
        default public Named addComment(String txt) {
            return this.addComment(txt, null);
        }

        @Override
        default public Named addComment(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSComment(), txt, lang);
        }

        @Override
        default public Named addLabel(String txt) {
            return this.addLabel(txt, null);
        }

        @Override
        default public Named addLabel(String txt, String lang) {
            return this.annotate(this.getModel().getRDFSLabel(), txt, lang);
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, String txt, String lang) {
            return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
        }

        @Override
        default public Named annotate(OntAnnotationProperty predicate, RDFNode value) {
            this.addAnnotation(predicate, value);
            return this;
        }
    }

    public static interface LogicalExpression
    extends OntClass {
    }

    public static interface CollectionOf<O extends OntObject>
    extends OntClass,
    HasRDFNodeList<O> {
        default public Stream<O> components() {
            return this.getList().members();
        }
    }

    public static interface Restriction
    extends OntClass {
    }

    public static interface UnaryRestriction<P extends OntRelationalProperty>
    extends Restriction,
    HasProperty<P> {
    }

    public static interface NaryRestriction<O extends OntObject, P extends OntRelationalProperty>
    extends Restriction,
    HasProperties<P>,
    HasValue<O> {
    }

    public static interface ComponentRestriction<O extends RDFNode, P extends OntRelationalProperty>
    extends UnaryRestriction<P>,
    HasValue<O> {
    }

    public static interface CardinalityRestriction<O extends OntObject, P extends OntRelationalProperty>
    extends HasCardinality,
    ComponentRestriction<O, P> {
    }

    public static interface ValueRestriction<O extends RDFNode, P extends OntRelationalProperty>
    extends ComponentRestriction<O, P> {
    }

    public static interface NaryDataSomeValuesFrom
    extends NaryRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, NaryDataSomeValuesFrom>,
    SetProperties<OntDataProperty, NaryDataSomeValuesFrom> {
    }

    public static interface NaryDataAllValuesFrom
    extends NaryRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, NaryDataAllValuesFrom>,
    SetProperties<OntDataProperty, NaryDataAllValuesFrom> {
    }

    public static interface ComplementOf
    extends LogicalExpression,
    HasValue<OntClass>,
    SetValue<OntClass, ComplementOf> {
    }

    public static interface IntersectionOf
    extends LogicalExpression,
    CollectionOf<OntClass>,
    SetComponents<OntClass, IntersectionOf> {
    }

    public static interface OneOf
    extends LogicalExpression,
    CollectionOf<OntIndividual>,
    SetComponents<OntIndividual, OneOf> {
    }

    public static interface UnionOf
    extends LogicalExpression,
    CollectionOf<OntClass>,
    SetComponents<OntClass, UnionOf> {
    }

    public static interface HasSelf
    extends UnaryRestriction<OntObjectProperty>,
    SetProperty<OntObjectProperty, HasSelf> {
    }

    public static interface DataCardinality
    extends CardinalityRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataCardinality>,
    SetProperty<OntDataProperty, DataCardinality>,
    SetCardinality<DataCardinality> {
    }

    public static interface ObjectCardinality
    extends CardinalityRestriction<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectCardinality>,
    SetProperty<OntObjectProperty, ObjectCardinality>,
    SetCardinality<ObjectCardinality> {
    }

    public static interface DataMaxCardinality
    extends CardinalityRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataMaxCardinality>,
    SetProperty<OntDataProperty, DataMaxCardinality>,
    SetCardinality<DataMaxCardinality> {
    }

    public static interface ObjectMaxCardinality
    extends CardinalityRestriction<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectMaxCardinality>,
    SetProperty<OntObjectProperty, ObjectMaxCardinality>,
    SetCardinality<ObjectMaxCardinality> {
    }

    public static interface DataMinCardinality
    extends CardinalityRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataMinCardinality>,
    SetProperty<OntDataProperty, DataMinCardinality>,
    SetCardinality<DataMinCardinality> {
    }

    public static interface ObjectMinCardinality
    extends CardinalityRestriction<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectMinCardinality>,
    SetProperty<OntObjectProperty, ObjectMinCardinality>,
    SetCardinality<ObjectMinCardinality> {
    }

    public static interface DataHasValue
    extends ValueRestriction<Literal, OntDataProperty>,
    SetValue<Literal, DataHasValue>,
    SetProperty<OntDataProperty, DataHasValue> {
    }

    public static interface ObjectHasValue
    extends ValueRestriction<OntIndividual, OntObjectProperty>,
    SetValue<OntIndividual, ObjectHasValue>,
    SetProperty<OntObjectProperty, ObjectHasValue> {
    }

    public static interface DataAllValuesFrom
    extends ValueRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataAllValuesFrom>,
    SetProperty<OntDataProperty, DataAllValuesFrom> {
    }

    public static interface ObjectAllValuesFrom
    extends ValueRestriction<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectAllValuesFrom>,
    SetProperty<OntObjectProperty, ObjectAllValuesFrom> {
    }

    public static interface DataSomeValuesFrom
    extends ValueRestriction<OntDataRange, OntDataProperty>,
    SetValue<OntDataRange, DataSomeValuesFrom>,
    SetProperty<OntDataProperty, DataSomeValuesFrom> {
    }

    public static interface ObjectSomeValuesFrom
    extends ValueRestriction<OntClass, OntObjectProperty>,
    SetValue<OntClass, ObjectSomeValuesFrom>,
    SetProperty<OntObjectProperty, ObjectSomeValuesFrom> {
    }
}

