/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.row;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class ExpandableByteBuf {
    private byte[] arr;
    private ByteBuffer buf;
    private int len;

    public ExpandableByteBuf(int size) {
        if (size <= 0) {
            size = 32;
        }
        this.arr = new byte[size];
        this.buf = ByteBuffer.wrap(this.arr);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void put(int off, byte val) {
        this.ensureCapacity(off + 1);
        this.buf.put(off, val);
    }

    public void putShort(int off, short val) {
        this.ensureCapacity(off + 2);
        this.buf.putShort(off, val);
    }

    public void putInt(int off, int val) {
        this.ensureCapacity(off + 4);
        this.buf.putInt(off, val);
    }

    public void putFloat(int off, float val) {
        this.ensureCapacity(off + 4);
        this.buf.putFloat(off, val);
    }

    public void putLong(int off, long val) {
        this.ensureCapacity(off + 8);
        this.buf.putLong(off, val);
    }

    public void putDouble(int off, double val) {
        this.ensureCapacity(off + 8);
        this.buf.putDouble(off, val);
    }

    public void putBytes(int off, byte[] val) {
        this.ensureCapacity(off + val.length);
        this.buf.position(off);
        try {
            this.buf.put(val);
        }
        finally {
            this.buf.position(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putString(int off, String val, CharsetEncoder encoder) throws CharacterCodingException {
        this.ensureCapacity(off);
        if (val.isEmpty()) {
            return 0;
        }
        this.buf.position(off);
        encoder.reset();
        try {
            CharBuffer valBuf = CharBuffer.wrap(val);
            while (true) {
                CoderResult cr;
                CoderResult coderResult = cr = valBuf.hasRemaining() ? encoder.encode(valBuf, this.buf, true) : CoderResult.UNDERFLOW;
                if (cr.isUnderflow()) {
                    cr = encoder.flush(this.buf);
                }
                this.len = this.buf.position();
                if (cr.isUnderflow()) break;
                if (cr.isOverflow()) {
                    this.expand(this.len + (int)encoder.maxBytesPerChar());
                    continue;
                }
                if (!cr.isError()) continue;
                cr.throwException();
            }
            int n = this.len - off;
            return n;
        }
        finally {
            this.buf.position(0);
        }
    }

    public byte get(int off) {
        return this.buf.get(off);
    }

    public short getShort(int off) {
        return this.buf.getShort(off);
    }

    public byte[] toArray() {
        if (this.arr.length == this.len) {
            return this.arr;
        }
        return Arrays.copyOf(this.arr, this.len);
    }

    void ensureCapacity(int cap) {
        if (this.arr.length < cap) {
            this.expand(cap);
        }
        if (cap > this.len) {
            this.len = cap;
        }
    }

    private void expand(int cap) {
        int l = this.arr.length;
        while (l < cap) {
            if (l < 0x100000) {
                l *= 2;
                continue;
            }
            l += 0x100000;
        }
        byte[] tmp = new byte[l];
        System.arraycopy(this.arr, 0, tmp, 0, this.arr.length);
        this.arr = tmp;
        int oldPos = this.buf.position();
        this.buf = ByteBuffer.wrap(this.arr);
        this.buf.position(oldPos);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    void shift(int srcOff, int dstOff) {
        assert (srcOff > dstOff);
        int shift = srcOff - dstOff;
        System.arraycopy(this.arr, srcOff, this.arr, dstOff, this.len - srcOff);
        Arrays.fill(this.arr, this.len - shift, this.len, (byte)0);
        this.len -= shift;
        this.buf = ByteBuffer.wrap(this.arr);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer unwrap() {
        return this.buf.duplicate().limit(this.len).order(ByteOrder.LITTLE_ENDIAN);
    }
}

