/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.client.handler.requests.sql.ClientSqlResultSet;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ClientSqlColumnTypeConverter;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.Session;
import org.apache.ignite.sql.SqlColumnType;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.tx.Transaction;

public class ClientSqlExecuteRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteSql sql, ClientResourceRegistry resources) {
        Transaction tx = ClientTableCommon.readTx(in, resources);
        Session session = ClientSqlExecuteRequest.readSession(in, sql);
        Statement statement = ClientSqlExecuteRequest.readStatement(in, sql);
        Object[] arguments = in.unpackObjectArrayFromBinaryTuple();
        return session.executeAsync(tx, statement, arguments).thenCompose(asyncResultSet -> ClientSqlExecuteRequest.writeResultSetAsync(out, resources, asyncResultSet, session));
    }

    private static CompletionStage<Void> writeResultSetAsync(ClientMessagePacker out, ClientResourceRegistry resources, AsyncResultSet asyncResultSet, Session session) {
        boolean hasResource;
        boolean bl = hasResource = asyncResultSet.hasRowSet() && asyncResultSet.hasMorePages();
        if (hasResource) {
            try {
                ClientSqlResultSet clientResultSet = new ClientSqlResultSet(asyncResultSet, session);
                ClientResource resource = new ClientResource(clientResultSet, () -> clientResultSet.closeAsync().join());
                out.packLong(resources.put(resource));
            }
            catch (IgniteInternalCheckedException e) {
                return asyncResultSet.closeAsync().thenRun(() -> {
                    throw new IgniteInternalException(e.getMessage(), (Throwable)e);
                });
            }
        } else {
            out.packNil();
        }
        out.packBoolean(asyncResultSet.hasRowSet());
        out.packBoolean(asyncResultSet.hasMorePages());
        out.packBoolean(asyncResultSet.wasApplied());
        out.packLong(asyncResultSet.affectedRows());
        ClientSqlExecuteRequest.packMeta(out, asyncResultSet.metadata());
        if (asyncResultSet.hasRowSet()) {
            ClientSqlCommon.packCurrentPage(out, asyncResultSet);
            return hasResource ? CompletableFuture.completedFuture(null) : asyncResultSet.closeAsync().thenCompose(res -> session.closeAsync());
        }
        return asyncResultSet.closeAsync().thenCompose(res -> session.closeAsync());
    }

    private static Statement readStatement(ClientMessageUnpacker in, IgniteSql sql) {
        Statement.StatementBuilder statementBuilder = sql.statementBuilder();
        statementBuilder.query(in.unpackString());
        return statementBuilder.build();
    }

    private static Session readSession(ClientMessageUnpacker in, IgniteSql sql) {
        Session.SessionBuilder sessionBuilder = sql.sessionBuilder();
        if (!in.tryUnpackNil()) {
            sessionBuilder.defaultSchema(in.unpackString());
        }
        if (!in.tryUnpackNil()) {
            sessionBuilder.defaultPageSize(in.unpackInt());
        }
        if (!in.tryUnpackNil()) {
            sessionBuilder.defaultQueryTimeout(in.unpackLong(), TimeUnit.MILLISECONDS);
        }
        if (!in.tryUnpackNil()) {
            sessionBuilder.idleTimeout(in.unpackLong(), TimeUnit.MILLISECONDS);
        }
        int propCount = in.unpackInt();
        BinaryTupleReader reader = new BinaryTupleReader(propCount * 4, in.readBinaryUnsafe());
        for (int i = 0; i < propCount; ++i) {
            sessionBuilder.property(reader.stringValue(i * 4), ClientBinaryTupleUtils.readObject((BinaryTupleReader)reader, (int)(i * 4 + 1)));
        }
        return sessionBuilder.build();
    }

    private static void packMeta(ClientMessagePacker out, ResultSetMetadata meta) {
        if (meta == null || meta.columns() == null) {
            out.packArrayHeader(0);
            return;
        }
        List cols = meta.columns();
        out.packArrayHeader(cols.size());
        HashMap<String, Integer> schemas = new HashMap<String, Integer>();
        HashMap<String, Integer> tables = new HashMap<String, Integer>();
        for (int i = 0; i < cols.size(); ++i) {
            ColumnMetadata col = (ColumnMetadata)cols.get(i);
            out.packString(col.name());
            out.packBoolean(col.nullable());
            out.packInt(ClientSqlColumnTypeConverter.columnTypeToOrdinal((SqlColumnType)col.type()));
            out.packInt(col.scale());
            out.packInt(col.precision());
            ColumnMetadata.ColumnOrigin origin = col.origin();
            if (origin == null) {
                out.packBoolean(false);
                continue;
            }
            out.packBoolean(true);
            if (col.name().equals(origin.columnName())) {
                out.packNil();
            } else {
                out.packString(origin.columnName());
            }
            Integer schemaIdx = (Integer)schemas.get(origin.schemaName());
            if (schemaIdx == null) {
                schemas.put(origin.schemaName(), i);
                out.packString(origin.schemaName());
            } else {
                out.packInt(schemaIdx.intValue());
            }
            Integer tableIdx = (Integer)tables.get(origin.tableName());
            if (tableIdx == null) {
                tables.put(origin.tableName(), i);
                out.packString(origin.tableName());
                continue;
            }
            out.packInt(tableIdx.intValue());
        }
    }
}

