/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.observation.ObservationRegistry;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.cache.CachingHttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.cache.CachingHttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.client5.http.observation.binder.ConnPoolMeters;
import org.apache.hc.client5.http.observation.binder.ConnPoolMetersAsync;
import org.apache.hc.client5.http.observation.impl.ObservationAsyncExecInterceptor;
import org.apache.hc.client5.http.observation.impl.ObservationClassicExecInterceptor;
import org.apache.hc.client5.http.observation.interceptors.AsyncIoByteCounterExec;
import org.apache.hc.client5.http.observation.interceptors.AsyncTimerExec;
import org.apache.hc.client5.http.observation.interceptors.IoByteCounterExec;
import org.apache.hc.client5.http.observation.interceptors.TimerExec;
import org.apache.hc.core5.util.Args;

public final class HttpClientObservationSupport {
    private static final String OBS_ID = "observation";
    private static final String TIMER_ID = "metric-timer";
    private static final String IO_ID = "metric-io";

    public static void enable(HttpClientBuilder builder, ObservationRegistry obsReg) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, ObservingOptions.DEFAULT, MetricConfig.DEFAULT);
    }

    public static void enable(HttpClientBuilder builder, ObservationRegistry obsReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, opts, MetricConfig.DEFAULT);
    }

    public static void enable(HttpClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, meterReg, opts, MetricConfig.DEFAULT);
    }

    public static void enable(HttpClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts, MetricConfig mc) {
        MetricConfig config;
        Args.notNull((Object)builder, (String)"builder");
        Args.notNull((Object)meterReg, (String)"meterRegistry");
        ObservingOptions o = opts != null ? opts : ObservingOptions.DEFAULT;
        MetricConfig metricConfig = config = mc != null ? mc : MetricConfig.DEFAULT;
        if (obsReg != null) {
            builder.addExecInterceptorFirst(OBS_ID, (ExecChainHandler)new ObservationClassicExecInterceptor(obsReg, opts));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.BASIC)) {
            builder.addExecInterceptorFirst(TIMER_ID, (ExecChainHandler)new TimerExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.IO)) {
            builder.addExecInterceptorFirst(IO_ID, (ExecChainHandler)new IoByteCounterExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.CONN_POOL)) {
            ConnPoolMeters.bindTo(builder, meterReg, config);
        }
    }

    public static void enable(CachingHttpClientBuilder builder, ObservationRegistry obsReg) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, ObservingOptions.DEFAULT, MetricConfig.DEFAULT);
    }

    public static void enable(CachingHttpClientBuilder builder, ObservationRegistry obsReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, opts, MetricConfig.DEFAULT);
    }

    public static void enable(CachingHttpClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, meterReg, opts, MetricConfig.DEFAULT);
    }

    public static void enable(CachingHttpClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts, MetricConfig mc) {
        MetricConfig config;
        Args.notNull((Object)builder, (String)"builder");
        Args.notNull((Object)meterReg, (String)"meterRegistry");
        ObservingOptions o = opts != null ? opts : ObservingOptions.DEFAULT;
        MetricConfig metricConfig = config = mc != null ? mc : MetricConfig.DEFAULT;
        if (obsReg != null) {
            builder.addExecInterceptorAfter(ChainElement.CACHING.name(), OBS_ID, (ExecChainHandler)new ObservationClassicExecInterceptor(obsReg, opts));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.BASIC)) {
            builder.addExecInterceptorAfter(ChainElement.CACHING.name(), TIMER_ID, (ExecChainHandler)new TimerExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.IO)) {
            builder.addExecInterceptorAfter(ChainElement.CACHING.name(), IO_ID, (ExecChainHandler)new IoByteCounterExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.CONN_POOL)) {
            ConnPoolMeters.bindTo((HttpClientBuilder)builder, meterReg, config);
        }
    }

    public static void enable(HttpAsyncClientBuilder builder, ObservationRegistry obsReg) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, ObservingOptions.DEFAULT, MetricConfig.DEFAULT);
    }

    public static void enable(HttpAsyncClientBuilder builder, ObservationRegistry obsReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, opts, MetricConfig.DEFAULT);
    }

    public static void enable(HttpAsyncClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, meterReg, opts, MetricConfig.DEFAULT);
    }

    public static void enable(HttpAsyncClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts, MetricConfig mc) {
        MetricConfig config;
        Args.notNull((Object)builder, (String)"builder");
        Args.notNull((Object)meterReg, (String)"meterRegistry");
        ObservingOptions o = opts != null ? opts : ObservingOptions.DEFAULT;
        MetricConfig metricConfig = config = mc != null ? mc : MetricConfig.DEFAULT;
        if (obsReg != null) {
            builder.addExecInterceptorFirst(OBS_ID, (AsyncExecChainHandler)new ObservationAsyncExecInterceptor(obsReg, o));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.BASIC)) {
            builder.addExecInterceptorFirst(TIMER_ID, (AsyncExecChainHandler)new AsyncTimerExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.IO)) {
            builder.addExecInterceptorFirst(IO_ID, (AsyncExecChainHandler)new AsyncIoByteCounterExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.CONN_POOL)) {
            ConnPoolMetersAsync.bindTo(builder, meterReg, config);
        }
    }

    public static void enable(CachingHttpAsyncClientBuilder builder, ObservationRegistry obsReg) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, ObservingOptions.DEFAULT, MetricConfig.DEFAULT);
    }

    public static void enable(CachingHttpAsyncClientBuilder builder, ObservationRegistry obsReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, (MeterRegistry)Metrics.globalRegistry, opts, MetricConfig.DEFAULT);
    }

    public static void enable(CachingHttpAsyncClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts) {
        HttpClientObservationSupport.enable(builder, obsReg, meterReg, opts, MetricConfig.DEFAULT);
    }

    public static void enable(CachingHttpAsyncClientBuilder builder, ObservationRegistry obsReg, MeterRegistry meterReg, ObservingOptions opts, MetricConfig mc) {
        MetricConfig config;
        Args.notNull((Object)builder, (String)"builder");
        Args.notNull((Object)meterReg, (String)"meterRegistry");
        ObservingOptions o = opts != null ? opts : ObservingOptions.DEFAULT;
        MetricConfig metricConfig = config = mc != null ? mc : MetricConfig.DEFAULT;
        if (obsReg != null) {
            builder.addExecInterceptorAfter(ChainElement.CACHING.name(), OBS_ID, (AsyncExecChainHandler)new ObservationAsyncExecInterceptor(obsReg, o));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.BASIC)) {
            builder.addExecInterceptorAfter(ChainElement.CACHING.name(), TIMER_ID, (AsyncExecChainHandler)new AsyncTimerExec(meterReg, o, config));
        }
        if (o.metricSets.contains((Object)ObservingOptions.MetricSet.IO)) {
            builder.addExecInterceptorAfter(ChainElement.CACHING.name(), IO_ID, (AsyncExecChainHandler)new AsyncIoByteCounterExec(meterReg, o, config));
        }
    }

    private HttpClientObservationSupport() {
    }
}

