/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractImageParser
implements Parser {
    public static String OCR_MEDIATYPE_PREFIX = "ocr-";

    static MediaType convertToOCRMediaType(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return new MediaType(mediaType.getType(), OCR_MEDIATYPE_PREFIX + mediaType.getSubtype());
    }

    abstract void extractMetadata(InputStream var1, ContentHandler var2, Metadata var3, ParseContext var4) throws IOException, SAXException, TikaException;

    MediaType normalizeMediaType(MediaType mediaType) {
        return mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        String mediaTypeString = metadata.get("Content-Type");
        MediaType mediaType = this.normalizeMediaType(MediaType.parse((String)mediaTypeString));
        MediaType ocrMediaType = AbstractImageParser.convertToOCRMediaType(mediaType);
        Parser ocrParser = EmbeddedDocumentUtil.getStatelessParser((ParseContext)context);
        if (ocrMediaType == null || ocrParser == null || !ocrParser.getSupportedTypes(context).contains(ocrMediaType)) {
            this.extractMetadata(stream, handler, metadata, context);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.endDocument();
            return;
        }
        TemporaryResources tmpResources = new TemporaryResources();
        TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmpResources, (Metadata)metadata);
        Exception metadataException = null;
        try {
            InputStream pathStream;
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            Path path = tis.getPath();
            try {
                pathStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    this.extractMetadata(pathStream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)xhtml), metadata, context);
                }
                finally {
                    if (pathStream != null) {
                        pathStream.close();
                    }
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                metadataException = e;
            }
            pathStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                metadata.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, ocrMediaType.toString());
                ocrParser.parse(pathStream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), metadata, context);
            }
            finally {
                if (pathStream != null) {
                    pathStream.close();
                }
            }
            xhtml.endDocument();
        }
        finally {
            tmpResources.close();
        }
        if (metadataException != null) {
            throw new TikaException("problem extracting metadata", (Throwable)metadataException);
        }
    }
}

