/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.Utils;
import io.minio.messages.Checksum;
import io.minio.messages.Part;
import java.time.ZonedDateTime;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="GetObjectAttributesOutput", strict=false)
@Namespace(reference="http://s3.amazonaws.com/doc/2006-03-01/")
public class GetObjectAttributesOutput {
    @Element(name="ETag", required=false)
    private String etag;
    @Element(name="Checksum", required=false)
    private Checksum checksum;
    @Element(name="ObjectParts", required=false)
    private ObjectParts objectParts;
    @Element(name="StorageClass", required=false)
    private String storageClass;
    @Element(name="ObjectSize", required=false)
    private Long objectSize;
    private Boolean deleteMarker;
    private ZonedDateTime lastModified;
    private String versionId;

    public void setDeleteMarker(boolean deleteMarker) {
        this.deleteMarker = deleteMarker;
    }

    public void setLastModified(ZonedDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Boolean deleteMarker() {
        return this.deleteMarker;
    }

    public ZonedDateTime lastModified() {
        return this.lastModified;
    }

    public String versionId() {
        return this.versionId;
    }

    public String etag() {
        return this.etag;
    }

    public Checksum checksum() {
        return this.checksum;
    }

    public ObjectParts objectParts() {
        return this.objectParts;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Long objectSize() {
        return this.objectSize;
    }

    @Root(name="ObjectParts", strict=false)
    public static class ObjectParts {
        @Element(name="IsTruncated", required=false)
        private boolean isTruncated;
        @Element(name="MaxParts", required=false)
        private Integer maxParts;
        @Element(name="NextPartNumberMarker", required=false)
        private Integer nextPartNumberMarker;
        @Element(name="PartNumberMarker", required=false)
        private Integer partNumberMarker;
        @ElementList(name="Part", inline=true, required=false)
        private List<Part> parts;
        @Element(name="PartsCount", required=false)
        private Integer partsCount;

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public Integer maxParts() {
            return this.maxParts;
        }

        public Integer nextPartNumberMarker() {
            return this.nextPartNumberMarker;
        }

        public Integer partNumberMarker() {
            return this.partNumberMarker;
        }

        public List<Part> parts() {
            return Utils.unmodifiableList(this.parts);
        }

        public Integer partsCount() {
            return this.partsCount;
        }
    }
}

