/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.addxml;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.addxml.AddXml;
import org.apache.hop.pipeline.transforms.xml.addxml.AddXmlData;
import org.apache.hop.pipeline.transforms.xml.addxml.XmlField;
import org.w3c.dom.Node;

@Transform(id="AddXML", image="add_xml.svg", name="i18n::AddXML.name", description="i18n::AddXML.description", categoryDescription="i18n::AddXML.category", keywords={"i18n::AddXmlMeta.keyword"}, documentationUrl="/pipeline/transforms/addxml.html")
@InjectionSupported(localizationPrefix="AddXMLMeta.Injection.", groups={"OUTPUT_FIELDS"})
public class AddXmlMeta
extends BaseTransformMeta<AddXml, AddXmlData> {
    private static final Class<?> PKG = AddXmlMeta.class;
    public static final String CONST_FIELD = "field";
    public static final String CONST_SPACES = "        ";
    @Injection(name="OMIT_XML_HEADER")
    private boolean omitXMLheader;
    @Injection(name="OMIT_NULL_VALUES")
    private boolean omitNullValues;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="VALUE_NAME")
    private String valueName;
    @Injection(name="ROOT_NODE")
    private String rootNode;
    @InjectionDeep
    private XmlField[] outputFields;

    public boolean isOmitXMLheader() {
        return this.omitXMLheader;
    }

    public void setOmitXMLheader(boolean omitXMLheader) {
        this.omitXMLheader = omitXMLheader;
    }

    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }

    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    public XmlField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(XmlField[] outputFields) {
        this.outputFields = outputFields;
    }

    public void allocate(int nrFields) {
        this.outputFields = new XmlField[nrFields];
    }

    public Object clone() {
        AddXmlMeta retval = (AddXmlMeta)((Object)super.clone());
        int nrFields = this.outputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.outputFields[i] = (XmlField)this.outputFields[i].clone();
        }
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.valueName = XmlHandler.getTagValue((Node)transformNode, (String)"valueName");
            this.rootNode = XmlHandler.getTagValue((Node)transformNode, (String)"xml_repeat_element");
            this.omitXMLheader = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"omitXMLheader"));
            this.omitNullValues = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"omitNullValues"));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.outputFields[i] = new XmlField();
                this.outputFields[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setElementName(XmlHandler.getTagValue((Node)fnode, (String)"element"));
                this.outputFields[i].setType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.outputFields[i].setAttribute("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"attribute")));
                this.outputFields[i].setAttributeParentName(XmlHandler.getTagValue((Node)fnode, (String)"attributeParentName"));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.omitXMLheader = true;
        this.omitNullValues = false;
        this.encoding = "UTF-8";
        this.valueName = "xmlvaluename";
        this.rootNode = "Row";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.outputFields[i] = new XmlField();
            this.outputFields[i].setFieldName(CONST_FIELD + i);
            this.outputFields[i].setElementName(CONST_FIELD + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
            this.outputFields[i].setAttribute(false);
            this.outputFields[i].setElementName(CONST_FIELD + i);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v = new ValueMetaString(this.getValueName());
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
    }

    public String getXml() throws HopException {
        StringBuffer xml = new StringBuffer(500);
        xml.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        xml.append("    ").append(XmlHandler.addTagValue((String)"valueName", (String)this.valueName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"xml_repeat_element", (String)this.rootNode));
        xml.append("    <file>").append(Const.CR);
        xml.append("      ").append(XmlHandler.addTagValue((String)"omitXMLheader", (boolean)this.omitXMLheader));
        xml.append("      ").append(XmlHandler.addTagValue((String)"omitNullValues", (boolean)this.omitNullValues));
        xml.append("    </file>").append(Const.CR);
        xml.append("    <fields>").append(Const.CR);
        for (XmlField field : this.outputFields) {
            if (Utils.isEmpty((CharSequence)field.getFieldName())) continue;
            xml.append("      <field>").append(Const.CR);
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)field.getFieldName()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"element", (String)field.getElementName()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"format", (String)field.getFormat()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"attribute", (boolean)field.isAttribute()));
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"attributeParentName", (String)field.getAttributeParentName()));
            xml.append("        </field>").append(Const.CR);
        }
        xml.append("    </fields>" + Const.CR);
        return xml.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (XmlField outputField : this.outputFields) {
                int idx = prev.indexOfValue(outputField.getFieldName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + outputField.getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(String rootNode) {
        this.rootNode = rootNode;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }
}

