/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;

class QuoteValueMap
implements ValueMap,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final char SINGLE_QUOTE_ = '\'';
    private String emptyStringSpecialValue_ = null;

    public QuoteValueMap() {
    }

    public QuoteValueMap(String emptyStringSpecialValue) {
        if (emptyStringSpecialValue == null) {
            throw new NullPointerException("emptyStringSpecialValue");
        }
        this.emptyStringSpecialValue_ = emptyStringSpecialValue;
    }

    @Override
    public Object ltop(Object logicalValue, AS400 system) {
        if (logicalValue == null) {
            throw new NullPointerException("logicalValue");
        }
        if (!(logicalValue instanceof String)) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        String asString = (String)logicalValue;
        if (asString.length() == 0 && this.emptyStringSpecialValue_ != null) {
            return this.emptyStringSpecialValue_;
        }
        if (asString.length() > 0 && asString.charAt(0) == '*') {
            return asString;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('\'');
        buffer.append(asString);
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    public Object ptol(Object physicalValue, AS400 system) {
        if (physicalValue == null) {
            throw new NullPointerException("physicalValue");
        }
        if (!(physicalValue instanceof String)) {
            throw new ExtendedIllegalArgumentException("physicalValue", 2);
        }
        String asString = (String)physicalValue;
        int length = asString.length();
        if (asString.length() >= 2) {
            if (asString.charAt(0) == '\'') {
                if (asString.charAt(length - 1) == '\'') {
                    return asString.substring(1, length - 1);
                }
                return asString.substring(1);
            }
            if (asString.charAt(length - 1) == '\'') {
                return asString.substring(0, length - 1);
            }
        }
        return asString;
    }
}

