/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.Trace;

class IFSUnlockBytesReq
extends IFSDataStreamReq {
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int BASE_OFFSET_OFFSET = 26;
    private static final int RELATIVE_OFFSET_OFFSET = 30;
    private static final int UNLOCK_LENGTH_OFFSET = 34;
    private static final int UNLOCK_FLAGS_OFFSET = 38;
    private static final int LARGE_BASE_OFFSET_OFFSET = 40;
    private static final int LARGE_RELATIVE_OFFSET_OFFSET = 48;
    private static final int LARGE_UNLOCK_LENGTH_OFFSET = 56;

    IFSUnlockBytesReq(int fileHandle, long offset, long length, boolean isMandatory, int datastreamLevel) {
        super(20 + IFSUnlockBytesReq.getTemplateLength(datastreamLevel));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSUnlockBytesReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(8);
        this.set32bit(fileHandle, 22);
        this.set16bit(isMandatory ? 0 : 1, 38);
        if (datastreamLevel < 16) {
            if (offset > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified offset value (" + offset + ") exceeds maximum file length supported by system.");
                }
                offset = Integer.MAX_VALUE;
            }
            if (length > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified length value (" + length + ") exceeds maximum file length supported by system.");
                }
                length = Integer.MAX_VALUE;
            }
            this.set32bit(0, 26);
            this.set32bit((int)offset, 30);
            this.set32bit((int)length, 34);
        } else {
            this.set32bit(0, 26);
            this.set32bit(0, 30);
            this.set32bit(0, 34);
            this.set64bit(0L, 40);
            this.set64bit(offset, 48);
            this.set64bit(length, 56);
        }
    }

    private static final int getTemplateLength(int datastreamLevel) {
        return datastreamLevel < 16 ? 20 : 44;
    }
}

