/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.TwoInputOperator;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.configuration.Configuration;

@Deprecated
@Public
public abstract class TwoInputUdfOperator<IN1, IN2, OUT, O extends TwoInputUdfOperator<IN1, IN2, OUT, O>>
extends TwoInputOperator<IN1, IN2, OUT, O>
implements UdfOperator<O> {
    private Configuration parameters;
    private Map<String, DataSet<?>> broadcastVariables;
    private DualInputSemanticProperties udfSemantics;
    private boolean analyzedUdfSemantics;

    protected TwoInputUdfOperator(DataSet<IN1> input1, DataSet<IN2> input2, TypeInformation<OUT> resultType) {
        super(input1, input2, resultType);
    }

    protected abstract Function getFunction();

    @Override
    public O withParameters(Configuration parameters) {
        this.parameters = parameters;
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public O withBroadcastSet(DataSet<?> data, String name) {
        if (data == null) {
            throw new IllegalArgumentException("Broadcast variable data must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Broadcast variable name must not be null.");
        }
        if (this.broadcastVariables == null) {
            this.broadcastVariables = new HashMap();
        }
        this.broadcastVariables.put(name, data);
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withForwardedFieldsFirst(String ... forwardedFieldsFirst) {
        if (this.udfSemantics == null || this.analyzedUdfSemantics) {
            this.setSemanticProperties(this.extractSemanticAnnotationsFromUdf(this.getFunction().getClass()));
        }
        if (this.udfSemantics == null || this.analyzedUdfSemantics) {
            this.setSemanticProperties(new DualInputSemanticProperties());
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, forwardedFieldsFirst, null, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        } else {
            if (this.udfWithForwardedFieldsFirstAnnotation(this.getFunction().getClass())) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field information has already been added by a function annotation for the first input of this operator. Cannot overwrite function annotations.");
            }
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, forwardedFieldsFirst, null, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        }
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withForwardedFieldsSecond(String ... forwardedFieldsSecond) {
        if (this.udfSemantics == null || this.analyzedUdfSemantics) {
            this.setSemanticProperties(this.extractSemanticAnnotationsFromUdf(this.getFunction().getClass()));
        }
        if (this.udfSemantics == null || this.analyzedUdfSemantics) {
            this.setSemanticProperties(new DualInputSemanticProperties());
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, null, forwardedFieldsSecond, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        } else {
            if (this.udfWithForwardedFieldsSecondAnnotation(this.getFunction().getClass())) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field information has already been added by a function annotation for the second input of this operator. Cannot overwrite function annotations.");
            }
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, null, forwardedFieldsSecond, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        }
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O returns(Class<OUT> typeClass) {
        Objects.requireNonNull(typeClass, "type class must not be null");
        try {
            return this.returns(TypeInformation.of(typeClass));
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Cannot infer the type information from the class alone.This is most likely because the class represents a generic type. In that case,please use the 'returns(TypeHint)' method instead.", (Throwable)e);
        }
    }

    public O returns(TypeHint<OUT> typeHint) {
        Objects.requireNonNull(typeHint, "TypeHint must not be null");
        try {
            return this.returns(TypeInformation.of(typeHint));
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Cannot infer the type information from the type hint. Make sure that the TypeHint does not use any generic type variables.");
        }
    }

    public O returns(TypeInformation<OUT> typeInfo) {
        Objects.requireNonNull(typeInfo, "TypeInformation must not be null");
        this.fillInType(typeInfo);
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    @Internal
    public Map<String, DataSet<?>> getBroadcastSets() {
        return this.broadcastVariables == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.broadcastVariables);
    }

    @Override
    public Configuration getParameters() {
        return this.parameters;
    }

    @Internal
    public DualInputSemanticProperties getSemanticProperties() {
        DualInputSemanticProperties props;
        if ((this.udfSemantics == null || this.analyzedUdfSemantics) && (props = this.extractSemanticAnnotationsFromUdf(this.getFunction().getClass())) != null) {
            this.setSemanticProperties(props);
        }
        if (this.udfSemantics == null) {
            this.setSemanticProperties(new DualInputSemanticProperties());
        }
        return this.udfSemantics;
    }

    @Internal
    public void setSemanticProperties(DualInputSemanticProperties properties) {
        this.udfSemantics = properties;
        this.analyzedUdfSemantics = false;
    }

    protected boolean getAnalyzedUdfSemanticsFlag() {
        return this.analyzedUdfSemantics;
    }

    protected void setAnalyzedUdfSemanticsFlag() {
        this.analyzedUdfSemantics = true;
    }

    protected DualInputSemanticProperties extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
        Set<Annotation> annotations = FunctionAnnotation.readDualForwardAnnotations(udfClass);
        return SemanticPropUtil.getSemanticPropsDual(annotations, this.getInput1Type(), this.getInput2Type(), this.getResultType());
    }

    protected boolean udfWithForwardedFieldsFirstAnnotation(Class<?> udfClass) {
        return udfClass.getAnnotation(FunctionAnnotation.ForwardedFieldsFirst.class) != null || udfClass.getAnnotation(FunctionAnnotation.NonForwardedFieldsFirst.class) != null;
    }

    protected boolean udfWithForwardedFieldsSecondAnnotation(Class<?> udfClass) {
        return udfClass.getAnnotation(FunctionAnnotation.ForwardedFieldsSecond.class) != null || udfClass.getAnnotation(FunctionAnnotation.NonForwardedFieldsSecond.class) != null;
    }
}

