/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getsubfolders;

import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersData;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersMeta;

public class GetSubFolders
extends BaseTransform<GetSubFoldersMeta, GetSubFoldersData> {
    private static final Class<?> PKG = GetSubFoldersMeta.class;

    public GetSubFolders(TransformMeta transformMeta, GetSubFoldersMeta meta, GetSubFoldersData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (((GetSubFoldersMeta)this.meta).isFolderNameDynamic() && ((GetSubFoldersData)this.data).fileIndex >= ((GetSubFoldersData)this.data).filesCount) {
            ((GetSubFoldersData)this.data).inputRow = this.getRow();
        }
        if (this.first) {
            this.first = false;
            this.initialize();
        }
        if (((GetSubFoldersMeta)this.meta).isFolderNameDynamic()) {
            if (((GetSubFoldersData)this.data).inputRow == null) {
                this.setOutputDone();
                return false;
            }
        } else if (((GetSubFoldersData)this.data).fileIndex >= ((GetSubFoldersData)this.data).filesCount) {
            this.setOutputDone();
            return false;
        }
        if (this.outputNextFile()) {
            return false;
        }
        ++((GetSubFoldersData)this.data).fileIndex;
        if (this.checkFeedback(this.getLinesInput()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NrLine", (String[])new String[]{"" + this.getLinesInput()}));
        }
        return true;
    }

    private boolean outputNextFile() throws HopTransformException {
        try {
            Object[] outputRow = RowDataUtil.allocateRowData((int)((GetSubFoldersData)this.data).outputRowMeta.size());
            int outputIndex = 0;
            Object[] extraData = new Object[((GetSubFoldersData)this.data).nrTransformFields];
            if (((GetSubFoldersMeta)this.meta).isFolderNameDynamic()) {
                if (((GetSubFoldersData)this.data).fileIndex >= ((GetSubFoldersData)this.data).filesCount) {
                    String filename = this.getInputRowMeta().getString(((GetSubFoldersData)this.data).inputRow, ((GetSubFoldersData)this.data).indexOfFolderNameField);
                    String[] filesNames = new String[]{filename};
                    String[] filesRequired = new String[]{"N"};
                    ((GetSubFoldersData)this.data).files = ((GetSubFoldersMeta)this.meta).getDynamicFolderList((IVariables)this, filesNames, filesRequired);
                    ((GetSubFoldersData)this.data).filesCount = ((GetSubFoldersData)this.data).files.nrOfFiles();
                    ((GetSubFoldersData)this.data).fileIndex = 0;
                }
                outputRow = (Object[])((GetSubFoldersData)this.data).inputRow.clone();
            }
            if (((GetSubFoldersData)this.data).filesCount > 0) {
                ((GetSubFoldersData)this.data).file = ((GetSubFoldersData)this.data).files.getFile(((GetSubFoldersData)this.data).fileIndex);
                extraData[outputIndex++] = HopVfs.getFilename((FileObject)((GetSubFoldersData)this.data).file);
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.getName().getBaseName();
                extraData[outputIndex++] = HopVfs.getFilename((FileObject)((GetSubFoldersData)this.data).file.getParent());
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.isHidden();
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.isReadable();
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.isWriteable();
                extraData[outputIndex++] = new Date(((GetSubFoldersData)this.data).file.getContent().getLastModifiedTime());
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.getName().getURI();
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.getName().getRootURI();
                extraData[outputIndex++] = (long)((GetSubFoldersData)this.data).file.getChildren().length;
                if (((GetSubFoldersMeta)this.meta).isIncludeRowNumber() && !Utils.isEmpty((CharSequence)((GetSubFoldersMeta)this.meta).getRowNumberField())) {
                    extraData[outputIndex] = ((GetSubFoldersData)this.data).rowNumber;
                }
                ++((GetSubFoldersData)this.data).rowNumber;
                outputRow = RowDataUtil.addRowData((Object[])outputRow, (int)((GetSubFoldersData)this.data).totalPreviousFields, (Object[])extraData);
                this.putRow(((GetSubFoldersData)this.data).outputRowMeta, outputRow);
                if (((GetSubFoldersMeta)this.meta).getRowLimit() > 0L && ((GetSubFoldersData)this.data).rowNumber >= ((GetSubFoldersMeta)this.meta).getRowLimit()) {
                    this.setOutputDone();
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
        return false;
    }

    private void initialize() throws HopException {
        if (((GetSubFoldersMeta)this.meta).isFolderNameDynamic()) {
            ((GetSubFoldersData)this.data).inputRowMeta = this.getInputRowMeta();
            ((GetSubFoldersData)this.data).outputRowMeta = ((GetSubFoldersData)this.data).inputRowMeta.clone();
            ((GetSubFoldersMeta)this.meta).getFields(((GetSubFoldersData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GetSubFoldersData)this.data).totalPreviousFields = ((GetSubFoldersData)this.data).inputRowMeta.size();
            if (Utils.isEmpty((CharSequence)((GetSubFoldersMeta)this.meta).getDynamicFolderNameField())) {
                this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NoField", (String[])new String[0]));
                throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NoField", (String[])new String[0]));
            }
            if (((GetSubFoldersData)this.data).indexOfFolderNameField < 0) {
                String realDynamicFolderName = this.resolve(((GetSubFoldersMeta)this.meta).getDynamicFolderNameField());
                ((GetSubFoldersData)this.data).indexOfFolderNameField = ((GetSubFoldersData)this.data).inputRowMeta.indexOfValue(realDynamicFolderName);
                if (((GetSubFoldersData)this.data).indexOfFolderNameField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.ErrorFindingField", (String[])new String[0]) + "[" + realDynamicFolderName + "]");
                    throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.CouldnotFindField", (String[])new String[]{realDynamicFolderName}));
                }
            }
        } else {
            ((GetSubFoldersData)this.data).outputRowMeta = new RowMeta();
            ((GetSubFoldersMeta)this.meta).getFields(((GetSubFoldersData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GetSubFoldersData)this.data).files = ((GetSubFoldersMeta)this.meta).getFolderList((IVariables)this);
            ((GetSubFoldersData)this.data).filesCount = ((GetSubFoldersData)this.data).files.nrOfFiles();
            this.handleMissingFiles();
        }
        ((GetSubFoldersData)this.data).nrTransformFields = ((GetSubFoldersData)this.data).outputRowMeta.size();
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((GetSubFoldersData)this.data).files.getNonExistentFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Error.MissingFiles", (String[])new String[]{message}));
            throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.MissingFiles", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((GetSubFoldersData)this.data).files.getNonAccessibleFiles();
        if (!nonAccessibleFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Error.NoAccessibleFiles", (String[])new String[]{message}));
            throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.NoAccessibleFiles", (String[])new String[]{message}));
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((GetSubFoldersData)this.data).filesCount = 0;
                ((GetSubFoldersData)this.data).rowNumber = 1L;
                ((GetSubFoldersData)this.data).fileIndex = 0;
                ((GetSubFoldersData)this.data).totalPreviousFields = 0;
            }
            catch (Exception e) {
                this.logError("Error initializing transform: ", e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((GetSubFoldersData)this.data).file != null) {
            try {
                ((GetSubFoldersData)this.data).file.close();
                ((GetSubFoldersData)this.data).file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

