/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.checksum;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.checksum.CheckSum;
import org.apache.hop.pipeline.transforms.checksum.CheckSumData;
import org.apache.hop.pipeline.transforms.checksum.Field;

@Transform(id="CheckSum", image="checksum.svg", name="i18n::CheckSum.Name", description="i18n::CheckSum.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::CheckSumMeta.keyword"}, documentationUrl="/pipeline/transforms/addchecksum.html")
public class CheckSumMeta
extends BaseTransformMeta<CheckSum, CheckSumData> {
    private static final Class<?> PKG = CheckSumMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionKey="FIELD", injectionKeyDescription="CheckSum.Injection.FIELD")
    private List<Field> fields = new ArrayList<Field>();
    @HopMetadataProperty(key="resultfieldName", injectionKey="RESULT_FIELD", injectionKeyDescription="CheckSum.Injection.RESULT_FIELD")
    private String resultFieldName;
    @HopMetadataProperty(key="checksumtype", storeWithCode=true, injectionKey="TYPE", injectionKeyDescription="CheckSum.Injection.TYPE")
    private CheckSumType checkSumType = CheckSumType.CRC32;
    @HopMetadataProperty(key="resultType", storeWithCode=true, injectionKey="RESULT_TYPE", injectionKeyDescription="CheckSum.Injection.RESULT_TYPE")
    private ResultType resultType = ResultType.STRING;

    public CheckSumMeta clone() {
        CheckSumMeta meta = new CheckSumMeta();
        meta.checkSumType = this.checkSumType;
        meta.resultFieldName = this.resultFieldName;
        meta.resultType = this.resultType;
        for (Field field : this.fields) {
            meta.fields.add(new Field(field));
        }
        return meta;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.resultFieldName)) {
            ValueMetaInteger v = null;
            if (this.checkSumType == CheckSumType.CRC32 || this.checkSumType == CheckSumType.ADLER32) {
                v = new ValueMetaInteger(variables.resolve(this.resultFieldName));
            } else {
                v = switch (this.resultType) {
                    case ResultType.BINARY -> new ValueMetaBinary(variables.resolve(this.resultFieldName));
                    default -> new ValueMetaString(variables.resolve(this.resultFieldName));
                };
            }
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.resultFieldName)) {
            errorMessage = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
        }
        remarks.add((ICheckResult)cr);
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            boolean errorFound = false;
            errorMessage = "";
            for (Field field : this.fields) {
                int idx = prev.indexOfValue(field.getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + field.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (!this.fields.isEmpty()) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String resultFieldName) {
        this.resultFieldName = resultFieldName;
    }

    public CheckSumType getCheckSumType() {
        return this.checkSumType;
    }

    public void setCheckSumType(CheckSumType checkSumType) {
        this.checkSumType = checkSumType;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public static enum CheckSumType implements IEnumHasCode
    {
        NONE("NONE", ""),
        CRC32("CRC32", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.CRC32", (String[])new String[0])),
        ADLER32("ADLER32", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.ADLER32", (String[])new String[0])),
        MD5("MD5", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.MD5", (String[])new String[0])),
        SHA1("SHA-1", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.SHA1", (String[])new String[0])),
        SHA256("SHA-256", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.SHA256", (String[])new String[0])),
        SHA384("SHA-384", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.SHA384", (String[])new String[0])),
        SHA512("SHA-512", BaseMessages.getString(PKG, (String)"CheckSumMeta.Type.SHA512", (String[])new String[0]));

        private String code;
        private String description;

        private CheckSumType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static final CheckSumType getTypeFromDescription(String description) {
            for (CheckSumType type : CheckSumType.values()) {
                if (!type.description.equals(description)) continue;
                return type;
            }
            return NONE;
        }

        public static final String[] getDescriptions() {
            String[] descriptions = new String[CheckSumType.values().length - 1];
            for (int i = 1; i < CheckSumType.values().length; ++i) {
                descriptions[i - 1] = CheckSumType.values()[i].description;
            }
            return descriptions;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum ResultType implements IEnumHasCode
    {
        STRING("string", BaseMessages.getString(PKG, (String)"CheckSumMeta.ResultType.String", (String[])new String[0])),
        HEXADECIMAL("hexadecimal", BaseMessages.getString(PKG, (String)"CheckSumMeta.ResultType.Hexadecimal", (String[])new String[0])),
        BINARY("binary", BaseMessages.getString(PKG, (String)"CheckSumMeta.ResultType.Binary", (String[])new String[0]));

        private String code;
        private String description;

        private ResultType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static final ResultType getTypeFromDescription(String description) {
            for (ResultType type : ResultType.values()) {
                if (!type.description.equals(description)) continue;
                return type;
            }
            return STRING;
        }

        public static final String[] getDescriptions() {
            String[] descriptions = new String[ResultType.values().length];
            for (int i = 0; i < ResultType.values().length; ++i) {
                descriptions[i] = ResultType.values()[i].description;
            }
            return descriptions;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

