/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ServerListener;
import com.mongodb.internal.connection.ClientMetadata;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.DefaultConnectionFactory;
import com.mongodb.internal.connection.DefaultConnectionPool;
import com.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import com.mongodb.internal.connection.DefaultServer;
import com.mongodb.internal.connection.DefaultServerMonitor;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.InternalOperationContextFactory;
import com.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.inject.SameObjectProvider;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final InternalOperationContextFactory clusterOperationContextFactory;
    private final StreamFactory streamFactory;
    private final InternalOperationContextFactory heartbeatOperationContextFactory;
    private final StreamFactory heartbeatStreamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;
    private final boolean isFunctionAsAServiceEnvironment;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, InternalOperationContextFactory clusterOperationContextFactory, StreamFactory streamFactory, InternalOperationContextFactory heartbeatOperationContextFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, boolean isFunctionAsAServiceEnvironment) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.clusterOperationContextFactory = clusterOperationContextFactory;
        this.streamFactory = streamFactory;
        this.heartbeatOperationContextFactory = heartbeatOperationContextFactory;
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
        this.isFunctionAsAServiceEnvironment = isFunctionAsAServiceEnvironment;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        ClientMetadata clientMetadata = cluster.getClientMetadata();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, new InternalStreamConnectionFactory(clusterMode, true, this.heartbeatStreamFactory, null, clientMetadata, Collections.emptyList(), this.loggerSettings, null, this.serverApi), clusterMode, this.serverApi, this.isFunctionAsAServiceEnvironment, sdamProvider, this.heartbeatOperationContextFactory);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterMode, this.streamFactory, this.credential, clientMetadata, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, sdamProvider, this.clusterOperationContextFactory);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, serverMonitor, connectionPool, clusterMode);
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, clusterMode, connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

