/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.shared;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.SwtUniversalImage;
import org.apache.hop.core.SwtUniversalImageSvg;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.workflow.action.ActionMeta;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.w3c.dom.Document;

public class SwtGc
implements IGc {
    protected Color background;
    protected Color black;
    protected Color white;
    protected Color red;
    protected Color yellow;
    protected Color hopFalse;
    protected Color green;
    protected Color blue;
    protected Color magenta;
    protected Color purpule;
    protected Color indigo;
    protected Color gray;
    protected Color lightGray;
    protected Color darkGray;
    protected Color lightBlue;
    protected Color crystal;
    protected Color hopDefault;
    protected Color hopTrue;
    protected Color deprecated;
    private GC gc;
    private int iconSize;
    private int miniIconSize;
    private float currentMagnification = 1.0f;
    private List<Color> colors;
    private List<Font> fonts;
    private Point area;
    private Transform transform;

    public SwtGc(GC gc, int width, int height, int iconSize) {
        this.gc = gc;
        this.iconSize = iconSize;
        this.miniIconSize = iconSize / 2;
        this.area = new Point(width, height);
        this.colors = new ArrayList<Color>();
        this.fonts = new ArrayList<Font>();
        this.background = GuiResource.getInstance().getColorGraph();
        this.black = GuiResource.getInstance().getColorBlack();
        this.white = GuiResource.getInstance().getColorWhite();
        this.red = GuiResource.getInstance().getColorRed();
        this.yellow = GuiResource.getInstance().getColorYellow();
        this.hopFalse = GuiResource.getInstance().getColorOrange();
        this.green = GuiResource.getInstance().getColorGreen();
        this.blue = GuiResource.getInstance().getColorBlue();
        this.magenta = GuiResource.getInstance().getColorMagenta();
        this.purpule = GuiResource.getInstance().getColorPurple();
        this.indigo = GuiResource.getInstance().getColorIndigo();
        this.gray = GuiResource.getInstance().getColorGray();
        this.lightGray = GuiResource.getInstance().getColorLightGray();
        this.darkGray = GuiResource.getInstance().getColorDarkGray();
        this.lightBlue = GuiResource.getInstance().getColorLightBlue();
        this.crystal = GuiResource.getInstance().getColorCrystalText();
        this.hopDefault = GuiResource.getInstance().getColorHopDefault();
        this.hopTrue = GuiResource.getInstance().getColorHopTrue();
        this.deprecated = GuiResource.getInstance().getColorDeprecated();
    }

    public void dispose() {
        if (this.transform != null && !this.transform.isDisposed()) {
            this.transform.dispose();
        }
        for (Color color : this.colors) {
            color.dispose();
        }
        for (Font font : this.fonts) {
            font.dispose();
        }
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.gc.drawLine(x, y, x2, y2);
    }

    public void drawImage(IGc.EImage image, int x, int y, float magnification) {
        Image img = SwtGc.getNativeImage(image).getAsBitmapForSize(this.gc.getDevice(), Math.round((float)this.miniIconSize * magnification), Math.round((float)this.miniIconSize * magnification));
        if (img != null) {
            Rectangle bounds = img.getBounds();
            this.gc.drawImage(img, 0, 0, bounds.width, bounds.height, x, y, this.miniIconSize, this.miniIconSize);
        }
    }

    public void drawImage(IGc.EImage image, int x, int y, int width, int height, float magnification) {
        Image img = SwtGc.getNativeImage(image).getAsBitmapForSize(this.gc.getDevice(), Math.round((float)width * magnification), Math.round((float)height * magnification));
        if (img != null) {
            Rectangle bounds = img.getBounds();
            this.gc.drawImage(img, 0, 0, bounds.width, bounds.height, x, y, width, height);
        }
    }

    public void drawImage(IGc.EImage image, int x, int y, float magnification, double angle) {
        Image img = SwtGc.getNativeImage(image).getAsBitmapForSize(this.gc.getDevice(), Math.round((float)this.miniIconSize * magnification), Math.round((float)this.miniIconSize * magnification), angle);
        if (img != null) {
            Rectangle bounds = img.getBounds();
            int hx = Math.round((float)bounds.width / magnification);
            int hy = Math.round((float)bounds.height / magnification);
            this.gc.drawImage(img, 0, 0, bounds.width, bounds.height, x - hx / 2, y - hy / 2, hx, hy);
        }
    }

    public static SwtUniversalImage getNativeImage(IGc.EImage image) {
        return switch (image) {
            case IGc.EImage.LOCK -> GuiResource.getInstance().getSwtImageLocked();
            case IGc.EImage.FAILURE -> GuiResource.getInstance().getSwtImageFailure();
            case IGc.EImage.EDIT -> GuiResource.getInstance().getSwtImageEdit();
            case IGc.EImage.TRUE -> GuiResource.getInstance().getSwtImageTrue();
            case IGc.EImage.TRUE_DISABLED -> GuiResource.getInstance().getSwtImageTrueDisabled();
            case IGc.EImage.FALSE -> GuiResource.getInstance().getSwtImageFalse();
            case IGc.EImage.FALSE_DISABLED -> GuiResource.getInstance().getSwtImageFalseDisabled();
            case IGc.EImage.ERROR -> GuiResource.getInstance().getSwtImageError();
            case IGc.EImage.ERROR_DISABLED -> GuiResource.getInstance().getSwtImageErrorDisabled();
            case IGc.EImage.SUCCESS -> GuiResource.getInstance().getSwtImageSuccess();
            case IGc.EImage.INFO -> GuiResource.getInstance().getSwtImageInfo();
            case IGc.EImage.INFO_DISABLED -> GuiResource.getInstance().getSwtImageInfoDisabled();
            case IGc.EImage.TARGET -> GuiResource.getInstance().getSwtImageTarget();
            case IGc.EImage.TARGET_DISABLED -> GuiResource.getInstance().getSwtImageTargetDisabled();
            case IGc.EImage.INPUT -> GuiResource.getInstance().getSwtImageInput();
            case IGc.EImage.OUTPUT -> GuiResource.getInstance().getSwtImageOutput();
            case IGc.EImage.COPY_ROWS -> GuiResource.getInstance().getSwtImageCopyRows();
            case IGc.EImage.COPY_ROWS_DISABLED -> GuiResource.getInstance().getSwtImageCopyRowsDisabled();
            case IGc.EImage.LOAD_BALANCE -> GuiResource.getInstance().getSwtImageBalance();
            case IGc.EImage.CHECKPOINT -> GuiResource.getInstance().getSwtImageCheckpoint();
            case IGc.EImage.DB -> GuiResource.getInstance().getSwtImageDatabase();
            case IGc.EImage.PARALLEL -> GuiResource.getInstance().getSwtImageParallel();
            case IGc.EImage.PARALLEL_DISABLED -> GuiResource.getInstance().getSwtImageParallelDisabled();
            case IGc.EImage.UNCONDITIONAL -> GuiResource.getInstance().getSwtImageUnconditional();
            case IGc.EImage.UNCONDITIONAL_DISABLED -> GuiResource.getInstance().getSwtImageUnconditionalDisabled();
            case IGc.EImage.BUSY -> GuiResource.getInstance().getSwtImageBusy();
            case IGc.EImage.WAITING -> GuiResource.getInstance().getSwtImageWaiting();
            case IGc.EImage.INJECT -> GuiResource.getInstance().getSwtImageInject();
            case IGc.EImage.ARROW_DEFAULT -> GuiResource.getInstance().getSwtImageArrowDefault();
            case IGc.EImage.ARROW_TRUE -> GuiResource.getInstance().getSwtImageArrowTrue();
            case IGc.EImage.ARROW_FALSE -> GuiResource.getInstance().getSwtImageArrowFalse();
            case IGc.EImage.ARROW_ERROR -> GuiResource.getInstance().getSwtImageArrowError();
            case IGc.EImage.ARROW_DISABLED -> GuiResource.getInstance().getSwtImageArrowDisabled();
            case IGc.EImage.ARROW_CANDIDATE -> GuiResource.getInstance().getSwtImageArrowCandidate();
            case IGc.EImage.DATA -> GuiResource.getInstance().getSwtImageData();
            default -> null;
        };
    }

    public void drawPoint(int x, int y) {
        this.gc.drawPoint(x, y);
    }

    public void drawPolygon(int[] polygon) {
        this.gc.drawPolygon(polygon);
    }

    public void drawPolyline(int[] polyline) {
        this.gc.drawPolyline(polyline);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRectangle(x, y, width, height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.drawRoundRectangle(x, y, width, height, circleWidth, circleHeight);
    }

    public void drawText(String text, int x, int y) {
        this.gc.drawText(text, x, y);
    }

    public void drawText(String text, int x, int y, boolean transparent) {
        this.gc.drawText(text, x, y, 7);
    }

    public void fillPolygon(int[] polygon) {
        this.gc.fillPolygon(polygon);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.gc.fillRectangle(x, y, width, height);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.gc.fillGradientRectangle(x, y, width, height, vertical);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.fillRoundRectangle(x, y, width, height, circleWidth, circleHeight);
    }

    public Point getDeviceBounds() {
        Rectangle p = this.gc.getDevice().getBounds();
        return new Point(p.width, p.height);
    }

    public void setAlpha(int alpha) {
        this.gc.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.gc.getAlpha();
    }

    public void setBackground(IGc.EColor color) {
        this.gc.setBackground(this.getColor(color));
    }

    private Color getColor(IGc.EColor color) {
        return switch (color) {
            case IGc.EColor.BACKGROUND -> this.background;
            case IGc.EColor.BLACK -> this.black;
            case IGc.EColor.WHITE -> this.white;
            case IGc.EColor.RED -> this.red;
            case IGc.EColor.YELLOW -> this.yellow;
            case IGc.EColor.GREEN -> this.green;
            case IGc.EColor.BLUE -> this.blue;
            case IGc.EColor.MAGENTA -> this.magenta;
            case IGc.EColor.PURPULE -> this.purpule;
            case IGc.EColor.INDIGO -> this.indigo;
            case IGc.EColor.GRAY -> this.gray;
            case IGc.EColor.LIGHTGRAY -> this.lightGray;
            case IGc.EColor.DARKGRAY -> this.darkGray;
            case IGc.EColor.LIGHTBLUE -> this.lightBlue;
            case IGc.EColor.CRYSTAL -> this.crystal;
            case IGc.EColor.HOP_DEFAULT -> this.hopDefault;
            case IGc.EColor.HOP_TRUE -> this.hopTrue;
            case IGc.EColor.HOP_FALSE -> this.hopFalse;
            case IGc.EColor.DEPRECATED -> this.deprecated;
            default -> null;
        };
    }

    public void setFont(IGc.EFont font) {
        switch (font) {
            case GRAPH: {
                this.gc.setFont(GuiResource.getInstance().getFontGraph());
                break;
            }
            case NOTE: {
                this.gc.setFont(GuiResource.getInstance().getFontNote());
                break;
            }
            case SMALL: {
                this.gc.setFont(GuiResource.getInstance().getFontSmall());
                break;
            }
        }
    }

    public void setForeground(IGc.EColor color) {
        this.gc.setForeground(this.getColor(color));
    }

    public void setLineStyle(IGc.ELineStyle lineStyle) {
        if (!EnvironmentUtils.getInstance().isWeb()) {
            switch (lineStyle) {
                case DASHDOT: {
                    this.gc.setLineStyle(4);
                    break;
                }
                case SOLID: {
                    this.gc.setLineStyle(1);
                    break;
                }
                case DOT: {
                    this.gc.setLineStyle(3);
                    break;
                }
                case DASH: {
                    this.gc.setLineStyle(2);
                    break;
                }
                case PARALLEL: {
                    this.gc.setLineAttributes(new LineAttributes((float)this.gc.getLineWidth(), 1, 1, 6, new float[]{5.0f, 3.0f}, 0.0f, 10.0f));
                    break;
                }
            }
        }
    }

    public void setLineWidth(int width) {
        this.gc.setLineWidth(width);
    }

    public void setTransform(float translationX, float translationY, float magnification) {
        if (this.transform != null) {
            this.transform.dispose();
        }
        this.transform = new Transform(this.gc.getDevice());
        this.transform.translate(translationX, translationY);
        this.transform.scale(magnification, magnification);
        this.gc.setTransform(this.transform);
        this.currentMagnification = magnification;
    }

    public float getMagnification() {
        return this.currentMagnification;
    }

    public Point textExtent(String text) {
        org.eclipse.swt.graphics.Point p = this.gc.textExtent(text);
        return new Point(p.x, p.y);
    }

    public void drawTransformIcon(int x, int y, TransformMeta transformMeta, float magnification) {
        SwtUniversalImage swtImage = null;
        if (transformMeta.isMissing()) {
            swtImage = GuiResource.getInstance().getSwtImageMissing();
        } else if (transformMeta.isDeprecated()) {
            swtImage = GuiResource.getInstance().getSwtImageDeprecated();
        } else {
            String pluginId = transformMeta.getPluginId();
            if (pluginId != null) {
                swtImage = GuiResource.getInstance().getSwtImageTransform(pluginId);
            }
        }
        if (swtImage == null) {
            return;
        }
        int w = Math.round((float)this.iconSize * magnification);
        int h = Math.round((float)this.iconSize * magnification);
        Image image = swtImage.getAsBitmapForSize(this.gc.getDevice(), w, h);
        Rectangle bounds = image.getBounds();
        this.gc.drawImage(image, 0, 0, bounds.width, bounds.height, x, y, this.iconSize, this.iconSize);
    }

    public void drawActionIcon(int x, int y, ActionMeta actionMeta, float magnification) {
        if (actionMeta == null) {
            return;
        }
        SwtUniversalImage swtImage = null;
        int w = Math.round((float)this.iconSize * magnification);
        int h = Math.round((float)this.iconSize * magnification);
        if (actionMeta.isMissing()) {
            swtImage = GuiResource.getInstance().getSwtImageMissing();
        } else if (actionMeta.isDeprecated()) {
            swtImage = GuiResource.getInstance().getSwtImageDeprecated();
        } else {
            String pluginId = actionMeta.getAction().getPluginId();
            if (pluginId != null) {
                swtImage = GuiResource.getInstance().getSwtImageAction(pluginId);
            }
        }
        if (swtImage == null) {
            return;
        }
        Image image = swtImage.getAsBitmapForSize(this.gc.getDevice(), w, h);
        Rectangle bounds = image.getBounds();
        this.gc.drawImage(image, 0, 0, bounds.width, bounds.height, x, y, this.iconSize, this.iconSize);
    }

    public void drawImage(SvgFile svgFile, int x, int y, int desiredWidth, int desiredHeight, float magnification, double angle) throws HopException {
        SvgCacheEntry cacheEntry = SvgCache.loadSvg((SvgFile)svgFile);
        SwtUniversalImageSvg imageSvg = new SwtUniversalImageSvg(new SvgImage((Document)cacheEntry.getSvgDocument()));
        int magnifiedWidth = Math.round((float)desiredWidth * magnification);
        int magnifiedHeight = Math.round((float)desiredHeight * magnification);
        if (angle != 0.0) {
            Image img = imageSvg.getAsBitmapForSize(this.gc.getDevice(), magnifiedWidth, magnifiedHeight, angle);
            Rectangle bounds = img.getBounds();
            int hx = Math.round((float)bounds.width / magnification);
            int hy = Math.round((float)bounds.height / magnification);
            this.gc.drawImage(img, 0, 0, bounds.width, bounds.height, x - hx / 2, y - hy / 2, hx, hy);
        } else {
            Image img = imageSvg.getAsBitmapForSize(this.gc.getDevice(), magnifiedWidth, magnifiedHeight);
            Rectangle bounds = img.getBounds();
            this.gc.drawImage(img, 0, 0, bounds.width, bounds.height, x, y, desiredWidth, desiredHeight);
        }
    }

    public void setAntialias(boolean antiAlias) {
        if (antiAlias) {
            this.gc.setAntialias(1);
        } else {
            this.gc.setAntialias(0);
        }
    }

    public void setBackground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setBackground(color);
    }

    public void setForeground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setForeground(color);
    }

    private Color getColor(int r, int g, int b) {
        Color color = new Color((Device)PropsUi.getDisplay(), new RGB(r, g, b));
        int index = this.colors.indexOf(color);
        if (index < 0) {
            this.colors.add(color);
        } else {
            color.dispose();
            color = this.colors.get(index);
        }
        return color;
    }

    public void setFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic) {
        Font font;
        int index;
        int swt = 0;
        if (fontBold) {
            swt = 1;
        }
        if (fontItalic) {
            swt |= 2;
        }
        if ((index = this.fonts.indexOf(font = new Font((Device)PropsUi.getDisplay(), fontName, fontSize, swt))) < 0) {
            this.fonts.add(font);
        } else {
            font.dispose();
            font = this.fonts.get(index);
        }
        this.gc.setFont(font);
    }

    public void switchForegroundBackgroundColors() {
        Color fg = this.gc.getForeground();
        Color bg = this.gc.getBackground();
        this.gc.setForeground(bg);
        this.gc.setBackground(fg);
    }

    public Point getArea() {
        return this.area;
    }
}

