/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import org.apache.beam.sdk.io.gcp.bigtable.BigtableReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration
extends BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration {
    private final String tableId;
    private final String instanceId;
    private final String projectId;
    private final @Nullable Boolean flatten;

    private AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration(String tableId, String instanceId, String projectId, @Nullable Boolean flatten) {
        this.tableId = tableId;
        this.instanceId = instanceId;
        this.projectId = projectId;
        this.flatten = flatten;
    }

    @Override
    @SchemaFieldDescription(value="Bigtable table ID to read from.")
    public String getTableId() {
        return this.tableId;
    }

    @Override
    @SchemaFieldDescription(value="Bigtable instance ID to connect to.")
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @SchemaFieldDescription(value="Google Cloud project ID containing the Bigtable instance.")
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @SchemaFieldDescription(value="If set to false, output rows are nested; if true or omitted, output rows are flattened.")
    public @Nullable Boolean getFlatten() {
        return this.flatten;
    }

    public String toString() {
        return "BigtableReadSchemaTransformConfiguration{tableId=" + this.tableId + ", instanceId=" + this.instanceId + ", projectId=" + this.projectId + ", flatten=" + this.flatten + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration) {
            BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration that = (BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration)o;
            return this.tableId.equals(that.getTableId()) && this.instanceId.equals(that.getInstanceId()) && this.projectId.equals(that.getProjectId()) && (this.flatten == null ? that.getFlatten() == null : this.flatten.equals(that.getFlatten()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.flatten == null ? 0 : this.flatten.hashCode();
    }

    static final class Builder
    extends BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration.Builder {
        private String tableId;
        private String instanceId;
        private String projectId;
        private @Nullable Boolean flatten;

        Builder() {
        }

        @Override
        public BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration.Builder setTableId(String tableId) {
            if (tableId == null) {
                throw new NullPointerException("Null tableId");
            }
            this.tableId = tableId;
            return this;
        }

        @Override
        public BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration.Builder setInstanceId(String instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("Null instanceId");
            }
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        public BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration.Builder setFlatten(Boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        @Override
        public BigtableReadSchemaTransformProvider.BigtableReadSchemaTransformConfiguration build() {
            if (this.tableId == null || this.instanceId == null || this.projectId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.tableId == null) {
                    missing.append(" tableId");
                }
                if (this.instanceId == null) {
                    missing.append(" instanceId");
                }
                if (this.projectId == null) {
                    missing.append(" projectId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigtableReadSchemaTransformProvider_BigtableReadSchemaTransformConfiguration(this.tableId, this.instanceId, this.projectId, this.flatten);
        }
    }
}

