/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.core.GraphUsage;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoConnectionUtils;
import org.apache.hop.neo4j.transforms.BaseNeoTransform;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputData;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputMeta;
import org.apache.hop.neo4j.transforms.output.OperationType;
import org.apache.hop.neo4j.transforms.output.fields.LabelField;
import org.apache.hop.neo4j.transforms.output.fields.NodeField;
import org.apache.hop.neo4j.transforms.output.fields.PropertyField;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.neo4j.driver.Result;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;

public class Neo4JOutput
extends BaseNeoTransform<Neo4JOutputMeta, Neo4JOutputData> {
    public Neo4JOutput(TransformMeta s, Neo4JOutputMeta meta, Neo4JOutputData data, int c, PipelineMeta t, Pipeline dis) {
        super(s, meta, data, c, t, dis);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((Neo4JOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((Neo4JOutputMeta)this.meta).getFields(((Neo4JOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((Neo4JOutputData)this.data).fieldNames = ((Neo4JOutputData)this.data).outputRowMeta.getFieldNames();
            ((Neo4JOutputData)this.data).fromNodePropIndexes = new int[((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().size()];
            ((Neo4JOutputData)this.data).fromNodePropTypes = new GraphPropertyType[((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().size()];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().size(); ++i) {
                ((Neo4JOutputData)this.data).fromNodePropIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().get(i).getPropertyValue());
                if (((Neo4JOutputData)this.data).fromNodePropIndexes[i] < 0) {
                    throw new HopException("From node: Unable to find field '" + ((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().get(i).getPropertyValue() + "' for property name '" + ((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().get(i).getPropertyName() + "'");
                }
                ((Neo4JOutputData)this.data).fromNodePropTypes[i] = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().get(i).getPropertyType());
            }
            ((Neo4JOutputData)this.data).fromNodeLabelIndexes = new int[((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().size()];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().size(); ++i) {
                ((Neo4JOutputData)this.data).fromNodeLabelIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().get(i).getLabelField());
                if (((Neo4JOutputData)this.data).fromNodeLabelIndexes[i] >= 0 || !StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().get(i).getLabel())) continue;
                throw new HopException("From node : please provide either a static label value or a field name to determine the label");
            }
            ((Neo4JOutputData)this.data).toNodePropIndexes = new int[((Neo4JOutputMeta)this.meta).getNodeToField().getProperties().size()];
            ((Neo4JOutputData)this.data).toNodePropTypes = new GraphPropertyType[((Neo4JOutputMeta)this.meta).getNodeToField().getProperties().size()];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getNodeToField().getProperties().size(); ++i) {
                ((Neo4JOutputData)this.data).toNodePropIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getNodeToField().getProperties().get(i).getPropertyValue());
                ((Neo4JOutputData)this.data).toNodePropTypes[i] = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getNodeToField().getProperties().get(i).getPropertyType());
            }
            if (Utils.isEmpty((CharSequence)((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(0).getLabel()) && Utils.isEmpty((CharSequence)((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(0).getLabelField())) {
                ((Neo4JOutputData)this.data).toNodeLabelIndexes = new int[0];
            } else {
                ((Neo4JOutputData)this.data).toNodeLabelIndexes = new int[((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().size()];
                for (i = 0; i < ((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().size(); ++i) {
                    ((Neo4JOutputData)this.data).toNodeLabelIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(i).getLabelField());
                    if (((Neo4JOutputData)this.data).toNodeLabelIndexes[i] >= 0 || !StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(i).getLabel())) continue;
                    throw new HopException("To node : please provide either a static label value or a field name to determine the label");
                }
            }
            ((Neo4JOutputData)this.data).relPropIndexes = new int[((Neo4JOutputMeta)this.meta).getRelProps().size()];
            ((Neo4JOutputData)this.data).relPropTypes = new GraphPropertyType[((Neo4JOutputMeta)this.meta).getRelProps().size()];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getRelProps().size(); ++i) {
                ((Neo4JOutputData)this.data).relPropIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getRelProps().get(i).getPropertyValue());
                ((Neo4JOutputData)this.data).relPropTypes[i] = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getRelProps().get(i).getPropertyType());
            }
            ((Neo4JOutputData)this.data).relationshipIndex = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getRelationship());
            ((Neo4JOutputData)this.data).fromLabelValues = new String[((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().size()];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().size(); ++i) {
                ((Neo4JOutputData)this.data).fromLabelValues[i] = this.resolve(((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().get(i).getLabel());
            }
            ((Neo4JOutputData)this.data).toLabelValues = new String[((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().size()];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().size(); ++i) {
                ((Neo4JOutputData)this.data).toLabelValues[i] = this.resolve(((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(i).getLabel());
            }
            ((Neo4JOutputData)this.data).relationshipLabelValue = this.resolve(((Neo4JOutputMeta)this.meta).getRelationshipValue());
            ((Neo4JOutputData)this.data).unwindList = new ArrayList<Map<String, Object>>();
            ((Neo4JOutputData)this.data).dynamicFromLabels = this.determineDynamicLabels(((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels());
            ((Neo4JOutputData)this.data).dynamicToLabels = this.determineDynamicLabels(((Neo4JOutputMeta)this.meta).getNodeToField().getLabels());
            ((Neo4JOutputData)this.data).dynamicRelLabel = StringUtils.isNotEmpty((String)((Neo4JOutputMeta)this.meta).getRelationship());
            ((Neo4JOutputData)this.data).previousFromLabelsClause = null;
            ((Neo4JOutputData)this.data).previousToLabelsClause = null;
            ((Neo4JOutputData)this.data).previousRelationshipLabel = null;
            ((Neo4JOutputData)this.data).fromOperationType = OperationType.MERGE;
            ((Neo4JOutputData)this.data).toOperationType = OperationType.MERGE;
            ((Neo4JOutputData)this.data).relOperationType = OperationType.MERGE;
            if (((Neo4JOutputMeta)this.meta).isUsingCreate()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.CREATE;
                ((Neo4JOutputData)this.data).toOperationType = OperationType.CREATE;
                ((Neo4JOutputData)this.data).relOperationType = OperationType.CREATE;
            }
            if (((Neo4JOutputMeta)this.meta).isOnlyCreatingRelationships()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.MATCH;
                ((Neo4JOutputData)this.data).toOperationType = OperationType.MATCH;
                ((Neo4JOutputData)this.data).relOperationType = OperationType.CREATE;
            }
            if (((Neo4JOutputMeta)this.meta).getNodeFromField().isReadOnly()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.MATCH;
            }
            if (((Neo4JOutputMeta)this.meta).getNodeToField().isReadOnly()) {
                ((Neo4JOutputData)this.data).toOperationType = OperationType.MATCH;
            }
            if (((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().isEmpty()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.NONE;
            }
            if (((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().isEmpty() || Utils.isEmpty((CharSequence)((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(0).getLabel()) && Utils.isEmpty((CharSequence)((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().get(0).getLabelField())) {
                ((Neo4JOutputData)this.data).toOperationType = OperationType.NONE;
            }
            if (StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getRelationship()) && StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getRelationshipValue())) {
                ((Neo4JOutputData)this.data).relOperationType = OperationType.NONE;
            }
            if (((Neo4JOutputMeta)this.meta).isReturningGraph()) {
                this.logBasic("Writing to output graph field, not to Neo4j");
            } else {
                ((Neo4JOutputData)this.data).driver = ((Neo4JOutputData)this.data).neoConnection.getDriver(this.getLogChannel(), (IVariables)this);
                ((Neo4JOutputData)this.data).session = ((Neo4JOutputData)this.data).neoConnection.getSession(this.getLogChannel(), ((Neo4JOutputData)this.data).driver, (IVariables)this);
                if (((Neo4JOutputMeta)this.meta).isCreatingIndexes()) {
                    try {
                        this.createNodePropertyIndexes((Neo4JOutputMeta)this.meta, (Neo4JOutputData)this.data, this.getInputRowMeta(), row);
                    }
                    catch (HopException e) {
                        this.logError("Unable to create indexes", e);
                        return false;
                    }
                }
            }
            this.validateConfiguration();
        }
        if (((Neo4JOutputMeta)this.meta).isReturningGraph()) {
            this.outputGraphValue(this.getInputRowMeta(), row);
        } else {
            boolean changedLabel = this.calculateLabelsAndDetectChanges(row);
            if (changedLabel || (long)((Neo4JOutputData)this.data).unwindList.size() >= ((Neo4JOutputData)this.data).batchSize) {
                this.emptyUnwindList();
            }
            HashMap<String, Object> propsMap = new HashMap<String, Object>();
            if (((Neo4JOutputData)this.data).fromOperationType != OperationType.NONE) {
                this.addPropertiesToMap(propsMap, ((Neo4JOutputData)this.data).fromNodePropIndexes, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).fromNodePropTypes);
            }
            if (((Neo4JOutputData)this.data).toOperationType != OperationType.NONE) {
                this.addPropertiesToMap(propsMap, ((Neo4JOutputData)this.data).toNodePropIndexes, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).toNodePropTypes);
            }
            if (((Neo4JOutputData)this.data).relOperationType != OperationType.NONE) {
                this.addPropertiesToMap(propsMap, ((Neo4JOutputData)this.data).relPropIndexes, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).relPropTypes);
            }
            ((Neo4JOutputData)this.data).unwindList.add(propsMap);
            this.putRow(((Neo4JOutputData)this.data).outputRowMeta, row);
            ((Neo4JOutputData)this.data).previousFromLabelsClause = ((Neo4JOutputData)this.data).fromLabelsClause;
            ((Neo4JOutputData)this.data).previousToLabelsClause = ((Neo4JOutputData)this.data).toLabelsClause;
            ((Neo4JOutputData)this.data).previousRelationshipLabel = ((Neo4JOutputData)this.data).relationshipLabel;
        }
        return true;
    }

    private void validateConfiguration() throws HopException {
        boolean hasRelationship;
        boolean hasFromNode = !((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().isEmpty();
        boolean hasToNode = !((Neo4JOutputMeta)this.meta).getNodeToField().getLabels().isEmpty();
        boolean bl = hasRelationship = StringUtils.isNotEmpty((String)((Neo4JOutputMeta)this.meta).getRelationship()) || StringUtils.isNotEmpty((String)((Neo4JOutputMeta)this.meta).getRelationshipValue());
        if (hasRelationship) {
            if (!hasFromNode || !hasToNode) {
                throw new HopException("Please specify both nodes to be able to update relationships");
            }
            boolean noFromKey = true;
            for (PropertyField propertyField : ((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties()) {
                if (!propertyField.isPropertyPrimary()) continue;
                noFromKey = false;
                break;
            }
            if (noFromKey) {
                throw new HopException("Please specify at least one or more primary key properties in the 'from' node");
            }
            boolean noToKey = true;
            for (PropertyField propertyField : ((Neo4JOutputMeta)this.meta).getNodeToField().getProperties()) {
                if (!propertyField.isPropertyPrimary()) continue;
                noToKey = false;
                break;
            }
            if (noToKey) {
                throw new HopException("Please specify at least one or more primary key properties in the 'to' node");
            }
        }
    }

    private void addPropertiesToMap(Map<String, Object> rowMap, int[] nodePropIndexes, IRowMeta rowMeta, Object[] row, GraphPropertyType[] propertyTypes) throws HopValueException {
        for (int i = 0; i < nodePropIndexes.length; ++i) {
            Object neoValue;
            IValueMeta valueMeta = rowMeta.getValueMeta(nodePropIndexes[i]);
            Object valueData = row[nodePropIndexes[i]];
            GraphPropertyType propertyType = propertyTypes[i];
            if (propertyType == GraphPropertyType.Array) {
                String separator = this.resolve(Const.NVL((String)((Neo4JOutputMeta)this.meta).getArraySeparator(), (String)","));
                String enclosure = this.resolve(Const.NVL((String)((Neo4JOutputMeta)this.meta).getArrayEnclosure(), (String)""));
                neoValue = propertyType.convertFromHop(valueMeta, valueData, separator, enclosure);
            } else {
                neoValue = propertyType.convertFromHop(valueMeta, valueData);
            }
            String propName = "p" + nodePropIndexes[i];
            rowMap.put(propName, neoValue);
        }
    }

    private void emptyUnwindList() throws HopException {
        try {
            Map<String, List<Map<String, Object>>> properties = Collections.singletonMap("props", ((Neo4JOutputData)this.data).unwindList);
            StringBuilder cypher = new StringBuilder();
            cypher.append("UNWIND $props as pr ").append(Const.CR);
            String fromLabelClause = ((Neo4JOutputData)this.data).previousFromLabelsClause;
            String fromMatchClause = this.getMatchClause(((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties(), ((Neo4JOutputData)this.data).fromNodePropIndexes);
            switch (((Neo4JOutputData)this.data).fromOperationType) {
                case NONE: {
                    break;
                }
                case CREATE: {
                    cypher.append("CREATE( ").append(fromLabelClause).append(" ").append(fromMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("f", ((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties(), ((Neo4JOutputData)this.data).fromNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).fromLabels, GraphUsage.NODE_CREATE);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE( ").append(fromLabelClause).append(" ").append(fromMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("f", ((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties(), ((Neo4JOutputData)this.data).fromNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).fromLabels, GraphUsage.NODE_UPDATE);
                    break;
                }
                case MATCH: {
                    cypher.append("MATCH( ").append(fromLabelClause).append(" ").append(fromMatchClause).append(") ").append(Const.CR);
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_READ);
                    break;
                }
                default: {
                    throw new HopException("Unsupported operation type for the 'from' node: " + String.valueOf((Object)((Neo4JOutputData)this.data).fromOperationType));
                }
            }
            String toLabelsClause = ((Neo4JOutputData)this.data).previousToLabelsClause;
            String toMatchClause = this.getMatchClause(((Neo4JOutputMeta)this.meta).getNodeToField().getProperties(), ((Neo4JOutputData)this.data).toNodePropIndexes);
            switch (((Neo4JOutputData)this.data).toOperationType) {
                case NONE: {
                    break;
                }
                case CREATE: {
                    cypher.append("CREATE( ").append(toLabelsClause).append(" ").append(toMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("t", ((Neo4JOutputMeta)this.meta).getNodeToField().getProperties(), ((Neo4JOutputData)this.data).toNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_CREATE);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE( ").append(toLabelsClause).append(" ").append(toMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("t", ((Neo4JOutputMeta)this.meta).getNodeToField().getProperties(), ((Neo4JOutputData)this.data).toNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_UPDATE);
                    break;
                }
                case MATCH: {
                    cypher.append("MATCH( ").append(toLabelsClause).append(" ").append(toMatchClause).append(") ").append(Const.CR);
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_READ);
                    break;
                }
                default: {
                    throw new HopException("Unsupported operation type for the 'to' node: " + String.valueOf((Object)((Neo4JOutputData)this.data).toOperationType));
                }
            }
            String relationshipLabelToUse = ((Neo4JOutputData)this.data).previousRelationshipLabel != null ? ((Neo4JOutputData)this.data).previousRelationshipLabel : ((Neo4JOutputData)this.data).relationshipLabel;
            String relationshipSetClause = this.getSetClause("r", ((Neo4JOutputMeta)this.meta).getRelProps(), ((Neo4JOutputData)this.data).relPropIndexes);
            switch (((Neo4JOutputData)this.data).relOperationType) {
                case NONE: {
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE (f)-[").append("r:").append(relationshipLabelToUse).append("]->(t) ").append(Const.CR).append(relationshipSetClause).append(Const.CR);
                    this.updateUsageMap(List.of(relationshipLabelToUse), GraphUsage.RELATIONSHIP_UPDATE);
                    break;
                }
                case CREATE: {
                    cypher.append("CREATE (f)-[").append("r:").append(relationshipLabelToUse).append("]->(t) ").append(Const.CR).append(this.getSetClause("r", ((Neo4JOutputMeta)this.meta).getRelProps(), ((Neo4JOutputData)this.data).relPropIndexes)).append(Const.CR);
                    this.updateUsageMap(List.of(relationshipLabelToUse), GraphUsage.RELATIONSHIP_CREATE);
                    break;
                }
            }
            ((Neo4JOutputData)this.data).cypher = cypher.toString();
            if (this.isDebug()) {
                this.logDebug("Running Cypher: " + ((Neo4JOutputData)this.data).cypher);
                this.logDebug("properties list size : " + ((Neo4JOutputData)this.data).unwindList.size());
            }
            ((Neo4JOutputData)this.data).session.executeWrite(tx -> {
                Result result = tx.run(((Neo4JOutputData)this.data).cypher, properties);
                try {
                    this.processSummary(result);
                }
                catch (HopException e) {
                    throw new RuntimeException("Error processing result summary", e);
                }
                return null;
            });
            this.setLinesOutput(this.getLinesOutput() + (long)((Neo4JOutputData)this.data).unwindList.size());
            ((Neo4JOutputData)this.data).unwindList.clear();
        }
        catch (Exception e) {
            throw new HopException("Error writing unwind statement to Neo4j", (Throwable)e);
        }
    }

    private String getMatchClause(List<PropertyField> nodePropertyFields, int[] nodePropIndexes) {
        StringBuilder clause = new StringBuilder();
        for (int i = 0; i < nodePropertyFields.size(); ++i) {
            if (!nodePropertyFields.get(i).isPropertyPrimary()) continue;
            if (!clause.isEmpty()) {
                clause.append(", ");
            }
            clause.append(nodePropertyFields.get(i).getPropertyName()).append(": pr.p").append(nodePropIndexes[i]);
        }
        if (clause.isEmpty()) {
            return "";
        }
        return "{ " + String.valueOf(clause) + " }";
    }

    private String getSetClause(String alias, List<PropertyField> propertyFields, int[] nodePropIndexes) {
        StringBuilder clause = new StringBuilder();
        for (int i = 0; i < propertyFields.size(); ++i) {
            if (propertyFields.get(i).isPropertyPrimary()) continue;
            if (!clause.isEmpty()) {
                clause.append(", ");
            }
            clause.append(alias).append(".").append(propertyFields.get(i).getPropertyName()).append("= pr.p").append(nodePropIndexes[i]);
        }
        if (clause.isEmpty()) {
            return "";
        }
        return "SET " + String.valueOf(clause);
    }

    private boolean calculateLabelsAndDetectChanges(Object[] row) throws HopException {
        boolean changedLabel = false;
        if (((Neo4JOutputData)this.data).fromOperationType != OperationType.NONE) {
            if (((Neo4JOutputData)this.data).fromLabelsClause == null || ((Neo4JOutputData)this.data).dynamicFromLabels) {
                List<String> fLabels = this.getNodeLabels(((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels(), this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).fromNodeLabelIndexes);
                ((Neo4JOutputData)this.data).fromLabelsClause = this.getLabels("f", fLabels);
            }
            if (((Neo4JOutputData)this.data).dynamicFromLabels && ((Neo4JOutputData)this.data).previousFromLabelsClause != null && ((Neo4JOutputData)this.data).fromLabelsClause != null && !((Neo4JOutputData)this.data).fromLabelsClause.equals(((Neo4JOutputData)this.data).previousFromLabelsClause)) {
                changedLabel = true;
            }
        }
        if (((Neo4JOutputData)this.data).toOperationType != OperationType.NONE) {
            if ((((Neo4JOutputData)this.data).toLabelsClause == null || ((Neo4JOutputData)this.data).dynamicToLabels) && ((Neo4JOutputData)this.data).toNodeLabelIndexes.length > 0) {
                List<String> tLabels = this.getNodeLabels(((Neo4JOutputMeta)this.meta).getNodeToField().getLabels(), this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).toNodeLabelIndexes);
                ((Neo4JOutputData)this.data).toLabelsClause = this.getLabels("t", tLabels);
            }
            if (((Neo4JOutputData)this.data).dynamicToLabels && ((Neo4JOutputData)this.data).previousToLabelsClause != null && ((Neo4JOutputData)this.data).toLabelsClause != null && !((Neo4JOutputData)this.data).toLabelsClause.equals(((Neo4JOutputData)this.data).previousToLabelsClause)) {
                changedLabel = true;
            }
        }
        if (((Neo4JOutputData)this.data).relOperationType != OperationType.NONE) {
            if (((Neo4JOutputData)this.data).dynamicRelLabel) {
                ((Neo4JOutputData)this.data).relationshipLabel = this.getInputRowMeta().getString(row, ((Neo4JOutputData)this.data).relationshipIndex);
            }
            if (StringUtils.isEmpty((String)((Neo4JOutputData)this.data).relationshipLabel) && StringUtils.isNotEmpty((String)((Neo4JOutputData)this.data).relationshipLabelValue)) {
                ((Neo4JOutputData)this.data).relationshipLabel = ((Neo4JOutputData)this.data).relationshipLabelValue;
            }
            if (((Neo4JOutputData)this.data).dynamicRelLabel && ((Neo4JOutputData)this.data).previousRelationshipLabel != null && ((Neo4JOutputData)this.data).relationshipLabel != null && !((Neo4JOutputData)this.data).relationshipLabel.equals(((Neo4JOutputData)this.data).previousRelationshipLabel)) {
                changedLabel = true;
            }
        }
        return changedLabel;
    }

    private boolean determineDynamicLabels(List<LabelField> nodeLabelFields) {
        for (LabelField nodeLabelField : nodeLabelFields) {
            if (!StringUtils.isNotEmpty((String)nodeLabelField.getLabelField())) continue;
            return true;
        }
        return false;
    }

    private void outputGraphValue(IRowMeta rowMeta, Object[] row) throws HopException {
        try {
            GraphData graphData = new GraphData();
            graphData.setSourcePipelineName(this.getPipelineMeta().getName());
            graphData.setSourceTransformName(this.getTransformMeta().getName());
            GraphNodeData sourceNodeData = null;
            GraphNodeData targetNodeData = null;
            if (!((Neo4JOutputMeta)this.meta).getNodeFromField().getProperties().isEmpty()) {
                sourceNodeData = this.createGraphNodeData(rowMeta, row, ((Neo4JOutputMeta)this.meta).getNodeFromField(), "from");
                if (!((Neo4JOutputMeta)this.meta).isOnlyCreatingRelationships()) {
                    graphData.getNodes().add(sourceNodeData);
                }
            }
            if (!((Neo4JOutputMeta)this.meta).getNodeToField().getProperties().isEmpty()) {
                targetNodeData = this.createGraphNodeData(rowMeta, row, ((Neo4JOutputMeta)this.meta).getNodeToField(), "to");
                if (!((Neo4JOutputMeta)this.meta).isOnlyCreatingRelationships()) {
                    graphData.getNodes().add(targetNodeData);
                }
            }
            String relationshipLabel = null;
            if (((Neo4JOutputData)this.data).relationshipIndex >= 0) {
                relationshipLabel = this.getInputRowMeta().getString(row, ((Neo4JOutputData)this.data).relationshipIndex);
            }
            if (StringUtil.isEmpty(relationshipLabel) && StringUtils.isNotEmpty((String)((Neo4JOutputData)this.data).relationshipLabelValue)) {
                relationshipLabel = ((Neo4JOutputData)this.data).relationshipLabelValue;
            }
            if (sourceNodeData != null && targetNodeData != null && StringUtils.isNotEmpty((String)relationshipLabel)) {
                GraphRelationshipData relationshipData = new GraphRelationshipData();
                relationshipData.setSourceNodeId(sourceNodeData.getId());
                relationshipData.setTargetNodeId(targetNodeData.getId());
                relationshipData.setLabel(relationshipLabel);
                relationshipData.setId(sourceNodeData.getId() + " -> " + targetNodeData.getId());
                relationshipData.setPropertySetId("relationship");
                for (int i = 0; i < ((Neo4JOutputData)this.data).relPropIndexes.length; ++i) {
                    GraphPropertyDataType propertyType;
                    Object propertyNeoValue;
                    IValueMeta valueMeta = rowMeta.getValueMeta(((Neo4JOutputData)this.data).relPropIndexes[i]);
                    Object valueData = row[((Neo4JOutputData)this.data).relPropIndexes[i]];
                    String propertyName = ((Neo4JOutputMeta)this.meta).getRelProps().get(i).getPropertyName();
                    GraphPropertyType userSelectedType = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getRelProps().get(i).getPropertyType());
                    if (userSelectedType == GraphPropertyType.Array) {
                        String separator = this.resolve(Const.NVL((String)((Neo4JOutputMeta)this.meta).getArraySeparator(), (String)","));
                        String enclosure = this.resolve(Const.NVL((String)((Neo4JOutputMeta)this.meta).getArrayEnclosure(), (String)""));
                        propertyNeoValue = userSelectedType.convertFromHop(valueMeta, valueData, separator, enclosure);
                        propertyType = GraphPropertyDataType.List;
                    } else {
                        propertyType = this.convertGraphPropertyTypeToDataType(userSelectedType);
                        propertyNeoValue = propertyType.convertFromHop(valueMeta, valueData);
                    }
                    boolean propertyPrimary = false;
                    relationshipData.getProperties().add(new GraphPropertyData(propertyName, propertyNeoValue, propertyType, propertyPrimary));
                }
                graphData.getRelationships().add(relationshipData);
            }
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])row, (int)((Neo4JOutputData)this.data).outputRowMeta.size());
            outputRowData[rowMeta.size()] = graphData;
            this.putRow(((Neo4JOutputData)this.data).outputRowMeta, outputRowData);
        }
        catch (Exception e) {
            throw new HopException("Unable to calculate graph output value", (Throwable)e);
        }
    }

    private GraphNodeData createGraphNodeData(IRowMeta rowMeta, Object[] row, NodeField nodeField, String propertySetId) throws HopException {
        GraphNodeData nodeData = new GraphNodeData();
        nodeData.setPropertySetId(propertySetId);
        List<String> labels = this.getNodeLabels(nodeField.getLabels(), rowMeta, row, new int[((Neo4JOutputMeta)this.meta).getNodeFromField().getLabels().size()]);
        for (String label : labels) {
            nodeData.getLabels().add(label);
        }
        StringBuilder nodeId = new StringBuilder();
        for (int i = 0; i < nodeField.getProperties().size(); ++i) {
            GraphPropertyDataType propertyType;
            Object propertyNeoValue;
            PropertyField propertyField = nodeField.getProperties().get(i);
            String propertyValue = propertyField.getPropertyValue();
            int fieldIndex = rowMeta.indexOfValue(propertyValue);
            if (fieldIndex < 0) {
                throw new HopException("Unable to find field '" + propertyValue + "' in input row for node property '" + propertyField.getPropertyName() + "'");
            }
            IValueMeta valueMeta = rowMeta.getValueMeta(fieldIndex);
            Object valueData = row[fieldIndex];
            String propertyName = propertyField.getPropertyName();
            GraphPropertyType userSelectedType = GraphPropertyType.parseCode(propertyField.getPropertyType());
            if (userSelectedType == GraphPropertyType.Array) {
                String separator = this.resolve(Const.NVL((String)((Neo4JOutputMeta)this.meta).getArraySeparator(), (String)","));
                String enclosure = this.resolve(Const.NVL((String)((Neo4JOutputMeta)this.meta).getArrayEnclosure(), (String)""));
                propertyNeoValue = userSelectedType.convertFromHop(valueMeta, valueData, separator, enclosure);
                propertyType = GraphPropertyDataType.List;
            } else {
                propertyType = this.convertGraphPropertyTypeToDataType(userSelectedType);
                propertyNeoValue = propertyType.convertFromHop(valueMeta, valueData);
            }
            boolean propertyPrimary = propertyField.isPropertyPrimary();
            nodeData.getProperties().add(new GraphPropertyData(propertyName, propertyNeoValue, propertyType, propertyPrimary));
            if (!propertyPrimary) continue;
            if (!nodeId.isEmpty()) {
                nodeId.append("-");
            }
            nodeId.append(valueMeta.getString(valueData));
        }
        if (!nodeId.isEmpty()) {
            nodeData.setId(nodeId.toString());
        }
        return nodeData;
    }

    @Override
    public boolean init() {
        if (!((Neo4JOutputMeta)this.meta).isReturningGraph()) {
            if (StringUtils.isEmpty((String)this.resolve(((Neo4JOutputMeta)this.meta).getConnection()))) {
                this.logError("You need to specify a Neo4j connection to use in this transform");
                return false;
            }
            try {
                ((Neo4JOutputData)this.data).neoConnection = (NeoConnection)this.metadataProvider.getSerializer(NeoConnection.class).load(this.resolve(((Neo4JOutputMeta)this.meta).getConnection()));
                if (((Neo4JOutputData)this.data).neoConnection == null) {
                    this.logError("Connection '" + this.resolve(((Neo4JOutputMeta)this.meta).getConnection()) + "' could not be found in the metastore : " + this.metadataProvider.getDescription());
                    return false;
                }
            }
            catch (HopException e) {
                this.logError("Could not gencsv Neo4j connection '" + this.resolve(((Neo4JOutputMeta)this.meta).getConnection()) + "' from the metastore", e);
                return false;
            }
            ((Neo4JOutputData)this.data).batchSize = Const.toLong((String)this.resolve(((Neo4JOutputMeta)this.meta).getBatchSize()), (long)1L);
        }
        return super.init();
    }

    @Override
    public void dispose() {
        if (!this.isStopped()) {
            try {
                this.wrapUpTransaction();
            }
            catch (HopException e) {
                this.logError("Error wrapping up transaction", e);
                this.setErrors(1L);
                this.stopAll();
            }
        }
        if (((Neo4JOutputData)this.data).session != null) {
            ((Neo4JOutputData)this.data).session.close();
        }
        if (((Neo4JOutputData)this.data).driver != null) {
            ((Neo4JOutputData)this.data).driver.close();
        }
        super.dispose();
    }

    private String getLabels(String nodeAlias, List<String> nodeLabels) {
        if (nodeLabels.isEmpty()) {
            return null;
        }
        StringBuilder labels = new StringBuilder(nodeAlias);
        for (String nodeLabel : nodeLabels) {
            labels.append(":");
            labels.append(this.escapeLabel(nodeLabel));
        }
        return labels.toString();
    }

    private void processSummary(Result result) throws HopException {
        boolean error = false;
        ResultSummary summary = result.consume();
        for (Notification notification : summary.notifications()) {
            this.logError(notification.title() + " (" + notification.severity() + ")");
            this.logError(notification.code() + " : " + notification.description() + ", position " + String.valueOf(notification.position()));
            error = true;
        }
        if (error) {
            throw new HopException("Error found while executing cypher statement(s)");
        }
    }

    public List<String> getNodeLabels(List<LabelField> labelFields, IRowMeta rowMeta, Object[] rowData, int[] labelIndexes) throws HopValueException {
        ArrayList<String> labels = new ArrayList<String>();
        for (int a = 0; a < labelFields.size(); ++a) {
            String label = null;
            if (StringUtils.isNotEmpty((String)labelFields.get(a).getLabelField())) {
                label = rowMeta.getString(rowData, labelIndexes[a]);
            }
            if (StringUtils.isEmpty(label) && StringUtils.isNotEmpty((String)labelFields.get(a).getLabel())) {
                label = labelFields.get(a).getLabel();
            }
            if (!StringUtils.isNotEmpty(label)) continue;
            labels.add(label);
        }
        return labels;
    }

    public String escapeLabel(String str) {
        if (((String)str).contains(" ") || ((String)str).contains(".")) {
            str = "`" + (String)str + "`";
        }
        return str;
    }

    private void createNodePropertyIndexes(Neo4JOutputMeta meta, Neo4JOutputData data, IRowMeta rowMeta, Object[] rowData) throws HopException {
        if (this.getCopy() != 0) {
            return;
        }
        this.createIndexForNode(data, meta.getNodeFromField(), rowMeta, rowData);
        this.createIndexForNode(data, meta.getNodeToField(), rowMeta, rowData);
    }

    private void createIndexForNode(Neo4JOutputData data, NodeField theNode, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        HashSet<String> labels = new HashSet<String>();
        for (LabelField labelField : theNode.getLabels()) {
            String label;
            if (!Utils.isEmpty((CharSequence)labelField.getLabel())) {
                labels.add(labelField.getLabel());
            }
            if (Utils.isEmpty((CharSequence)labelField.getLabelField()) || !StringUtils.isNotEmpty((String)(label = rowMeta.getString(rowData, labelField.getLabelField(), null)))) continue;
            labels.add(label);
        }
        for (String label : labels) {
            ArrayList<String> primaryProperties = new ArrayList<String>();
            for (int f = 0; f < theNode.getProperties().size(); ++f) {
                if (!theNode.getProperties().get(f).isPropertyPrimary()) continue;
                if (StringUtils.isNotEmpty((String)theNode.getProperties().get(f).getPropertyName())) {
                    primaryProperties.add(theNode.getProperties().get(f).getPropertyName());
                    continue;
                }
                primaryProperties.add(theNode.getProperties().get(f).getPropertyValue());
            }
            if (label == null || primaryProperties.isEmpty()) continue;
            NeoConnectionUtils.createNodeIndex(this.getLogChannel(), data.session, Collections.singletonList(label), primaryProperties);
        }
    }

    public void batchComplete() throws HopException {
        this.wrapUpTransaction();
    }

    private void wrapUpTransaction() throws HopException {
        if (!this.isStopped() && !Utils.isEmpty(((Neo4JOutputData)this.data).unwindList)) {
            this.emptyUnwindList();
        }
        ((Neo4JOutputData)this.data).unwindList = new ArrayList<Map<String, Object>>();
    }

    protected void updateUsageMap(List<String> labels, GraphUsage usage) {
        if (labels == null) {
            return;
        }
        Map transformsMap = ((Neo4JOutputData)this.data).usageMap.computeIfAbsent(usage.name(), k -> new HashMap());
        Set labelSet = transformsMap.computeIfAbsent(this.getTransformName(), k -> new HashSet());
        for (String label : labels) {
            if (!StringUtils.isNotEmpty((String)label)) continue;
            labelSet.add(label);
        }
    }

    public static String generatePreviewCypher(Neo4JOutputMeta meta, IVariables variables) {
        StringBuilder cypher = new StringBuilder();
        cypher.append("-- Generated Cypher template (batch processing with UNWIND)").append(Const.CR);
        cypher.append("-- Note: Actual values come from input rows via $props parameter").append(Const.CR);
        cypher.append(Const.CR);
        cypher.append("UNWIND $props as pr").append(Const.CR);
        cypher.append(Const.CR);
        OperationType fromOpType = OperationType.NONE;
        OperationType toOpType = OperationType.NONE;
        OperationType relOpType = OperationType.NONE;
        if (!meta.getNodeFromField().getLabels().isEmpty()) {
            OperationType operationType = fromOpType = meta.isUsingCreate() ? OperationType.CREATE : OperationType.MERGE;
        }
        if (!(meta.getNodeToField().getLabels().isEmpty() || Utils.isEmpty((CharSequence)meta.getNodeToField().getLabels().get(0).getLabel()) && Utils.isEmpty((CharSequence)meta.getNodeToField().getLabels().get(0).getLabelField()))) {
            OperationType operationType = toOpType = meta.isUsingCreate() ? OperationType.CREATE : OperationType.MERGE;
        }
        if (StringUtils.isNotEmpty((String)meta.getRelationship()) || StringUtils.isNotEmpty((String)meta.getRelationshipValue())) {
            OperationType operationType = relOpType = meta.isUsingCreate() ? OperationType.CREATE : OperationType.MERGE;
        }
        if (fromOpType != OperationType.NONE) {
            String fromLabelsClause = Neo4JOutput.buildPreviewLabelsClause("f", meta.getNodeFromField().getLabels(), variables);
            String fromMatchClause = Neo4JOutput.buildPreviewMatchClause(meta.getNodeFromField().getProperties());
            switch (fromOpType) {
                case CREATE: {
                    cypher.append("CREATE (").append(fromLabelsClause);
                    if (StringUtils.isNotEmpty((String)fromMatchClause)) {
                        cypher.append(" ").append(fromMatchClause);
                    }
                    cypher.append(")").append(Const.CR);
                    String fromSetClause = Neo4JOutput.buildPreviewSetClause("f", meta.getNodeFromField().getProperties());
                    if (!StringUtils.isNotEmpty((String)fromSetClause)) break;
                    cypher.append(fromSetClause).append(Const.CR);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE (").append(fromLabelsClause);
                    if (StringUtils.isNotEmpty((String)fromMatchClause)) {
                        cypher.append(" ").append(fromMatchClause);
                    }
                    cypher.append(")").append(Const.CR);
                    String fromSetClause = Neo4JOutput.buildPreviewSetClause("f", meta.getNodeFromField().getProperties());
                    if (!StringUtils.isNotEmpty((String)fromSetClause)) break;
                    cypher.append(fromSetClause).append(Const.CR);
                    break;
                }
            }
        }
        if (toOpType != OperationType.NONE) {
            String toLabelsClause = Neo4JOutput.buildPreviewLabelsClause("t", meta.getNodeToField().getLabels(), variables);
            String toMatchClause = Neo4JOutput.buildPreviewMatchClause(meta.getNodeToField().getProperties());
            switch (toOpType) {
                case CREATE: {
                    cypher.append("CREATE (").append(toLabelsClause);
                    if (StringUtils.isNotEmpty((String)toMatchClause)) {
                        cypher.append(" ").append(toMatchClause);
                    }
                    cypher.append(")").append(Const.CR);
                    String toSetClause = Neo4JOutput.buildPreviewSetClause("t", meta.getNodeToField().getProperties());
                    if (!StringUtils.isNotEmpty((String)toSetClause)) break;
                    cypher.append(toSetClause).append(Const.CR);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE (").append(toLabelsClause);
                    if (StringUtils.isNotEmpty((String)toMatchClause)) {
                        cypher.append(" ").append(toMatchClause);
                    }
                    cypher.append(")").append(Const.CR);
                    String toSetClause = Neo4JOutput.buildPreviewSetClause("t", meta.getNodeToField().getProperties());
                    if (!StringUtils.isNotEmpty((String)toSetClause)) break;
                    cypher.append(toSetClause).append(Const.CR);
                    break;
                }
            }
        }
        if (relOpType != OperationType.NONE) {
            Object relLabel = variables.resolve(meta.getRelationshipValue());
            if (StringUtils.isEmpty((String)relLabel) && StringUtils.isNotEmpty((String)meta.getRelationship())) {
                relLabel = "${" + meta.getRelationship() + "}";
            }
            if (StringUtils.isEmpty((String)relLabel)) {
                relLabel = "RELATES_TO";
            }
            String relSetClause = Neo4JOutput.buildPreviewSetClause("r", meta.getRelProps());
            switch (relOpType) {
                case CREATE: {
                    cypher.append("CREATE (f)-[r:").append((String)relLabel).append("]->(t)").append(Const.CR);
                    if (!StringUtils.isNotEmpty((String)relSetClause)) break;
                    cypher.append(relSetClause).append(Const.CR);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE (f)-[r:").append((String)relLabel).append("]->(t)").append(Const.CR);
                    if (!StringUtils.isNotEmpty((String)relSetClause)) break;
                    cypher.append(relSetClause).append(Const.CR);
                    break;
                }
            }
        }
        return cypher.toString();
    }

    private static String buildPreviewLabelsClause(String alias, List<LabelField> labelFields, IVariables variables) {
        if (labelFields.isEmpty()) {
            return alias;
        }
        StringBuilder labels = new StringBuilder(alias);
        for (LabelField labelField : labelFields) {
            String label = variables.resolve(labelField.getLabel());
            if (StringUtils.isEmpty((String)label) && StringUtils.isNotEmpty((String)labelField.getLabelField())) {
                labels.append(":${").append(labelField.getLabelField()).append("}");
                continue;
            }
            if (StringUtils.isNotEmpty((String)label)) {
                labels.append(":").append(Neo4JOutput.escapeLabelForPreview(label));
                continue;
            }
            labels.append(":Label");
        }
        return labels.toString();
    }

    private static String escapeLabelForPreview(String label) {
        if (label.contains(" ") || label.contains("-") || label.contains(".")) {
            return "`" + label + "`";
        }
        return label;
    }

    private static String buildPreviewMatchClause(List<PropertyField> propertyFields) {
        StringBuilder clause = new StringBuilder();
        for (PropertyField propertyField : propertyFields) {
            if (!propertyField.isPropertyPrimary()) continue;
            if (!clause.isEmpty()) {
                clause.append(", ");
            }
            clause.append(propertyField.getPropertyName()).append(": pr.p").append(propertyField.getPropertyValue());
        }
        if (clause.isEmpty()) {
            return "";
        }
        return "{ " + String.valueOf(clause) + " }";
    }

    private static String buildPreviewSetClause(String alias, List<PropertyField> propertyFields) {
        StringBuilder clause = new StringBuilder();
        for (PropertyField propertyField : propertyFields) {
            if (propertyField.isPropertyPrimary()) continue;
            if (!clause.isEmpty()) {
                clause.append(", ");
            }
            clause.append(alias).append(".").append(propertyField.getPropertyName()).append(" = pr.p").append(propertyField.getPropertyValue());
        }
        if (clause.isEmpty()) {
            return "";
        }
        return "SET " + String.valueOf(clause);
    }

    private GraphPropertyDataType convertGraphPropertyTypeToDataType(GraphPropertyType graphPropertyType) {
        return switch (graphPropertyType) {
            case GraphPropertyType.String -> GraphPropertyDataType.String;
            case GraphPropertyType.Integer -> GraphPropertyDataType.Integer;
            case GraphPropertyType.Float -> GraphPropertyDataType.Float;
            case GraphPropertyType.Boolean -> GraphPropertyDataType.Boolean;
            case GraphPropertyType.Date -> GraphPropertyDataType.Date;
            case GraphPropertyType.LocalDateTime -> GraphPropertyDataType.LocalDateTime;
            case GraphPropertyType.ByteArray -> GraphPropertyDataType.ByteArray;
            case GraphPropertyType.Time -> GraphPropertyDataType.Time;
            case GraphPropertyType.Point -> GraphPropertyDataType.Point;
            case GraphPropertyType.Duration -> GraphPropertyDataType.Duration;
            case GraphPropertyType.LocalTime -> GraphPropertyDataType.LocalTime;
            case GraphPropertyType.DateTime -> GraphPropertyDataType.DateTime;
            case GraphPropertyType.Array -> GraphPropertyDataType.List;
            default -> GraphPropertyDataType.String;
        };
    }
}

