/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.streaming.ParDoStateUpdateFn;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.TimerUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaMapWithStateDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class StatefulStreamingParDoEvaluator<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor OutputT>
implements TransformEvaluator<ParDo.MultiOutput<KV<KeyT, ValueT>, OutputT>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(StatefulStreamingParDoEvaluator.class);

    @Override
    public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
        DoFn doFn = transform.getFn();
        DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
        Preconditions.checkArgument((!signature.processElement().isSplittable() ? 1 : 0) != 0, (String)"Splittable DoFn not yet supported in streaming mode: %s", (Object)doFn);
        Preconditions.checkState((signature.onWindowExpiration() == null ? 1 : 0) != 0, (String)"onWindowExpiration is not supported: %s", (Object)doFn);
        SerializablePipelineOptions options = context.getSerializableOptions();
        SparkPCollectionView pviews = context.getPViews();
        WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
        KvCoder inputCoder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
        Map<TupleTag<?>, Coder<?>> outputCoders = context.getOutputCoders();
        UnboundedDataset unboundedDataset = (UnboundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform);
        Object dStream = unboundedDataset.getDStream();
        if (TranslationUtils.hasTimers(doFn)) {
            Preconditions.checkState((!TranslationUtils.hasEventTimers(doFn) ? 1 : 0) != 0, (String)"%s not yet supported in streaming mode: %s", (Object)TimeDomain.EVENT_TIME, (Object)doFn.getClass().getName());
            LOG.info("DoFn {} has timers. create periodic DStream for triggering timers", (Object)doFn);
            dStream = TimerUtils.toPeriodicDStream(dStream);
        }
        DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
        Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
        String stepName = context.getCurrentTransform().getFullName();
        WindowFn windowFn = windowingStrategy.getWindowFn();
        List<Integer> sourceIds = unboundedDataset.getStreamSources();
        Coder keyCoder = inputCoder.getKeyCoder();
        Coder valueCoder = inputCoder.getValueCoder();
        WindowedValues.FullWindowedValueCoder wvCoder = WindowedValues.FullWindowedValueCoder.of((Coder)valueCoder, (Coder)windowFn.windowCoder());
        MetricsContainerStepMapAccumulator metricsAccum = MetricsAccumulator.getInstance();
        Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = TranslationUtils.getSideInputs(transform.getSideInputs().values(), context.getSparkContext(), pviews);
        JavaPairDStream serializedDStream = dStream.mapPartitionsToPair((PairFlatMapFunction & Serializable)iter -> Iterators.transform((Iterator)iter, windowedKV -> {
            Object key = ((KV)windowedKV.getValue()).getKey();
            WindowedValue windowedValue = windowedKV.withValue(((KV)windowedKV.getValue()).getValue());
            ByteArray keyBytes = new ByteArray(CoderHelpers.toByteArray(key, keyCoder));
            byte[] valueBytes = TimerUtils.TIMER_MARKER.equals(windowedValue.getValue()) ? TimerUtils.EMPTY_BYTE_ARRAY : CoderHelpers.toByteArray(windowedValue, wvCoder);
            return Tuple2.apply((Object)keyBytes, (Object)valueBytes);
        }));
        Map<Integer, GlobalWatermarkHolder.SparkWatermarks> watermarks = GlobalWatermarkHolder.get(TranslationUtils.getBatchDuration(options));
        JavaMapWithStateDStream processedPairDStream = serializedDStream.mapWithState(StateSpec.function(new ParDoStateUpdateFn(metricsAccum, stepName, doFn, keyCoder, wvCoder, options, (TupleTag<?>)transform.getMainOutputTag(), transform.getAdditionalOutputTags().getAll(), inputCoder, outputCoders, sideInputs, (WindowingStrategy<?, ?>)windowingStrategy, doFnSchemaInformation, sideInputMapping, watermarks, sourceIds, context.isStreamingSideInput())));
        JavaPairDStream all = processedPairDStream.flatMapToPair((PairFlatMapFunction & Serializable)list -> Iterators.transform(list.iterator(), tuple -> {
            Coder outputCoder = (Coder)outputCoders.get(tuple._1());
            WindowedValue windowedValue = (WindowedValue)CoderHelpers.fromByteArray((byte[])tuple._2(), WindowedValues.FullWindowedValueCoder.of((Coder)outputCoder, (Coder)windowFn.windowCoder()));
            return Tuple2.apply((Object)((TupleTag)tuple._1()), (Object)windowedValue);
        }));
        Map<TupleTag<?>, PCollection<?>> outputs = context.getOutputs((PTransform<?, ?>)transform);
        if (this.hasMultipleOutputs(outputs)) {
            Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap = TranslationUtils.getTupleTagCoders(outputs);
            all = all.mapToPair(TranslationUtils.getTupleTagEncodeFunction(coderMap)).cache().mapToPair(TranslationUtils.getTupleTagDecodeFunction(coderMap));
            for (Map.Entry<TupleTag<?>, PCollection<?>> output : outputs.entrySet()) {
                JavaPairDStream filtered = all.filter(new TranslationUtils.TupleTagFilter(output.getKey()));
                JavaDStream values = TranslationUtils.dStreamValues(filtered);
                context.putDataset((PValue)output.getValue(), new UnboundedDataset(values, sourceIds));
            }
        } else {
            JavaDStream values = TranslationUtils.dStreamValues(all);
            context.putDataset((PValue)((Map.Entry)Iterables.getOnlyElement(outputs.entrySet())).getValue(), new UnboundedDataset(values, sourceIds));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
        return "mapPartitions(new <fn>())";
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasMultipleOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
        return outputs.size() > 1;
    }
}

