/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SideInputValues;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.spark.broadcast.Broadcast;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class SparkSideInputReader
implements SideInputReader,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized SideInputReader EMPTY_READER = new EmptyReader();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_MATERIALIZATIONS = ImmutableSet.of((Object)"beam:side_input:iterable:v1", (Object)"beam:side_input:multimap:v1");
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs;

    public static @UnknownKeyFor @NonNull @Initialized SideInputReader empty() {
        return EMPTY_READER;
    }

    public static @UnknownKeyFor @NonNull @Initialized SideInputReader create(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs) {
        return sideInputs.isEmpty() ? SparkSideInputReader.empty() : new SparkSideInputReader(sideInputs);
    }

    public static void validateMaterializations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views) {
        for (PCollectionView<?> view : views) {
            String viewUrn = view.getViewFn().getMaterialization().getUrn();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)SUPPORTED_MATERIALIZATIONS.contains(viewUrn), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", SUPPORTED_MATERIALIZATIONS, (Object)viewUrn, (Object)view.getTagInternal().getId());
        }
    }

    private SparkSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    private static <V, T> T iterableView(@UnknownKeyFor @NonNull @Initialized ViewFn<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Materializations.IterableView<V>, T> viewFn, @Nullable @UnknownKeyFor @Initialized List<V> values) {
        return (T)(values != null ? viewFn.apply(() -> values) : viewFn.apply(Collections::emptyList));
    }

    private static <K, V, T> T multimapView(@UnknownKeyFor @NonNull @Initialized ViewFn<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V>, T> viewFn, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<K, V>> values) {
        return (T)(values != null && !values.isEmpty() ? viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable(keyCoder, values)) : viewFn.apply((Object)InMemoryMultimapSideInputView.empty()));
    }

    @Pure
    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Broadcast broadcast = (Broadcast)Preconditions.checkStateNotNull(this.sideInputs.get(view.getTagInternal().getId()), (String)"View %s not available.", view);
        @Nullable List<KV<K, V>> values = ((SideInputValues)broadcast.value()).get(window);
        switch (view.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:iterable:v1": {
                return SparkSideInputReader.iterableView(view.getViewFn(), values);
            }
            case "beam:side_input:multimap:v1": {
                Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                return SparkSideInputReader.multimapView(view.getViewFn(), keyCoder, values);
            }
        }
        throw new IllegalStateException(String.format("Unknown materialization urn '%s'", view.getViewFn().getMaterialization().getUrn()));
    }

    @Pure
    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal().getId());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }

    private static class EmptyReader
    implements SideInputReader,
    Serializable {
        private EmptyReader() {
        }

        @Pure
        public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            throw new IllegalArgumentException("Cannot get view from empty SideInputReader");
        }

        @Pure
        public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
            return false;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return true;
        }
    }
}

