/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.TimedRow;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupData;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupMeta;

public class DefaultCache
implements DatabaseLookupData.ICache {
    private final DatabaseLookupData data;
    private final LinkedHashMap<RowMetaAndData, TimedRow> map;

    public static DefaultCache newCache(DatabaseLookupData data, int cacheSize) {
        cacheSize = cacheSize > 0 ? (int)((double)cacheSize * 1.5) : 16;
        return new DefaultCache(data, cacheSize);
    }

    DefaultCache(DatabaseLookupData data, int capacity) {
        this.data = data;
        this.map = new LinkedHashMap(capacity);
    }

    @Override
    public Object[] getRowFromCache(IRowMeta lookupMeta, Object[] lookupRow) throws HopException {
        if (this.data.allEquals) {
            TimedRow timedRow = this.map.get(new RowMetaAndData(this.data.lookupMeta, lookupRow));
            if (timedRow != null) {
                return timedRow.getRow();
            }
        } else if (!this.data.hasDBCondition) {
            for (RowMetaAndData key : this.map.keySet()) {
                TimedRow timedRow;
                boolean match = true;
                int lookupIndex = 0;
                for (int i = 0; i < this.data.conditions.length && match; ++i) {
                    IValueMeta cmpMeta = lookupMeta.getValueMeta(lookupIndex);
                    Object cmpData = lookupRow[lookupIndex];
                    IValueMeta keyMeta = key.getValueMeta(i);
                    Object keyData = key.getData()[i];
                    switch (this.data.conditions[i]) {
                        case 0: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) == 0;
                            break;
                        }
                        case 1: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) != 0;
                            break;
                        }
                        case 2: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) > 0;
                            break;
                        }
                        case 3: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) >= 0;
                            break;
                        }
                        case 4: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) < 0;
                            break;
                        }
                        case 5: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) <= 0;
                            break;
                        }
                        case 8: {
                            match = keyMeta.isNull(keyData);
                            break;
                        }
                        case 9: {
                            match = !keyMeta.isNull(keyData);
                            break;
                        }
                        case 7: {
                            IValueMeta cmpMeta2 = lookupMeta.getValueMeta(lookupIndex + 1);
                            Object cmpData2 = lookupRow[lookupIndex + 1];
                            boolean bl = match = keyMeta.compare(keyData, cmpMeta, cmpData) >= 0;
                            if (match) {
                                match = keyMeta.compare(keyData, cmpMeta2, cmpData2) <= 0;
                            }
                            ++lookupIndex;
                            break;
                        }
                        default: {
                            match = false;
                            this.data.hasDBCondition = true;
                        }
                    }
                    ++lookupIndex;
                }
                if (!match || (timedRow = this.map.get(key)) == null) continue;
                return timedRow.getRow();
            }
        }
        return null;
    }

    @Override
    public void storeRowInCache(DatabaseLookupMeta meta, IRowMeta lookupMeta, Object[] lookupRow, Object[] add) {
        RowMetaAndData rowMetaAndData = new RowMetaAndData(lookupMeta, lookupRow);
        this.map.put(rowMetaAndData, new TimedRow(add));
        if (!meta.isLoadingAllDataInCache() && meta.getCacheSize() > 0 && this.map.size() > meta.getCacheSize()) {
            ArrayList<RowMetaAndData> keys = new ArrayList<RowMetaAndData>(this.map.keySet());
            ArrayList<Date> samples = new ArrayList<Date>();
            int incr = keys.size() / 10;
            if (incr == 0) {
                incr = 1;
            }
            for (int k = 0; k < keys.size(); k += incr) {
                RowMetaAndData key = (RowMetaAndData)keys.get(k);
                TimedRow timedRow = this.map.get(key);
                samples.add(timedRow.getLogDate());
            }
            Collections.sort(samples);
            if (samples.size() > 1) {
                Date smallest = (Date)samples.get(1);
                for (RowMetaAndData key : keys) {
                    TimedRow timedRow = this.map.get(key);
                    if (timedRow.getLogDate().compareTo(smallest) >= 0) continue;
                    this.map.remove(key);
                }
            }
        }
    }
}

