/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.apple;

import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.makernotes.AppleRunTimeMakernoteDirectory;
import com.drew.metadata.plist.BplistReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AppleRunTimeReader {
    public void extract(@NotNull byte[] bytes, @NotNull Metadata metadata, @NotNull Directory parentDirectory) {
        if (!BplistReader.isValid(bytes)) {
            parentDirectory.addError("Input array is not a bplist");
            return;
        }
        AppleRunTimeMakernoteDirectory directory = new AppleRunTimeMakernoteDirectory();
        directory.setParent(parentDirectory);
        try {
            AppleRunTimeReader.processAppleRunTime(directory, bytes);
            if (directory.getTagCount() > 0) {
                metadata.addDirectory(directory);
            }
        }
        catch (IOException e) {
            parentDirectory.addError("Error processing TAG_RUN_TIME: " + e.getMessage());
        }
    }

    private static void processAppleRunTime(@NotNull AppleRunTimeMakernoteDirectory directory, @NotNull byte[] bplist) throws IOException {
        BplistReader.PropertyListResults results = BplistReader.parse(bplist);
        Set<Map.Entry<Byte, Byte>> entrySet = results.getEntrySet();
        if (entrySet != null) {
            byte flags;
            HashMap<String, Object> values = new HashMap<String, Object>(entrySet.size());
            for (Map.Entry<Byte, Byte> entry : entrySet) {
                String key = (String)results.getObjects().get(entry.getKey().byteValue());
                Object value = results.getObjects().get(entry.getValue().byteValue());
                values.put(key, value);
            }
            Object flagsObject = values.get("flags");
            if (flagsObject instanceof Byte) {
                byte flags2 = (Byte)flagsObject;
                if ((flags2 & 1) == 1) {
                    directory.setInt(1, flags2);
                    directory.setInt(2, ((Byte)values.get("epoch")).byteValue());
                    directory.setLong(3, (Long)values.get("timescale"));
                    directory.setLong(4, (Long)values.get("value"));
                }
            } else if (flagsObject instanceof String && ((flags = Byte.parseByte((String)flagsObject)) & 1) == 1) {
                directory.setInt(1, flags);
                directory.setInt(2, Byte.parseByte((String)values.get("epoch")));
                directory.setLong(3, Long.parseLong((String)values.get("timescale")));
                directory.setLong(4, Long.parseLong((String)values.get("value")));
            }
        }
    }
}

