/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.csvinput;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.file.TextFileInputField;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transforms.common.ICsvInputAwareMeta;
import org.apache.hop.pipeline.transforms.csvinput.CsvInput;
import org.apache.hop.pipeline.transforms.csvinput.CsvInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.TextFileCSVImportProgressDialog;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.metadata.SchemaFieldDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.common.ICsvInputAwareImportProgressDialog;
import org.apache.hop.ui.pipeline.transform.common.ICsvInputAwareTransformDialog;
import org.apache.hop.ui.pipeline.transform.common.IGetFieldsCapableTransformDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CsvInputDialog
extends BaseTransformDialog
implements IGetFieldsCapableTransformDialog<CsvInputMeta>,
ICsvInputAwareTransformDialog {
    private static final Class<?> PKG = CsvInput.class;
    public static final String STRING_USAGE_INFO_PARAMETER = "UsageInfoParameter";
    private final CsvInputMeta inputMeta;
    private TextVar wFilename;
    private CCombo wFilenameField;
    private Button wbbFilename;
    private Button wIncludeFilename;
    private TextVar wRowNumField;
    private TextVar wDelimiter;
    private TextVar wEnclosure;
    private TextVar wBufferSize;
    private Button wLazyConversion;
    private Button wHeaderPresent;
    private TableView wFields;
    private Button wAddResult;
    private boolean isReceivingInput;
    private Button wRunningInParallel;
    private Button wNewlinePossible;
    private ComboVar wEncoding;
    private boolean gotEncodings = false;
    private Label wlRunningInParallel;
    private boolean initializing;
    private AtomicBoolean previewBusy;
    private MetaSelectionLine<SchemaDefinition> wSchemaDefinition;

    public CsvInputDialog(Shell parent, IVariables variables, CsvInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.inputMeta = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.inputMeta);
        ModifyListener lsMod = e -> this.inputMeta.setChanged();
        this.changed = this.inputMeta.hasChanged();
        ModifyListener lsContent = arg0 -> {};
        this.initializing = true;
        this.previewBusy = new AtomicBoolean(false);
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvInputDialog.this.fillFieldsLayoutFromSchema();
                CsvInputDialog.this.inputMeta.setChanged();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        boolean bl = this.isReceivingInput = !this.pipelineMeta.findPreviousTransforms(this.transformMeta).isEmpty();
        if (this.isReceivingInput) {
            IRowMeta previousFields;
            try {
                previousFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            }
            catch (HopTransformException e2) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorDialog.UnableToGetInputFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorDialog.UnableToGetInputFields.Message", (String[])new String[0]), (Exception)((Object)e2));
                previousFields = new RowMeta();
            }
            wlFilename = new Label((Composite)this.shell, 131072);
            wlFilename.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.FilenameField.Label", (String[])new String[0]));
            PropsUi.setLook((Widget)wlFilename);
            fdlFilename = new FormData();
            fdlFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlFilename.left = new FormAttachment(0, 0);
            fdlFilename.right = new FormAttachment(middle, -margin);
            wlFilename.setLayoutData((Object)fdlFilename);
            this.wFilenameField = new CCombo((Composite)this.shell, 18436);
            this.wFilenameField.setItems(previousFields.getFieldNames());
            PropsUi.setLook((Widget)this.wFilenameField);
            this.wFilenameField.addModifyListener(lsMod);
            fdFilename = new FormData();
            fdFilename.top = new FormAttachment((Control)lastControl, margin);
            fdFilename.left = new FormAttachment(middle, 0);
            fdFilename.right = new FormAttachment(100, 0);
            this.wFilenameField.setLayoutData((Object)fdFilename);
            lastControl = this.wFilenameField;
            Label wlIncludeFilename = new Label((Composite)this.shell, 131072);
            wlIncludeFilename.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.IncludeFilenameField.Label", (String[])new String[0]));
            PropsUi.setLook((Widget)wlIncludeFilename);
            FormData fdlIncludeFilename = new FormData();
            fdlIncludeFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlIncludeFilename.left = new FormAttachment(0, 0);
            fdlIncludeFilename.right = new FormAttachment(middle, -margin);
            wlIncludeFilename.setLayoutData((Object)fdlIncludeFilename);
            this.wIncludeFilename = new Button((Composite)this.shell, 32);
            PropsUi.setLook((Widget)this.wIncludeFilename);
            this.wFilenameField.addModifyListener(lsMod);
            FormData fdIncludeFilename = new FormData();
            fdIncludeFilename.top = new FormAttachment((Control)wlIncludeFilename, 0, 0x1000000);
            fdIncludeFilename.left = new FormAttachment(middle, 0);
            fdIncludeFilename.right = new FormAttachment(100, 0);
            this.wIncludeFilename.setLayoutData((Object)fdIncludeFilename);
            lastControl = this.wIncludeFilename;
        } else {
            this.wbbFilename = new Button((Composite)this.shell, 0x1000008);
            PropsUi.setLook((Widget)this.wbbFilename);
            this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
            this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
            FormData fdbFilename = new FormData();
            fdbFilename.top = new FormAttachment((Control)lastControl, margin);
            fdbFilename.right = new FormAttachment(100, 0);
            this.wbbFilename.setLayoutData((Object)fdbFilename);
            wlFilename = new Label((Composite)this.shell, 131072);
            wlFilename.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Filename.Label", (String[])new String[0]));
            PropsUi.setLook((Widget)wlFilename);
            fdlFilename = new FormData();
            fdlFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlFilename.left = new FormAttachment(0, 0);
            fdlFilename.right = new FormAttachment(middle, -margin);
            wlFilename.setLayoutData((Object)fdlFilename);
            this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
            PropsUi.setLook((Widget)this.wFilename);
            this.wFilename.addModifyListener(lsMod);
            fdFilename = new FormData();
            fdFilename.top = new FormAttachment((Control)lastControl, margin);
            fdFilename.left = new FormAttachment(middle, 0);
            fdFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
            this.wFilename.setLayoutData((Object)fdFilename);
            lastControl = this.wFilename;
        }
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Delimiter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        Button wbDelimiter = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbDelimiter);
        wbDelimiter.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Delimiter.Button", (String[])new String[0]));
        FormData fdbDelimiter = new FormData();
        fdbDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdbDelimiter.right = new FormAttachment(100, 0);
        wbDelimiter.setLayoutData((Object)fdbDelimiter);
        this.wDelimiter = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.right = new FormAttachment((Control)wbDelimiter, -margin);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        this.wDelimiter.addModifyListener(lsContent);
        lastControl = this.wDelimiter;
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Enclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        this.wEnclosure.addModifyListener(lsContent);
        lastControl = this.wEnclosure;
        Label wlBufferSize = new Label((Composite)this.shell, 131072);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.BufferSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBufferSize);
        FormData fdlBufferSize = new FormData();
        fdlBufferSize.top = new FormAttachment((Control)lastControl, margin);
        fdlBufferSize.left = new FormAttachment(0, 0);
        fdlBufferSize.right = new FormAttachment(middle, -margin);
        wlBufferSize.setLayoutData((Object)fdlBufferSize);
        this.wBufferSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBufferSize);
        this.wBufferSize.addModifyListener(lsMod);
        FormData fdBufferSize = new FormData();
        fdBufferSize.top = new FormAttachment((Control)lastControl, margin);
        fdBufferSize.left = new FormAttachment(middle, 0);
        fdBufferSize.right = new FormAttachment(100, 0);
        this.wBufferSize.setLayoutData((Object)fdBufferSize);
        lastControl = this.wBufferSize;
        Label wlLazyConversion = new Label((Composite)this.shell, 131072);
        wlLazyConversion.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.LazyConversion.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLazyConversion);
        FormData fdlLazyConversion = new FormData();
        fdlLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdlLazyConversion.left = new FormAttachment(0, 0);
        fdlLazyConversion.right = new FormAttachment(middle, -margin);
        wlLazyConversion.setLayoutData((Object)fdlLazyConversion);
        this.wLazyConversion = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wLazyConversion);
        FormData fdLazyConversion = new FormData();
        fdLazyConversion.top = new FormAttachment((Control)wlLazyConversion, 0, 0x1000000);
        fdLazyConversion.left = new FormAttachment(middle, 0);
        fdLazyConversion.right = new FormAttachment(100, 0);
        this.wLazyConversion.setLayoutData((Object)fdLazyConversion);
        lastControl = wlLazyConversion;
        Label wlHeaderPresent = new Label((Composite)this.shell, 131072);
        wlHeaderPresent.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.HeaderPresent.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHeaderPresent);
        FormData fdlHeaderPresent = new FormData();
        fdlHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdlHeaderPresent.left = new FormAttachment(0, 0);
        fdlHeaderPresent.right = new FormAttachment(middle, -margin);
        wlHeaderPresent.setLayoutData((Object)fdlHeaderPresent);
        this.wHeaderPresent = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wHeaderPresent);
        FormData fdHeaderPresent = new FormData();
        fdHeaderPresent.top = new FormAttachment((Control)wlHeaderPresent, 0, 0x1000000);
        fdHeaderPresent.left = new FormAttachment(middle, 0);
        fdHeaderPresent.right = new FormAttachment(100, 0);
        this.wHeaderPresent.setLayoutData((Object)fdHeaderPresent);
        lastControl = wlHeaderPresent;
        Label wlAddResult = new Label((Composite)this.shell, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)lastControl, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"CsvInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        lastControl = wlAddResult;
        Label wlRowNumField = new Label((Composite)this.shell, 131072);
        wlRowNumField.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.RowNumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRowNumField);
        FormData fdlRowNumField = new FormData();
        fdlRowNumField.top = new FormAttachment((Control)lastControl, margin);
        fdlRowNumField.left = new FormAttachment(0, 0);
        fdlRowNumField.right = new FormAttachment(middle, -margin);
        wlRowNumField.setLayoutData((Object)fdlRowNumField);
        this.wRowNumField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wRowNumField);
        this.wRowNumField.addModifyListener(lsMod);
        FormData fdRowNumField = new FormData();
        fdRowNumField.top = new FormAttachment((Control)wlRowNumField, 0, 0x1000000);
        fdRowNumField.left = new FormAttachment(middle, 0);
        fdRowNumField.right = new FormAttachment(100, 0);
        this.wRowNumField.setLayoutData((Object)fdRowNumField);
        lastControl = wlRowNumField;
        this.wlRunningInParallel = new Label((Composite)this.shell, 131072);
        this.wlRunningInParallel.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.RunningInParallel.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRunningInParallel);
        FormData fdlRunningInParallel = new FormData();
        fdlRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdlRunningInParallel.left = new FormAttachment(0, 0);
        fdlRunningInParallel.right = new FormAttachment(middle, -margin);
        this.wlRunningInParallel.setLayoutData((Object)fdlRunningInParallel);
        this.wRunningInParallel = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wRunningInParallel);
        FormData fdRunningInParallel = new FormData();
        fdRunningInParallel.top = new FormAttachment((Control)this.wlRunningInParallel, 0, 0x1000000);
        fdRunningInParallel.left = new FormAttachment(middle, 0);
        this.wRunningInParallel.setLayoutData((Object)fdRunningInParallel);
        lastControl = this.wlRunningInParallel;
        Label wlNewlinePossible = new Label((Composite)this.shell, 131072);
        wlNewlinePossible.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.NewlinePossible.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNewlinePossible);
        FormData fdlNewlinePossible = new FormData();
        fdlNewlinePossible.top = new FormAttachment((Control)lastControl, margin);
        fdlNewlinePossible.left = new FormAttachment(0, 0);
        fdlNewlinePossible.right = new FormAttachment(middle, -margin);
        wlNewlinePossible.setLayoutData((Object)fdlNewlinePossible);
        this.wNewlinePossible = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wNewlinePossible);
        FormData fdNewlinePossible = new FormData();
        fdNewlinePossible.top = new FormAttachment((Control)wlNewlinePossible, 0, 0x1000000);
        fdNewlinePossible.left = new FormAttachment(middle, 0);
        this.wNewlinePossible.setLayoutData((Object)fdNewlinePossible);
        this.wNewlinePossible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvInputDialog.this.setFlags();
            }
        });
        this.wNewlinePossible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CsvInputDialog.this.asyncUpdatePreview();
            }
        });
        lastControl = wlNewlinePossible;
        Label wlEncoding = new Label((Composite)this.shell, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.top = new FormAttachment((Control)wlEncoding, 0, 0x1000000);
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addModifyListener(lsContent);
        lastControl = this.wEncoding;
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)CsvInputDialog.this.shell.getDisplay(), 1);
                CsvInputDialog.this.shell.setCursor(busy);
                CsvInputDialog.this.setEncodings();
                CsvInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wSchemaDefinition = new MetaSelectionLine(this.variables, this.metadataProvider, SchemaDefinition.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"CsvInputDialog.SchemaDefinition.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.SchemaDefinition.Tooltip", (String[])new String[0]));
        PropsUi.setLook(this.wSchemaDefinition);
        FormData fdSchemaDefinition = new FormData();
        fdSchemaDefinition.left = new FormAttachment(0, 0);
        fdSchemaDefinition.top = new FormAttachment((Control)this.wEncoding, margin);
        fdSchemaDefinition.right = new FormAttachment(100, 0);
        this.wSchemaDefinition.setLayoutData((Object)fdSchemaDefinition);
        try {
            this.wSchemaDefinition.fillItems();
        }
        catch (Exception e3) {
            this.log.logError("Error getting schema definition items", (Throwable)e3);
        }
        this.wSchemaDefinition.addSelectionListener((SelectionListener)lsSelection);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setEnabled(!this.isReceivingInput);
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wPreview, this.wCancel}, margin, null);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.TypeColumn.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.FormatColumn.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.LengthColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.CurrencyColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.DecimalColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.GroupColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CsvInputDialog.TrimTypeColumn.Column", (String[])new String[0]), 2, ValueMetaBase.trimTypeDesc)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 65538, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)lastControl, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        this.wFields.setContentListener(lsContent);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview.addListener(13, e -> this.preview());
        this.wGet.addListener(13, e -> this.getFields());
        wbDelimiter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Text t = CsvInputDialog.this.wDelimiter.getTextWidget();
                if (t != null) {
                    t.insert("\t");
                }
            }
        });
        if (this.wbbFilename != null) {
            this.wbbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt;*.csv", "*.csv", "*.txt", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]) + ", " + BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)false));
        }
        this.getData();
        this.inputMeta.setChanged(this.changed);
        this.initializing = false;
        this.shell.getDisplay().asyncExec(() -> {
            if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_USAGE_INFO_PARAMETER, "Y"))) {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"CsvInputDialog.UsageInfoDialog.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.UsageInfoDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 2, new String[]{BaseMessages.getString(PKG, (String)"CsvInputDialog.UsageInfoDialog.Close", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"CsvInputDialog.UsageInfoDialog.DoNotShowAgain", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_USAGE_INFO_PARAMETER, "Y")));
                md.open();
                this.props.setCustomParameter(STRING_USAGE_INFO_PARAMETER, md.getToggleState() ? "N" : "Y");
            }
        });
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void fillFieldsLayoutFromSchema() {
        if (!this.wSchemaDefinition.isDisposed()) {
            String schemaName = this.wSchemaDefinition.getText();
            MessageBox mb = new MessageBox(this.shell, 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CsvInputDialog.Load.SchemaDefinition.Message", (String[])new String[]{schemaName}));
            mb.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Load.SchemaDefinition.Title", (String[])new String[0]));
            int answer = mb.open();
            if (answer == 64 && !Utils.isEmpty((CharSequence)schemaName)) {
                try {
                    String[] fieldNames;
                    IRowMeta r;
                    SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                    if (schemaDefinition != null && (r = schemaDefinition.getRowMeta()) != null && (fieldNames = r.getFieldNames()) != null) {
                        this.wFields.clearAll();
                        for (int i = 0; i < fieldNames.length; ++i) {
                            IValueMeta valueMeta = r.getValueMeta(i);
                            TableItem item = this.getTableItem(valueMeta.getName(), true);
                            int colnr = 1;
                            item.setText(colnr++, valueMeta.getName());
                            item.setText(colnr++, ValueMetaFactory.getValueMetaName((int)valueMeta.getType()));
                            item.setText(colnr++, Const.NVL((String)valueMeta.getConversionMask(), (String)""));
                            item.setText(colnr++, valueMeta.getLength() >= 0 ? Integer.toString(valueMeta.getLength()) : "");
                            item.setText(colnr++, valueMeta.getPrecision() >= 0 ? Integer.toString(valueMeta.getPrecision()) : "");
                            SchemaFieldDefinition schemaFieldDefinition = (SchemaFieldDefinition)schemaDefinition.getFieldDefinitions().get(i);
                            item.setText(colnr++, Const.NVL((String)schemaFieldDefinition.getCurrencySymbol(), (String)""));
                            item.setText(colnr++, Const.NVL((String)schemaFieldDefinition.getDecimalSymbol(), (String)""));
                            item.setText(colnr++, Const.NVL((String)schemaFieldDefinition.getGroupingSymbol(), (String)""));
                            item.setText(colnr++, Const.NVL((String)ValueMetaBase.getTrimTypeDesc((int)valueMeta.getTrimType()), (String)""));
                        }
                    }
                }
                catch (HopPluginException | HopTransformException throwable) {
                    // empty catch block
                }
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
            }
        }
    }

    protected void setFlags() {
        boolean parallelPossible = !this.wNewlinePossible.getSelection();
        this.wlRunningInParallel.setEnabled(parallelPossible);
        this.wRunningInParallel.setEnabled(parallelPossible);
        if (!parallelPossible) {
            this.wRunningInParallel.setSelection(false);
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public CsvInputMeta getNewMetaInstance() {
        return new CsvInputMeta();
    }

    public void populateMeta(CsvInputMeta inputMeta) {
        this.getInfo(inputMeta);
    }

    public void getData() {
        this.getData(this.inputMeta, true);
    }

    public void getData(CsvInputMeta inputMeta, boolean copyTransformName) {
        this.getData(inputMeta, copyTransformName, true, null);
    }

    public void getData(CsvInputMeta inputMeta, boolean copyTransformName, boolean reloadAllFields, List<String> newFieldNames) {
        if (copyTransformName) {
            this.wTransformName.setText(this.transformName);
        }
        if (this.isReceivingInput) {
            this.wFilenameField.setText(Const.NVL((String)inputMeta.getFilenameField(), (String)""));
            this.wIncludeFilename.setSelection(inputMeta.isIncludingFilename());
        } else {
            this.wFilename.setText(Const.NVL((String)inputMeta.getFilename(), (String)""));
        }
        this.wDelimiter.setText(Const.NVL((String)inputMeta.getDelimiter(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)inputMeta.getEnclosure(), (String)""));
        this.wBufferSize.setText(Const.NVL((String)inputMeta.getBufferSize(), (String)""));
        this.wLazyConversion.setSelection(inputMeta.isLazyConversionActive());
        this.wHeaderPresent.setSelection(inputMeta.isHeaderPresent());
        this.wRunningInParallel.setSelection(inputMeta.isRunningInParallel());
        this.wNewlinePossible.setSelection(inputMeta.isNewlinePossibleInFields());
        this.wRowNumField.setText(Const.NVL((String)inputMeta.getRowNumField(), (String)""));
        this.wAddResult.setSelection(inputMeta.isAddResultFile());
        this.wEncoding.setText(Const.NVL((String)inputMeta.getEncoding(), (String)""));
        this.wSchemaDefinition.setText(Const.NVL((String)inputMeta.getSchemaDefinition(), (String)""));
        ArrayList fieldName = newFieldNames == null ? new ArrayList() : newFieldNames;
        for (int i = 0; i < inputMeta.getInputFields().length; ++i) {
            TextFileInputField field = inputMeta.getInputFields()[i];
            TableItem item = this.getTableItem(field.getName(), true);
            if (!reloadAllFields && !fieldName.contains(field.getName())) continue;
            int colnr = 1;
            item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
            item.setText(colnr++, ValueMetaFactory.getValueMetaName((int)field.getType()));
            item.setText(colnr++, Const.NVL((String)field.getFormat(), (String)""));
            item.setText(colnr++, field.getLength() >= 0 ? Integer.toString(field.getLength()) : "");
            item.setText(colnr++, field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "");
            item.setText(colnr++, Const.NVL((String)field.getCurrencySymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getGroupSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getTrimTypeDesc(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.inputMeta.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(CsvInputMeta inputMeta) {
        if (this.isReceivingInput) {
            inputMeta.setFilenameField(this.wFilenameField.getText());
            inputMeta.setIncludingFilename(this.wIncludeFilename.getSelection());
        } else {
            inputMeta.setFilename(this.wFilename.getText());
        }
        inputMeta.setDelimiter(this.wDelimiter.getText());
        inputMeta.setEnclosure(this.wEnclosure.getText());
        inputMeta.setBufferSize(this.wBufferSize.getText());
        inputMeta.setLazyConversionActive(this.wLazyConversion.getSelection());
        inputMeta.setHeaderPresent(this.wHeaderPresent.getSelection());
        inputMeta.setRowNumField(this.wRowNumField.getText());
        inputMeta.setAddResultFile(this.wAddResult.getSelection());
        inputMeta.setRunningInParallel(this.wRunningInParallel.getSelection());
        inputMeta.setNewlinePossibleInFields(this.wNewlinePossible.getSelection());
        inputMeta.setEncoding(this.wEncoding.getText());
        inputMeta.setSchemaDefinition(this.wSchemaDefinition.getText());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        inputMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            inputMeta.getInputFields()[i] = new TextFileInputField();
            int colnr = 1;
            inputMeta.getInputFields()[i].setName(item.getText(colnr++));
            inputMeta.getInputFields()[i].setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(colnr++)));
            inputMeta.getInputFields()[i].setFormat(item.getText(colnr++));
            inputMeta.getInputFields()[i].setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            inputMeta.getInputFields()[i].setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            inputMeta.getInputFields()[i].setCurrencySymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setDecimalSymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setGroupSymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setTrimType(ValueMetaBase.getTrimTypeByDesc((String)item.getText(colnr++)));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        inputMeta.setChanged();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.inputMeta);
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private InputStreamReader getReader(CsvInputMeta meta, InputStream inputStream) {
        InputStreamReader reader = null;
        try {
            String filename = this.variables.resolve(meta.getFilename());
            FileObject fileObject = HopVfs.getFileObject((String)filename, (IVariables)this.variables);
            if (!(fileObject instanceof LocalFile)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"CsvInput.Log.OnlyLocalFilesAreSupported", (String[])new String[0]));
            }
            String realEncoding = this.variables.resolve(meta.getEncoding());
            reader = Utils.isEmpty((CharSequence)realEncoding) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, realEncoding);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorGettingFileDesc.DialogMessage", (String[])new String[0]), e);
        }
        return reader;
    }

    private InputStream getInputStream(CsvInputMeta meta) {
        InputStream inputStream = null;
        try {
            String filename = this.variables.resolve(meta.getFilename());
            FileObject fileObject = HopVfs.getFileObject((String)filename, (IVariables)this.variables);
            if (!(fileObject instanceof LocalFile)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"CsvInput.Log.OnlyLocalFilesAreSupported", (String[])new String[0]));
            }
            inputStream = HopVfs.getInputStream((FileObject)fileObject);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorGettingFileDesc.DialogMessage", (String[])new String[0]), e);
        }
        return inputStream;
    }

    public String[] getFieldNames(CsvInputMeta meta) {
        return this.getFieldNames(meta);
    }

    public TableView getFieldsTable() {
        return this.wFields;
    }

    public String loadFieldsImpl(CsvInputMeta meta, int samples) {
        return this.loadFieldsImpl(meta, samples);
    }

    private synchronized void preview() {
        CsvInputMeta oneMeta = new CsvInputMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePreview() {
        if (this.initializing) {
            return;
        }
        if (this.previewBusy.get()) {
            return;
        }
        try {
            this.previewBusy.set(true);
            CsvInputMeta meta = new CsvInputMeta();
            this.getInfo(meta);
            if (Utils.isEmpty((CharSequence)meta.getFilename())) {
                return;
            }
            if (Utils.isEmpty((Object[])meta.getInputFields())) {
                return;
            }
            String transformName = this.wTransformName.getText();
            StringBuffer buffer = new StringBuffer();
            final ArrayList rowsData = new ArrayList();
            RowMeta rowMeta = new RowMeta();
            try {
                meta.getFields((IRowMeta)rowMeta, transformName, null, null, this.variables, this.metadataProvider);
                PipelineMeta previewPipelineMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)meta, (String)transformName);
                LocalPipelineEngine pipeline = new LocalPipelineEngine(previewPipelineMeta);
                pipeline.prepareExecution();
                ITransform transform = pipeline.getRunThread(transformName, 0);
                transform.addRowListener((IRowListener)new RowAdapter((Pipeline)pipeline){
                    final /* synthetic */ Pipeline val$pipeline;
                    {
                        this.val$pipeline = pipeline;
                    }

                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        rowsData.add(row);
                        if (rowsData.size() > PropsUi.getInstance().getDefaultPreviewSize()) {
                            this.val$pipeline.stopAll();
                        }
                    }
                });
                pipeline.startThreads();
                pipeline.waitUntilFinished();
                if (pipeline.getErrors() > 0) {
                    StringBuffer log = HopLogStore.getAppender().getBuffer(pipeline.getLogChannelId(), false);
                    buffer.append(log);
                }
                HopLogStore.discardLines((String)pipeline.getLogChannelId(), (boolean)false);
                LoggingRegistry.getInstance().removeIncludingChildren(pipeline.getLogChannelId());
            }
            catch (Exception e) {
                buffer.append(Const.getStackTracker((Throwable)e));
            }
            HopGuiPipelineGraph pipelineGraph = (HopGuiPipelineGraph)HopGui.getInstance().getActiveFileTypeHandler();
            if (pipelineGraph != null) {
                if (!pipelineGraph.isExecutionResultsPaneVisible()) {
                    pipelineGraph.showExecutionResults();
                }
                pipelineGraph.extraViewTabFolder.setSelection(5);
            }
        }
        finally {
            this.previewBusy.set(false);
        }
    }

    protected void asyncUpdatePreview() {
        Runnable update = () -> {
            try {
                this.updatePreview();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        };
        this.shell.getDisplay().asyncExec(update);
    }

    public Shell getShell() {
        return this.shell;
    }

    public ICsvInputAwareImportProgressDialog getCsvImportProgressDialog(ICsvInputAwareMeta meta, int samples, InputStreamReader reader) {
        return new TextFileCSVImportProgressDialog(this.getShell(), this.variables, (CsvInputMeta)meta, this.pipelineMeta, reader, samples, true);
    }

    public LogChannel getLogChannel() {
        return this.log;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public InputStream getInputStream(ICsvInputAwareMeta meta) {
        InputStream inputStream = null;
        try {
            FileObject fileObject = meta.getHeaderFileObject(this.variables);
            if (!(fileObject instanceof LocalFile)) {
                throw new HopException(BaseMessages.getString((String)"FileInputDialog.Log.OnlyLocalFilesAreSupported"));
            }
            inputStream = HopVfs.getInputStream((FileObject)fileObject);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString((String)"FileInputDialog.ErrorGettingFileDesc.DialogMessage"), e);
        }
        return inputStream;
    }
}

